/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.listener.Listener;
import it.auties.whatsapp.listener.RegisterListener;
import it.auties.whatsapp.util.Validate;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.NoSuchElementException;

public final class ListenerScanner {
    private static final List<Class<?>> cache = ListenerScanner.loadListeners();

    private static List<Class<?>> loadListeners() {
        try (ScanResult scanner = ListenerScanner.createScanner();){
            List list = scanner.getClassesWithAnnotation(RegisterListener.class).loadClasses();
            return list;
        }
    }

    public static List<Listener> scan(Whatsapp whatsapp, boolean useCache) {
        List<Class<?>> listeners = useCache ? cache : ListenerScanner.loadListeners();
        return cache.stream().map(listener -> ListenerScanner.initialize(listener, whatsapp)).toList();
    }

    private static ScanResult createScanner() {
        return new ClassGraph().enableClassInfo().enableAnnotationInfo().scan();
    }

    private static Listener initialize(Class<?> listener, Whatsapp whatsapp) {
        Validate.isTrue(Listener.class.isAssignableFrom(listener), "Cannot initialize listener at %s: cannot register classes that don't implement WhatsappListener", listener.getName(), IllegalArgumentException.class);
        try {
            Object[] objectArray;
            Class[] classArray;
            if (whatsapp == null) {
                classArray = new Class[]{};
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Whatsapp.class;
            }
            Constructor<?> constructor = listener.getConstructor(classArray);
            if (whatsapp == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = whatsapp;
            }
            return (Listener)constructor.newInstance(objectArray);
        }
        catch (NoSuchMethodException noArgsConstructorException) {
            if (whatsapp != null) {
                return ListenerScanner.initialize(listener, null);
            }
            throw new NoSuchElementException("Cannot initialize listener at %s: no applicable constructor was found. Create a public no args constructor or a Whatsapp constructor".formatted(listener.getName()), noArgsConstructorException);
        }
        catch (IllegalAccessException accessException) {
            throw new IllegalArgumentException("Cannot initialize listener at %s: inaccessible module. Mark module %s as open in order to allow registration".formatted(listener.getName(), listener.getModule().getName()), accessException);
        }
        catch (InvocationTargetException invocationException) {
            throw new IllegalArgumentException("Cannot initialize listener at %s: an error occurred while initializing the class(check its static initializers)".formatted(listener.getName()), invocationException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Cannot initialize listener at %s: an error occurred while initializing the class(check its constructor)".formatted(listener.getName()), instantiationException);
        }
    }
}

