/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.function.Supplier;

public final class Validate {
    public static void isTrue(boolean value, String message, Object ... args) {
        Validate.isTrue(value, message, IllegalArgumentException.class, args);
    }

    public static <T extends Throwable> void isTrue(boolean value, Class<? extends Throwable> throwable) throws T {
        Validate.isTrue(value, null, throwable, new Object[0]);
    }

    public static <T extends Throwable> void isTrue(boolean value, Supplier<T> throwableSupplier) throws T {
        if (value) {
            return;
        }
        throw (Throwable)throwableSupplier.get();
    }

    public static <T extends Throwable> void isTrue(boolean value, String message, Class<? extends Throwable> throwable, Object ... args) throws T {
        if (value) {
            return;
        }
        throw Validate.createThrowable(throwable, message == null ? null : message.formatted(args));
    }

    private static Throwable createThrowable(Class<? extends Throwable> throwable, String formattedMessage) {
        try {
            Throwable result = formattedMessage == null ? throwable.getConstructor(new Class[0]).newInstance(new Object[0]) : throwable.getConstructor(String.class).newInstance(formattedMessage);
            StackTraceElement[] stackTrace = (StackTraceElement[])Arrays.stream(result.getStackTrace()).filter(entry -> !entry.getClassName().equals(Validate.class.getName()) && !entry.getClassName().equals(Constructor.class.getName())).toArray(StackTraceElement[]::new);
            result.setStackTrace(stackTrace);
            return result;
        }
        catch (Throwable ignored) {
            return new RuntimeException(formattedMessage);
        }
    }
}

