package it.auties.whatsapp.api;

import it.auties.whatsapp.api.WebHistoryLength;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class WebHistoryLengthSpec {
    public static byte[] encode(WebHistoryLength protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, protoInputObject.size());
      return outputStream.toByteArray();
    }

    public static WebHistoryLength decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        int size = 0;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> size = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.api.WebHistoryLength(size);
    }

}
