package it.auties.whatsapp.controller;

import it.auties.whatsapp.controller.Store;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class StoreSpec {
    public static byte[] encode(Store protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var uuid = protoInputObject.uuid;
if(uuid != null) {
var uuid0 = it.auties.whatsapp.util.ProtobufUuidMixin.toValue(uuid);
if(uuid0 != null) {
outputStream.writeString(1, uuid0);
}
}
var phoneNumber = protoInputObject.phoneNumber();
if(phoneNumber != null) {
var phoneNumber0 = phoneNumber.orElse(null);
if(phoneNumber0 != null) {
var phoneNumber1 = phoneNumber0.number();
outputStream.writeUInt64(2, phoneNumber1);
}
}
outputStream.writeInt32(3, it.auties.whatsapp.api.ClientTypeSpec.encode(protoInputObject.clientType));
      if(protoInputObject.alias != null) {
       for(var aliasEntry : protoInputObject.alias) {
outputStream.writeString(4, aliasEntry);
       }
      }
var proxy = protoInputObject.proxy;
if(proxy != null) {
var proxy0 = it.auties.whatsapp.util.ProtobufUriMixin.toValue(proxy);
if(proxy0 != null) {
outputStream.writeString(5, proxy0);
}
}
var version = protoInputObject.version;
if(version != null) {
var version0 = version.value();
if(version0 != null) {
outputStream.writeBytes(6, it.auties.whatsapp.model.signal.auth.VersionSpec.encode(version0));
}
}
outputStream.writeBool(7, protoInputObject.online);
outputStream.writeBytes(8, it.auties.whatsapp.model.mobile.CountryLocaleSpec.encode(protoInputObject.locale));
outputStream.writeString(9, protoInputObject.name);
outputStream.writeString(40, protoInputObject.verifiedName);
outputStream.writeString(10, protoInputObject.businessAddress);
outputStream.writeDouble(11, protoInputObject.businessLongitude);
outputStream.writeDouble(12, protoInputObject.businessLatitude);
outputStream.writeString(13, protoInputObject.businessDescription);
outputStream.writeString(14, protoInputObject.businessWebsite);
outputStream.writeString(15, protoInputObject.businessEmail);
outputStream.writeBytes(16, it.auties.whatsapp.model.business.BusinessCategorySpec.encode(protoInputObject.businessCategory));
outputStream.writeString(17, protoInputObject.deviceHash);
      if(protoInputObject.linkedDevicesKeys != null) {
            for(var linkedDevicesKeysEntry : protoInputObject.linkedDevicesKeys.entrySet()) {
                var linkedDevicesKeysOutputStream = new ProtobufOutputStream();
var linkedDevicesKeys = linkedDevicesKeysEntry.getKey();
if(linkedDevicesKeys != null) {
var linkedDevicesKeys0 = linkedDevicesKeys.toString();
if(linkedDevicesKeys0 != null) {
linkedDevicesKeysOutputStream.writeString(1, linkedDevicesKeys0);
}
}
linkedDevicesKeysOutputStream.writeInt32(2, linkedDevicesKeysEntry.getValue());
                outputStream.writeBytes(18, linkedDevicesKeysOutputStream.toByteArray());
            }
      }
var profilePicture = protoInputObject.profilePicture;
if(profilePicture != null) {
var profilePicture0 = it.auties.whatsapp.util.ProtobufUriMixin.toValue(profilePicture);
if(profilePicture0 != null) {
outputStream.writeString(19, profilePicture0);
}
}
outputStream.writeString(20, protoInputObject.about);
var jid = protoInputObject.jid;
if(jid != null) {
var jid0 = jid.toString();
if(jid0 != null) {
outputStream.writeString(21, jid0);
}
}
var lid = protoInputObject.lid;
if(lid != null) {
var lid0 = lid.toString();
if(lid0 != null) {
outputStream.writeString(22, lid0);
}
}
      if(protoInputObject.properties != null) {
            for(var propertiesEntry : protoInputObject.properties.entrySet()) {
                var propertiesOutputStream = new ProtobufOutputStream();
propertiesOutputStream.writeString(1, propertiesEntry.getKey());
propertiesOutputStream.writeString(2, propertiesEntry.getValue());
                outputStream.writeBytes(23, propertiesOutputStream.toByteArray());
            }
      }
      if(protoInputObject.contacts != null) {
            for(var contactsEntry : protoInputObject.contacts.entrySet()) {
                var contactsOutputStream = new ProtobufOutputStream();
var contacts = contactsEntry.getKey();
if(contacts != null) {
var contacts0 = contacts.toString();
if(contacts0 != null) {
contactsOutputStream.writeString(1, contacts0);
}
}
contactsOutputStream.writeBytes(2, it.auties.whatsapp.model.contact.ContactSpec.encode(contactsEntry.getValue()));
                outputStream.writeBytes(24, contactsOutputStream.toByteArray());
            }
      }
      if(protoInputObject.status != null) {
       for(var statusEntry : protoInputObject.status) {
outputStream.writeBytes(25, it.auties.whatsapp.model.info.ChatMessageInfoSpec.encode(statusEntry));
       }
      }
      if(protoInputObject.privacySettings != null) {
            for(var privacySettingsEntry : protoInputObject.privacySettings.entrySet()) {
                var privacySettingsOutputStream = new ProtobufOutputStream();
privacySettingsOutputStream.writeString(1, privacySettingsEntry.getKey());
privacySettingsOutputStream.writeBytes(2, it.auties.whatsapp.model.privacy.PrivacySettingEntrySpec.encode(privacySettingsEntry.getValue()));
                outputStream.writeBytes(26, privacySettingsOutputStream.toByteArray());
            }
      }
      if(protoInputObject.calls != null) {
            for(var callsEntry : protoInputObject.calls.entrySet()) {
                var callsOutputStream = new ProtobufOutputStream();
callsOutputStream.writeString(1, callsEntry.getKey());
callsOutputStream.writeBytes(2, it.auties.whatsapp.model.call.CallSpec.encode(callsEntry.getValue()));
                outputStream.writeBytes(27, callsOutputStream.toByteArray());
            }
      }
outputStream.writeBool(28, protoInputObject.unarchiveChats);
outputStream.writeBool(29, protoInputObject.twentyFourHourFormat);
outputStream.writeUInt64(30, protoInputObject.initializationTimeStamp);
outputStream.writeInt32(31, it.auties.whatsapp.model.chat.ChatEphemeralTimerSpec.encode(protoInputObject.newChatsEphemeralTimer));
outputStream.writeInt32(32, it.auties.whatsapp.api.TextPreviewSettingSpec.encode(protoInputObject.textPreviewSetting));
outputStream.writeBytes(33, it.auties.whatsapp.api.WebHistoryLengthSpec.encode(protoInputObject.historyLength));
outputStream.writeBool(34, protoInputObject.autodetectListeners);
outputStream.writeBool(35, protoInputObject.cacheDetectedListeners);
outputStream.writeBool(36, protoInputObject.automaticPresenceUpdates);
outputStream.writeInt32(37, it.auties.whatsapp.model.signal.auth.UserAgentReleaseChannelSpec.encode(protoInputObject.releaseChannel));
outputStream.writeBytes(38, it.auties.whatsapp.model.companion.CompanionDeviceSpec.encode(protoInputObject.device));
outputStream.writeBool(39, protoInputObject.checkPatchMacs);
      return outputStream.toByteArray();
    }

    public static Store decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.util.UUID uuid = null;
        it.auties.whatsapp.model.mobile.PhoneNumber phoneNumber = null;
        it.auties.whatsapp.api.ClientType clientType = null;
        java.util.Collection<java.lang.String> alias = new java.util.ArrayList<java.lang.String>();
        java.net.URI proxy = null;
        it.auties.whatsapp.util.FutureReference<it.auties.whatsapp.model.signal.auth.Version> version = null;
        boolean online = false;
        it.auties.whatsapp.model.mobile.CountryLocale locale = null;
        java.lang.String name = null;
        java.lang.String verifiedName = null;
        java.lang.String businessAddress = null;
        java.lang.Double businessLongitude = null;
        java.lang.Double businessLatitude = null;
        java.lang.String businessDescription = null;
        java.lang.String businessWebsite = null;
        java.lang.String businessEmail = null;
        it.auties.whatsapp.model.business.BusinessCategory businessCategory = null;
        java.lang.String deviceHash = null;
        java.util.LinkedHashMap<it.auties.whatsapp.model.jid.Jid,java.lang.Integer> linkedDevicesKeys = new java.util.LinkedHashMap<it.auties.whatsapp.model.jid.Jid,java.lang.Integer>();
        java.net.URI profilePicture = null;
        java.lang.String about = null;
        it.auties.whatsapp.model.jid.Jid jid = null;
        it.auties.whatsapp.model.jid.Jid lid = null;
        java.util.concurrent.ConcurrentHashMap<java.lang.String,java.lang.String> properties = new java.util.concurrent.ConcurrentHashMap<java.lang.String,java.lang.String>();
        java.util.concurrent.ConcurrentHashMap<it.auties.whatsapp.model.jid.Jid,it.auties.whatsapp.model.contact.Contact> contacts = new java.util.concurrent.ConcurrentHashMap<it.auties.whatsapp.model.jid.Jid,it.auties.whatsapp.model.contact.Contact>();
        java.util.concurrent.ConcurrentHashMap.KeySetView<it.auties.whatsapp.model.info.ChatMessageInfo,java.lang.Boolean> status = java.util.concurrent.ConcurrentHashMap.newKeySet();
        java.util.concurrent.ConcurrentHashMap<java.lang.String,it.auties.whatsapp.model.privacy.PrivacySettingEntry> privacySettings = new java.util.concurrent.ConcurrentHashMap<java.lang.String,it.auties.whatsapp.model.privacy.PrivacySettingEntry>();
        java.util.concurrent.ConcurrentHashMap<java.lang.String,it.auties.whatsapp.model.call.Call> calls = new java.util.concurrent.ConcurrentHashMap<java.lang.String,it.auties.whatsapp.model.call.Call>();
        boolean unarchiveChats = false;
        boolean twentyFourHourFormat = false;
        long initializationTimeStamp = 0l;
        it.auties.whatsapp.model.chat.ChatEphemeralTimer newChatsEphemeralTimer = null;
        it.auties.whatsapp.api.TextPreviewSetting textPreviewSetting = null;
        it.auties.whatsapp.api.WebHistoryLength historyLength = null;
        boolean autodetectListeners = false;
        boolean cacheDetectedListeners = false;
        boolean automaticPresenceUpdates = false;
        it.auties.whatsapp.model.signal.auth.UserAgent.ReleaseChannel releaseChannel = null;
        it.auties.whatsapp.model.companion.CompanionDevice device = null;
        boolean checkPatchMacs = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> uuid = it.auties.whatsapp.util.ProtobufUuidMixin.of(inputStream.readString());
                case 2 -> phoneNumber = it.auties.whatsapp.model.mobile.PhoneNumber.of(inputStream.readInt64());
                case 3 -> clientType = it.auties.whatsapp.api.ClientTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 4 -> alias.add(inputStream.readString());
                case 5 -> proxy = it.auties.whatsapp.util.ProtobufUriMixin.of(inputStream.readString());
                case 6 -> version = it.auties.whatsapp.util.FutureReference.of(it.auties.whatsapp.model.signal.auth.VersionSpec.decode(inputStream.readBytes()));
                case 7 -> online = inputStream.readBool();
                case 8 -> locale = it.auties.whatsapp.model.mobile.CountryLocaleSpec.decode(inputStream.readBytes());
                case 9 -> name = inputStream.readString();
                case 40 -> verifiedName = inputStream.readString();
                case 10 -> businessAddress = inputStream.readString();
                case 11 -> businessLongitude = inputStream.readDouble();
                case 12 -> businessLatitude = inputStream.readDouble();
                case 13 -> businessDescription = inputStream.readString();
                case 14 -> businessWebsite = inputStream.readString();
                case 15 -> businessEmail = inputStream.readString();
                case 16 -> businessCategory = it.auties.whatsapp.model.business.BusinessCategorySpec.decode(inputStream.readBytes());
                case 17 -> deviceHash = inputStream.readString();
                case 18 -> {
                        var linkedDevicesKeysInputStream = new ProtobufInputStream(inputStream.readBytes());
                        it.auties.whatsapp.model.jid.Jid linkedDevicesKeysKey = null;
                        java.lang.Integer linkedDevicesKeysValue = null;
                        while(linkedDevicesKeysInputStream.readTag()) {
                            switch(linkedDevicesKeysInputStream.index()) {
                                case 1 -> linkedDevicesKeysKey = it.auties.whatsapp.model.jid.Jid.ofProtobuf(linkedDevicesKeysInputStream.readString());
                                case 2 -> linkedDevicesKeysValue = linkedDevicesKeysInputStream.readInt32();
                            }
                        }
                        linkedDevicesKeys.put(linkedDevicesKeysKey, linkedDevicesKeysValue);
                }
                case 19 -> profilePicture = it.auties.whatsapp.util.ProtobufUriMixin.of(inputStream.readString());
                case 20 -> about = inputStream.readString();
                case 21 -> jid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 22 -> lid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 23 -> {
                        var propertiesInputStream = new ProtobufInputStream(inputStream.readBytes());
                        java.lang.String propertiesKey = null;
                        java.lang.String propertiesValue = null;
                        while(propertiesInputStream.readTag()) {
                            switch(propertiesInputStream.index()) {
                                case 1 -> propertiesKey = propertiesInputStream.readString();
                                case 2 -> propertiesValue = propertiesInputStream.readString();
                            }
                        }
                        properties.put(propertiesKey, propertiesValue);
                }
                case 24 -> {
                        var contactsInputStream = new ProtobufInputStream(inputStream.readBytes());
                        it.auties.whatsapp.model.jid.Jid contactsKey = null;
                        it.auties.whatsapp.model.contact.Contact contactsValue = null;
                        while(contactsInputStream.readTag()) {
                            switch(contactsInputStream.index()) {
                                case 1 -> contactsKey = it.auties.whatsapp.model.jid.Jid.ofProtobuf(contactsInputStream.readString());
                                case 2 -> contactsValue = it.auties.whatsapp.model.contact.ContactSpec.decode(contactsInputStream.readBytes());
                            }
                        }
                        contacts.put(contactsKey, contactsValue);
                }
                case 25 -> status.add(it.auties.whatsapp.model.info.ChatMessageInfoSpec.decode(inputStream.readBytes()));
                case 26 -> {
                        var privacySettingsInputStream = new ProtobufInputStream(inputStream.readBytes());
                        java.lang.String privacySettingsKey = null;
                        it.auties.whatsapp.model.privacy.PrivacySettingEntry privacySettingsValue = null;
                        while(privacySettingsInputStream.readTag()) {
                            switch(privacySettingsInputStream.index()) {
                                case 1 -> privacySettingsKey = privacySettingsInputStream.readString();
                                case 2 -> privacySettingsValue = it.auties.whatsapp.model.privacy.PrivacySettingEntrySpec.decode(privacySettingsInputStream.readBytes());
                            }
                        }
                        privacySettings.put(privacySettingsKey, privacySettingsValue);
                }
                case 27 -> {
                        var callsInputStream = new ProtobufInputStream(inputStream.readBytes());
                        java.lang.String callsKey = null;
                        it.auties.whatsapp.model.call.Call callsValue = null;
                        while(callsInputStream.readTag()) {
                            switch(callsInputStream.index()) {
                                case 1 -> callsKey = callsInputStream.readString();
                                case 2 -> callsValue = it.auties.whatsapp.model.call.CallSpec.decode(callsInputStream.readBytes());
                            }
                        }
                        calls.put(callsKey, callsValue);
                }
                case 28 -> unarchiveChats = inputStream.readBool();
                case 29 -> twentyFourHourFormat = inputStream.readBool();
                case 30 -> initializationTimeStamp = inputStream.readInt64();
                case 31 -> newChatsEphemeralTimer = it.auties.whatsapp.model.chat.ChatEphemeralTimerSpec.decode(inputStream.readInt32()).orElse(null);
                case 32 -> textPreviewSetting = it.auties.whatsapp.api.TextPreviewSettingSpec.decode(inputStream.readInt32()).orElse(null);
                case 33 -> historyLength = it.auties.whatsapp.api.WebHistoryLengthSpec.decode(inputStream.readBytes());
                case 34 -> autodetectListeners = inputStream.readBool();
                case 35 -> cacheDetectedListeners = inputStream.readBool();
                case 36 -> automaticPresenceUpdates = inputStream.readBool();
                case 37 -> releaseChannel = it.auties.whatsapp.model.signal.auth.UserAgentReleaseChannelSpec.decode(inputStream.readInt32()).orElse(null);
                case 38 -> device = it.auties.whatsapp.model.companion.CompanionDeviceSpec.decode(inputStream.readBytes());
                case 39 -> checkPatchMacs = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.controller.Store(uuid, phoneNumber, clientType, alias, proxy, version, online, locale, name, verifiedName, businessAddress, businessLongitude, businessLatitude, businessDescription, businessWebsite, businessEmail, businessCategory, deviceHash, linkedDevicesKeys, profilePicture, about, jid, lid, properties, contacts, status, privacySettings, calls, unarchiveChats, twentyFourHourFormat, initializationTimeStamp, newChatsEphemeralTimer, textPreviewSetting, historyLength, autodetectListeners, cacheDetectedListeners, automaticPresenceUpdates, releaseChannel, device, checkPatchMacs);
    }

}
