package it.auties.whatsapp.model.business;

import it.auties.whatsapp.model.business.BusinessCategory;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class BusinessCategorySpec {
    public static byte[] encode(BusinessCategory protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.id());
outputStream.writeString(2, protoInputObject.name());
      return outputStream.toByteArray();
    }

    public static BusinessCategory decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String id = null;
        java.lang.String name = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> id = inputStream.readString();
                case 2 -> name = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.business.BusinessCategory(id, name);
    }

}
