package it.auties.whatsapp.model.button.interactive;

import it.auties.whatsapp.model.button.interactive.InteractiveLocationAnnotation;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class InteractiveLocationAnnotationSpec {
    public static byte[] encode(InteractiveLocationAnnotation protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
      if(protoInputObject.polygonVertices() != null) {
       for(var polygonVerticesEntry : protoInputObject.polygonVertices()) {
outputStream.writeBytes(1, it.auties.whatsapp.model.button.interactive.InteractivePointSpec.encode(polygonVerticesEntry));
       }
      }
outputStream.writeBytes(2, it.auties.whatsapp.model.button.interactive.InterativeLocationSpec.encode(protoInputObject.location()));
      return outputStream.toByteArray();
    }

    public static InteractiveLocationAnnotation decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.util.List<it.auties.whatsapp.model.button.interactive.InteractivePoint> polygonVertices = new java.util.ArrayList<it.auties.whatsapp.model.button.interactive.InteractivePoint>();
        it.auties.whatsapp.model.button.interactive.InterativeLocation location = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> polygonVertices.add(it.auties.whatsapp.model.button.interactive.InteractivePointSpec.decode(inputStream.readBytes()));
                case 2 -> location = it.auties.whatsapp.model.button.interactive.InterativeLocationSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.interactive.InteractiveLocationAnnotation(polygonVertices, location);
    }

}
