package it.auties.whatsapp.model.button.template.highlyStructured;

import it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class HighlyStructuredMessageSpec {
    public static byte[] encode(HighlyStructuredMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.namespace());
outputStream.writeString(2, protoInputObject.elementName());
      if(protoInputObject.params() != null) {
       for(var paramsEntry : protoInputObject.params()) {
outputStream.writeString(3, paramsEntry);
       }
      }
var fallbackLg = protoInputObject.fallbackLg();
var fallbackLg0 = fallbackLg.orElse(null);
if(fallbackLg0 != null) {
outputStream.writeString(4, fallbackLg0);
}
var fallbackLc = protoInputObject.fallbackLc();
var fallbackLc0 = fallbackLc.orElse(null);
if(fallbackLc0 != null) {
outputStream.writeString(5, fallbackLc0);
}
      if(protoInputObject.localizableParameters() != null) {
       for(var localizableParametersEntry : protoInputObject.localizableParameters()) {
outputStream.writeBytes(6, it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredLocalizableParameterSpec.encode(localizableParametersEntry));
       }
      }
var deterministicLg = protoInputObject.deterministicLg();
var deterministicLg0 = deterministicLg.orElse(null);
if(deterministicLg0 != null) {
outputStream.writeString(7, deterministicLg0);
}
var deterministicLc = protoInputObject.deterministicLc();
var deterministicLc0 = deterministicLc.orElse(null);
if(deterministicLc0 != null) {
outputStream.writeString(8, deterministicLc0);
}
outputStream.writeBytes(9, it.auties.whatsapp.model.message.button.TemplateMessageSpec.encode(protoInputObject.templateMessage()));
      return outputStream.toByteArray();
    }

    public static HighlyStructuredMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String namespace = null;
        java.lang.String elementName = null;
        java.util.List<java.lang.String> params = new java.util.ArrayList<java.lang.String>();
        java.util.Optional<java.lang.String> fallbackLg = java.util.Optional.empty();
        java.util.Optional<java.lang.String> fallbackLc = java.util.Optional.empty();
        java.util.List<it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredLocalizableParameter> localizableParameters = new java.util.ArrayList<it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredLocalizableParameter>();
        java.util.Optional<java.lang.String> deterministicLg = java.util.Optional.empty();
        java.util.Optional<java.lang.String> deterministicLc = java.util.Optional.empty();
        it.auties.whatsapp.model.message.button.TemplateMessage templateMessage = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> namespace = inputStream.readString();
                case 2 -> elementName = inputStream.readString();
                case 3 -> params.add(inputStream.readString());
                case 4 -> fallbackLg = java.util.Optional.ofNullable(inputStream.readString());
                case 5 -> fallbackLc = java.util.Optional.ofNullable(inputStream.readString());
                case 6 -> localizableParameters.add(it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredLocalizableParameterSpec.decode(inputStream.readBytes()));
                case 7 -> deterministicLg = java.util.Optional.ofNullable(inputStream.readString());
                case 8 -> deterministicLc = java.util.Optional.ofNullable(inputStream.readString());
                case 9 -> templateMessage = it.auties.whatsapp.model.message.button.TemplateMessageSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredMessage(namespace, elementName, params, fallbackLg, fallbackLc, localizableParameters, deterministicLg, deterministicLc, templateMessage);
    }

}
