package it.auties.whatsapp.model.button.template.hydrated;

import it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplate;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class HydratedFourRowTemplateSpec {
    public static byte[] encode(HydratedFourRowTemplate protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var titleDocument = protoInputObject.titleDocument();
var titleDocument0 = titleDocument.orElse(null);
if(titleDocument0 != null) {
outputStream.writeBytes(1, it.auties.whatsapp.model.message.standard.DocumentMessageSpec.encode(titleDocument0));
}
var titleText = protoInputObject.titleText();
var titleText0 = titleText.orElse(null);
if(titleText0 != null) {
var titleText1 = titleText0.text();
if(titleText1 != null) {
outputStream.writeString(2, titleText1);
}
}
var titleImage = protoInputObject.titleImage();
var titleImage0 = titleImage.orElse(null);
if(titleImage0 != null) {
outputStream.writeBytes(3, it.auties.whatsapp.model.message.standard.ImageMessageSpec.encode(titleImage0));
}
var titleVideo = protoInputObject.titleVideo();
var titleVideo0 = titleVideo.orElse(null);
if(titleVideo0 != null) {
outputStream.writeBytes(4, it.auties.whatsapp.model.message.standard.VideoOrGifMessageSpec.encode(titleVideo0));
}
var titleLocation = protoInputObject.titleLocation();
var titleLocation0 = titleLocation.orElse(null);
if(titleLocation0 != null) {
outputStream.writeBytes(5, it.auties.whatsapp.model.message.standard.LocationMessageSpec.encode(titleLocation0));
}
outputStream.writeString(6, protoInputObject.body());
var footer = protoInputObject.footer();
var footer0 = footer.orElse(null);
if(footer0 != null) {
outputStream.writeString(7, footer0);
}
      if(protoInputObject.hydratedButtons() != null) {
       for(var hydratedButtonsEntry : protoInputObject.hydratedButtons()) {
outputStream.writeBytes(8, it.auties.whatsapp.model.button.template.hydrated.HydratedTemplateButtonSpec.encode(hydratedButtonsEntry));
       }
      }
outputStream.writeString(9, protoInputObject.templateId());
      return outputStream.toByteArray();
    }

    public static HydratedFourRowTemplate decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.util.Optional<it.auties.whatsapp.model.message.standard.DocumentMessage> titleDocument = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplateTextTitle> titleText = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.ImageMessage> titleImage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.VideoOrGifMessage> titleVideo = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.LocationMessage> titleLocation = java.util.Optional.empty();
        java.lang.String body = null;
        java.util.Optional<java.lang.String> footer = java.util.Optional.empty();
        java.util.List<it.auties.whatsapp.model.button.template.hydrated.HydratedTemplateButton> hydratedButtons = new java.util.ArrayList<it.auties.whatsapp.model.button.template.hydrated.HydratedTemplateButton>();
        java.lang.String templateId = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> titleDocument = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.DocumentMessageSpec.decode(inputStream.readBytes()));
                case 2 -> titleText = java.util.Optional.ofNullable(it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplateTextTitle.of(inputStream.readString()));
                case 3 -> titleImage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.ImageMessageSpec.decode(inputStream.readBytes()));
                case 4 -> titleVideo = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.VideoOrGifMessageSpec.decode(inputStream.readBytes()));
                case 5 -> titleLocation = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.LocationMessageSpec.decode(inputStream.readBytes()));
                case 6 -> body = inputStream.readString();
                case 7 -> footer = java.util.Optional.ofNullable(inputStream.readString());
                case 8 -> hydratedButtons.add(it.auties.whatsapp.model.button.template.hydrated.HydratedTemplateButtonSpec.decode(inputStream.readBytes()));
                case 9 -> templateId = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplate(titleDocument, titleText, titleImage, titleVideo, titleLocation, body, footer, hydratedButtons, templateId);
    }

}
