package it.auties.whatsapp.model.companion;

import it.auties.whatsapp.model.companion.CompanionDevice;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class CompanionDeviceSpec {
    public static byte[] encode(CompanionDevice protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.model());
outputStream.writeString(2, protoInputObject.manufacturer());
outputStream.writeInt32(3, it.auties.whatsapp.model.signal.auth.UserAgentPlatformTypeSpec.encode(protoInputObject.platform()));
var appVersion = protoInputObject.appVersion();
var appVersion0 = appVersion.orElse(null);
if(appVersion0 != null) {
outputStream.writeBytes(4, it.auties.whatsapp.model.signal.auth.VersionSpec.encode(appVersion0));
}
outputStream.writeBytes(5, it.auties.whatsapp.model.signal.auth.VersionSpec.encode(protoInputObject.osVersion()));
      return outputStream.toByteArray();
    }

    public static CompanionDevice decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String model = null;
        java.lang.String manufacturer = null;
        it.auties.whatsapp.model.signal.auth.UserAgent.PlatformType platform = null;
        java.util.Optional<it.auties.whatsapp.model.signal.auth.Version> appVersion = java.util.Optional.empty();
        it.auties.whatsapp.model.signal.auth.Version osVersion = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> model = inputStream.readString();
                case 2 -> manufacturer = inputStream.readString();
                case 3 -> platform = it.auties.whatsapp.model.signal.auth.UserAgentPlatformTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 4 -> appVersion = java.util.Optional.ofNullable(it.auties.whatsapp.model.signal.auth.VersionSpec.decode(inputStream.readBytes()));
                case 5 -> osVersion = it.auties.whatsapp.model.signal.auth.VersionSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.companion.CompanionDevice(model, manufacturer, platform, appVersion, osVersion);
    }

}
