package it.auties.whatsapp.model.contact;

import it.auties.whatsapp.model.contact.Contact;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ContactSpec {
    public static byte[] encode(Contact protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var jid = protoInputObject.jid();
if(jid != null) {
var jid0 = jid.toString();
if(jid0 != null) {
outputStream.writeString(1, jid0);
}
}
var chosenName = protoInputObject.chosenName();
if(chosenName != null) {
var chosenName0 = chosenName.orElse(null);
if(chosenName0 != null) {
outputStream.writeString(2, chosenName0);
}
}
var fullName = protoInputObject.fullName();
if(fullName != null) {
var fullName0 = fullName.orElse(null);
if(fullName0 != null) {
outputStream.writeString(3, fullName0);
}
}
var shortName = protoInputObject.shortName();
if(shortName != null) {
var shortName0 = shortName.orElse(null);
if(shortName0 != null) {
outputStream.writeString(4, shortName0);
}
}
outputStream.writeInt32(5, it.auties.whatsapp.model.contact.ContactStatusSpec.encode(protoInputObject.lastKnownPresence()));
var lastSeenSeconds = protoInputObject.lastSeenSeconds();
if(lastSeenSeconds != null) {
var lastSeenSeconds0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(lastSeenSeconds);
if(lastSeenSeconds0 != null) {
outputStream.writeUInt64(6, lastSeenSeconds0);
}
}
outputStream.writeBool(7, protoInputObject.blocked());
      return outputStream.toByteArray();
    }

    public static Contact decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.jid.Jid jid = null;
        java.lang.String chosenName = null;
        java.lang.String fullName = null;
        java.lang.String shortName = null;
        it.auties.whatsapp.model.contact.ContactStatus lastKnownPresence = null;
        java.lang.Long lastSeenSeconds = null;
        boolean blocked = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> jid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 2 -> chosenName = inputStream.readString();
                case 3 -> fullName = inputStream.readString();
                case 4 -> shortName = inputStream.readString();
                case 5 -> lastKnownPresence = it.auties.whatsapp.model.contact.ContactStatusSpec.decode(inputStream.readInt32()).orElse(null);
                case 6 -> lastSeenSeconds = inputStream.readInt64();
                case 7 -> blocked = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.contact.Contact(jid, chosenName, fullName, shortName, lastKnownPresence, lastSeenSeconds, blocked);
    }

}
