package it.auties.whatsapp.model.info;

import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ContextInfoSpec {
    public static byte[] encode(ContextInfo protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var quotedMessageId = protoInputObject.quotedMessageId();
if(quotedMessageId != null) {
var quotedMessageId0 = quotedMessageId.orElse(null);
if(quotedMessageId0 != null) {
outputStream.writeString(1, quotedMessageId0);
}
}
var quotedMessageSenderJid = protoInputObject.quotedMessageSenderJid();
if(quotedMessageSenderJid != null) {
var quotedMessageSenderJid0 = quotedMessageSenderJid.orElse(null);
if(quotedMessageSenderJid0 != null) {
var quotedMessageSenderJid1 = quotedMessageSenderJid0.toString();
if(quotedMessageSenderJid1 != null) {
outputStream.writeString(2, quotedMessageSenderJid1);
}
}
}
var quotedMessage = protoInputObject.quotedMessage();
if(quotedMessage != null) {
var quotedMessage0 = quotedMessage.orElse(null);
if(quotedMessage0 != null) {
outputStream.writeBytes(3, it.auties.whatsapp.model.message.model.MessageContainerSpec.encode(quotedMessage0));
}
}
var quotedMessageChatJid = protoInputObject.quotedMessageChatJid();
if(quotedMessageChatJid != null) {
var quotedMessageChatJid0 = quotedMessageChatJid.orElse(null);
if(quotedMessageChatJid0 != null) {
var quotedMessageChatJid1 = quotedMessageChatJid0.toString();
if(quotedMessageChatJid1 != null) {
outputStream.writeString(4, quotedMessageChatJid1);
}
}
}
      if(protoInputObject.mentions() != null) {
       for(var mentionsEntry : protoInputObject.mentions()) {
var mentions = mentionsEntry;
if(mentions != null) {
var mentions0 = mentions.toString();
if(mentions0 != null) {
outputStream.writeString(15, mentions0);
}
}
       }
      }
var conversionSource = protoInputObject.conversionSource();
if(conversionSource != null) {
var conversionSource0 = conversionSource.orElse(null);
if(conversionSource0 != null) {
outputStream.writeString(18, conversionSource0);
}
}
var conversionData = protoInputObject.conversionData();
if(conversionData != null) {
var conversionData0 = conversionData.orElse(null);
if(conversionData0 != null) {
outputStream.writeBytes(19, conversionData0);
}
}
outputStream.writeUInt32(20, protoInputObject.conversionDelaySeconds());
outputStream.writeUInt32(21, protoInputObject.forwardingScore());
outputStream.writeBool(22, protoInputObject.forwarded());
var quotedAd = protoInputObject.quotedAd();
if(quotedAd != null) {
var quotedAd0 = quotedAd.orElse(null);
if(quotedAd0 != null) {
outputStream.writeBytes(23, it.auties.whatsapp.model.info.AdReplyInfoSpec.encode(quotedAd0));
}
}
var placeholderKey = protoInputObject.placeholderKey();
if(placeholderKey != null) {
var placeholderKey0 = placeholderKey.orElse(null);
if(placeholderKey0 != null) {
outputStream.writeBytes(24, it.auties.whatsapp.model.message.model.ChatMessageKeySpec.encode(placeholderKey0));
}
}
outputStream.writeUInt32(25, protoInputObject.ephemeralExpiration());
outputStream.writeInt64(26, protoInputObject.ephemeralSettingTimestamp());
var ephemeralSharedSecret = protoInputObject.ephemeralSharedSecret();
if(ephemeralSharedSecret != null) {
var ephemeralSharedSecret0 = ephemeralSharedSecret.orElse(null);
if(ephemeralSharedSecret0 != null) {
outputStream.writeBytes(27, ephemeralSharedSecret0);
}
}
var externalAdReply = protoInputObject.externalAdReply();
if(externalAdReply != null) {
var externalAdReply0 = externalAdReply.orElse(null);
if(externalAdReply0 != null) {
outputStream.writeBytes(28, it.auties.whatsapp.model.info.ExternalAdReplyInfoSpec.encode(externalAdReply0));
}
}
var entryPointConversionSource = protoInputObject.entryPointConversionSource();
if(entryPointConversionSource != null) {
var entryPointConversionSource0 = entryPointConversionSource.orElse(null);
if(entryPointConversionSource0 != null) {
outputStream.writeString(29, entryPointConversionSource0);
}
}
var entryPointConversionApp = protoInputObject.entryPointConversionApp();
if(entryPointConversionApp != null) {
var entryPointConversionApp0 = entryPointConversionApp.orElse(null);
if(entryPointConversionApp0 != null) {
outputStream.writeString(30, entryPointConversionApp0);
}
}
outputStream.writeUInt32(31, protoInputObject.entryPointConversionDelaySeconds());
var disappearingMode = protoInputObject.disappearingMode();
if(disappearingMode != null) {
var disappearingMode0 = disappearingMode.orElse(null);
if(disappearingMode0 != null) {
outputStream.writeBytes(32, it.auties.whatsapp.model.chat.ChatDisappearSpec.encode(disappearingMode0));
}
}
var actionLink = protoInputObject.actionLink();
if(actionLink != null) {
var actionLink0 = actionLink.orElse(null);
if(actionLink0 != null) {
outputStream.writeBytes(33, it.auties.whatsapp.model.button.base.ButtonActionLinkSpec.encode(actionLink0));
}
}
var groupSubject = protoInputObject.groupSubject();
if(groupSubject != null) {
var groupSubject0 = groupSubject.orElse(null);
if(groupSubject0 != null) {
outputStream.writeString(34, groupSubject0);
}
}
var parentGroup = protoInputObject.parentGroup();
if(parentGroup != null) {
var parentGroup0 = parentGroup.orElse(null);
if(parentGroup0 != null) {
var parentGroup1 = parentGroup0.toString();
if(parentGroup1 != null) {
outputStream.writeString(35, parentGroup1);
}
}
}
var trustBannerType = protoInputObject.trustBannerType();
if(trustBannerType != null) {
var trustBannerType0 = trustBannerType.orElse(null);
if(trustBannerType0 != null) {
outputStream.writeString(37, trustBannerType0);
}
}
outputStream.writeUInt32(38, protoInputObject.trustBannerAction());
      return outputStream.toByteArray();
    }

    public static ContextInfo decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String quotedMessageId = null;
        it.auties.whatsapp.model.jid.Jid quotedMessageSenderJid = null;
        it.auties.whatsapp.model.message.model.MessageContainer quotedMessage = null;
        it.auties.whatsapp.model.jid.Jid quotedMessageChatJid = null;
        java.util.List<it.auties.whatsapp.model.jid.Jid> mentions = new java.util.ArrayList<it.auties.whatsapp.model.jid.Jid>();
        java.lang.String conversionSource = null;
        byte[] conversionData = null;
        int conversionDelaySeconds = 0;
        int forwardingScore = 0;
        boolean forwarded = false;
        it.auties.whatsapp.model.info.AdReplyInfo quotedAd = null;
        it.auties.whatsapp.model.message.model.ChatMessageKey placeholderKey = null;
        int ephemeralExpiration = 0;
        long ephemeralSettingTimestamp = 0l;
        byte[] ephemeralSharedSecret = null;
        it.auties.whatsapp.model.info.ExternalAdReplyInfo externalAdReply = null;
        java.lang.String entryPointConversionSource = null;
        java.lang.String entryPointConversionApp = null;
        int entryPointConversionDelaySeconds = 0;
        it.auties.whatsapp.model.chat.ChatDisappear disappearingMode = null;
        it.auties.whatsapp.model.button.base.ButtonActionLink actionLink = null;
        java.lang.String groupSubject = null;
        it.auties.whatsapp.model.jid.Jid parentGroup = null;
        java.lang.String trustBannerType = null;
        int trustBannerAction = 0;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> quotedMessageId = inputStream.readString();
                case 2 -> quotedMessageSenderJid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 3 -> quotedMessage = it.auties.whatsapp.model.message.model.MessageContainerSpec.decode(inputStream.readBytes());
                case 4 -> quotedMessageChatJid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 15 -> mentions.add(it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString()));
                case 18 -> conversionSource = inputStream.readString();
                case 19 -> conversionData = inputStream.readBytes();
                case 20 -> conversionDelaySeconds = inputStream.readInt32();
                case 21 -> forwardingScore = inputStream.readInt32();
                case 22 -> forwarded = inputStream.readBool();
                case 23 -> quotedAd = it.auties.whatsapp.model.info.AdReplyInfoSpec.decode(inputStream.readBytes());
                case 24 -> placeholderKey = it.auties.whatsapp.model.message.model.ChatMessageKeySpec.decode(inputStream.readBytes());
                case 25 -> ephemeralExpiration = inputStream.readInt32();
                case 26 -> ephemeralSettingTimestamp = inputStream.readInt64();
                case 27 -> ephemeralSharedSecret = inputStream.readBytes();
                case 28 -> externalAdReply = it.auties.whatsapp.model.info.ExternalAdReplyInfoSpec.decode(inputStream.readBytes());
                case 29 -> entryPointConversionSource = inputStream.readString();
                case 30 -> entryPointConversionApp = inputStream.readString();
                case 31 -> entryPointConversionDelaySeconds = inputStream.readInt32();
                case 32 -> disappearingMode = it.auties.whatsapp.model.chat.ChatDisappearSpec.decode(inputStream.readBytes());
                case 33 -> actionLink = it.auties.whatsapp.model.button.base.ButtonActionLinkSpec.decode(inputStream.readBytes());
                case 34 -> groupSubject = inputStream.readString();
                case 35 -> parentGroup = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 37 -> trustBannerType = inputStream.readString();
                case 38 -> trustBannerAction = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.info.ContextInfo(quotedMessageId, quotedMessageSenderJid, quotedMessage, quotedMessageChatJid, mentions, conversionSource, conversionData, conversionDelaySeconds, forwardingScore, forwarded, quotedAd, placeholderKey, ephemeralExpiration, ephemeralSettingTimestamp, ephemeralSharedSecret, externalAdReply, entryPointConversionSource, entryPointConversionApp, entryPointConversionDelaySeconds, disappearingMode, actionLink, groupSubject, parentGroup, trustBannerType, trustBannerAction);
    }

}
