package it.auties.whatsapp.model.message.button;

import it.auties.whatsapp.model.message.button.ListMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ListMessageSpec {
    public static byte[] encode(ListMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.title());
var description = protoInputObject.description();
if(description != null) {
var description0 = description.orElse(null);
if(description0 != null) {
outputStream.writeString(2, description0);
}
}
outputStream.writeString(3, protoInputObject.button());
outputStream.writeInt32(4, it.auties.whatsapp.model.message.button.ListMessageTypeSpec.encode(protoInputObject.listType()));
      if(protoInputObject.sections() != null) {
       for(var sectionsEntry : protoInputObject.sections()) {
outputStream.writeBytes(5, it.auties.whatsapp.model.button.misc.ButtonSectionSpec.encode(sectionsEntry));
       }
      }
var productListInfo = protoInputObject.productListInfo();
if(productListInfo != null) {
var productListInfo0 = productListInfo.orElse(null);
if(productListInfo0 != null) {
outputStream.writeBytes(6, it.auties.whatsapp.model.info.ProductListInfoSpec.encode(productListInfo0));
}
}
var footer = protoInputObject.footer();
if(footer != null) {
var footer0 = footer.orElse(null);
if(footer0 != null) {
outputStream.writeString(7, footer0);
}
}
var contextInfo = protoInputObject.contextInfo();
if(contextInfo != null) {
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(8, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
}
      return outputStream.toByteArray();
    }

    public static ListMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String title = null;
        java.lang.String description = null;
        java.lang.String button = null;
        it.auties.whatsapp.model.message.button.ListMessage.Type listType = null;
        java.util.List<it.auties.whatsapp.model.button.misc.ButtonSection> sections = new java.util.ArrayList<it.auties.whatsapp.model.button.misc.ButtonSection>();
        it.auties.whatsapp.model.info.ProductListInfo productListInfo = null;
        java.lang.String footer = null;
        it.auties.whatsapp.model.info.ContextInfo contextInfo = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> title = inputStream.readString();
                case 2 -> description = inputStream.readString();
                case 3 -> button = inputStream.readString();
                case 4 -> listType = it.auties.whatsapp.model.message.button.ListMessageTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 5 -> sections.add(it.auties.whatsapp.model.button.misc.ButtonSectionSpec.decode(inputStream.readBytes()));
                case 6 -> productListInfo = it.auties.whatsapp.model.info.ProductListInfoSpec.decode(inputStream.readBytes());
                case 7 -> footer = inputStream.readString();
                case 8 -> contextInfo = it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.button.ListMessage(title, description, button, listType, sections, productListInfo, footer, contextInfo);
    }

}
