package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.AudioMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class AudioMessageSpec {
    public static byte[] encode(AudioMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var mediaUrl = protoInputObject.mediaUrl();
if(mediaUrl != null) {
var mediaUrl0 = mediaUrl.orElse(null);
if(mediaUrl0 != null) {
outputStream.writeString(1, mediaUrl0);
}
}
var mimetype = protoInputObject.mimetype();
if(mimetype != null) {
var mimetype0 = mimetype.orElse(null);
if(mimetype0 != null) {
outputStream.writeString(2, mimetype0);
}
}
var mediaSha256 = protoInputObject.mediaSha256();
if(mediaSha256 != null) {
var mediaSha2560 = mediaSha256.orElse(null);
if(mediaSha2560 != null) {
outputStream.writeBytes(3, mediaSha2560);
}
}
var mediaSize = protoInputObject.mediaSize();
if(mediaSize != null) {
var mediaSize0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(mediaSize);
if(mediaSize0 != null) {
outputStream.writeUInt64(4, mediaSize0);
}
}
var duration = protoInputObject.duration();
if(duration != null) {
var duration0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(duration);
if(duration0 != null) {
outputStream.writeUInt32(5, duration0);
}
}
outputStream.writeBool(6, protoInputObject.voiceMessage());
var mediaKey = protoInputObject.mediaKey();
if(mediaKey != null) {
var mediaKey0 = mediaKey.orElse(null);
if(mediaKey0 != null) {
outputStream.writeBytes(7, mediaKey0);
}
}
var mediaEncryptedSha256 = protoInputObject.mediaEncryptedSha256();
if(mediaEncryptedSha256 != null) {
var mediaEncryptedSha2560 = mediaEncryptedSha256.orElse(null);
if(mediaEncryptedSha2560 != null) {
outputStream.writeBytes(8, mediaEncryptedSha2560);
}
}
var mediaDirectPath = protoInputObject.mediaDirectPath();
if(mediaDirectPath != null) {
var mediaDirectPath0 = mediaDirectPath.orElse(null);
if(mediaDirectPath0 != null) {
outputStream.writeString(9, mediaDirectPath0);
}
}
var mediaKeyTimestampSeconds = protoInputObject.mediaKeyTimestampSeconds();
if(mediaKeyTimestampSeconds != null) {
var mediaKeyTimestampSeconds0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(mediaKeyTimestampSeconds);
if(mediaKeyTimestampSeconds0 != null) {
outputStream.writeInt64(10, mediaKeyTimestampSeconds0);
}
}
var contextInfo = protoInputObject.contextInfo();
if(contextInfo != null) {
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(17, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
}
var streamingSidecar = protoInputObject.streamingSidecar();
if(streamingSidecar != null) {
var streamingSidecar0 = streamingSidecar.orElse(null);
if(streamingSidecar0 != null) {
outputStream.writeBytes(18, streamingSidecar0);
}
}
var waveform = protoInputObject.waveform();
if(waveform != null) {
var waveform0 = waveform.orElse(null);
if(waveform0 != null) {
outputStream.writeBytes(19, waveform0);
}
}
outputStream.writeFixed32(20, protoInputObject.backgroundArgb());
      return outputStream.toByteArray();
    }

    public static AudioMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String mediaUrl = null;
        java.lang.String mimetype = null;
        byte[] mediaSha256 = null;
        java.lang.Long mediaSize = null;
        java.lang.Integer duration = null;
        boolean voiceMessage = false;
        byte[] mediaKey = null;
        byte[] mediaEncryptedSha256 = null;
        java.lang.String mediaDirectPath = null;
        java.lang.Long mediaKeyTimestampSeconds = null;
        it.auties.whatsapp.model.info.ContextInfo contextInfo = null;
        byte[] streamingSidecar = null;
        byte[] waveform = null;
        java.lang.Integer backgroundArgb = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> mediaUrl = inputStream.readString();
                case 2 -> mimetype = inputStream.readString();
                case 3 -> mediaSha256 = inputStream.readBytes();
                case 4 -> mediaSize = inputStream.readInt64();
                case 5 -> duration = inputStream.readInt32();
                case 6 -> voiceMessage = inputStream.readBool();
                case 7 -> mediaKey = inputStream.readBytes();
                case 8 -> mediaEncryptedSha256 = inputStream.readBytes();
                case 9 -> mediaDirectPath = inputStream.readString();
                case 10 -> mediaKeyTimestampSeconds = inputStream.readInt64();
                case 17 -> contextInfo = it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes());
                case 18 -> streamingSidecar = inputStream.readBytes();
                case 19 -> waveform = inputStream.readBytes();
                case 20 -> backgroundArgb = inputStream.readFixed32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.AudioMessage(mediaUrl, mimetype, mediaSha256, mediaSize, duration, voiceMessage, mediaKey, mediaEncryptedSha256, mediaDirectPath, mediaKeyTimestampSeconds, contextInfo, streamingSidecar, waveform, backgroundArgb);
    }

}
