package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.ContactsMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ContactsMessageSpec {
    public static byte[] encode(ContactsMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.name());
      if(protoInputObject.contacts() != null) {
       for(var contactsEntry : protoInputObject.contacts()) {
outputStream.writeBytes(2, it.auties.whatsapp.model.message.standard.ContactMessageSpec.encode(contactsEntry));
       }
      }
var contextInfo = protoInputObject.contextInfo();
if(contextInfo != null) {
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(17, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
}
      return outputStream.toByteArray();
    }

    public static ContactsMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String name = null;
        java.util.List<it.auties.whatsapp.model.message.standard.ContactMessage> contacts = new java.util.ArrayList<it.auties.whatsapp.model.message.standard.ContactMessage>();
        it.auties.whatsapp.model.info.ContextInfo contextInfo = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> name = inputStream.readString();
                case 2 -> contacts.add(it.auties.whatsapp.model.message.standard.ContactMessageSpec.decode(inputStream.readBytes()));
                case 17 -> contextInfo = it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.ContactsMessage(name, contacts, contextInfo);
    }

}
