package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.DocumentMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class DocumentMessageSpec {
    public static byte[] encode(DocumentMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var mediaUrl = protoInputObject.mediaUrl();
if(mediaUrl != null) {
var mediaUrl0 = mediaUrl.orElse(null);
if(mediaUrl0 != null) {
outputStream.writeString(1, mediaUrl0);
}
}
var mimetype = protoInputObject.mimetype();
if(mimetype != null) {
var mimetype0 = mimetype.orElse(null);
if(mimetype0 != null) {
outputStream.writeString(2, mimetype0);
}
}
var title = protoInputObject.title();
if(title != null) {
var title0 = title.orElse(null);
if(title0 != null) {
outputStream.writeString(3, title0);
}
}
var mediaSha256 = protoInputObject.mediaSha256();
if(mediaSha256 != null) {
var mediaSha2560 = mediaSha256.orElse(null);
if(mediaSha2560 != null) {
outputStream.writeBytes(4, mediaSha2560);
}
}
var mediaSize = protoInputObject.mediaSize();
if(mediaSize != null) {
var mediaSize0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(mediaSize);
if(mediaSize0 != null) {
outputStream.writeUInt64(5, mediaSize0);
}
}
var pageCount = protoInputObject.pageCount();
if(pageCount != null) {
var pageCount0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(pageCount);
if(pageCount0 != null) {
outputStream.writeUInt32(6, pageCount0);
}
}
var mediaKey = protoInputObject.mediaKey();
if(mediaKey != null) {
var mediaKey0 = mediaKey.orElse(null);
if(mediaKey0 != null) {
outputStream.writeBytes(7, mediaKey0);
}
}
var fileName = protoInputObject.fileName();
if(fileName != null) {
var fileName0 = fileName.orElse(null);
if(fileName0 != null) {
outputStream.writeString(8, fileName0);
}
}
var mediaEncryptedSha256 = protoInputObject.mediaEncryptedSha256();
if(mediaEncryptedSha256 != null) {
var mediaEncryptedSha2560 = mediaEncryptedSha256.orElse(null);
if(mediaEncryptedSha2560 != null) {
outputStream.writeBytes(9, mediaEncryptedSha2560);
}
}
var mediaDirectPath = protoInputObject.mediaDirectPath();
if(mediaDirectPath != null) {
var mediaDirectPath0 = mediaDirectPath.orElse(null);
if(mediaDirectPath0 != null) {
outputStream.writeString(10, mediaDirectPath0);
}
}
var mediaKeyTimestampSeconds = protoInputObject.mediaKeyTimestampSeconds();
if(mediaKeyTimestampSeconds != null) {
var mediaKeyTimestampSeconds0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(mediaKeyTimestampSeconds);
if(mediaKeyTimestampSeconds0 != null) {
outputStream.writeUInt64(11, mediaKeyTimestampSeconds0);
}
}
var thumbnail = protoInputObject.thumbnail();
if(thumbnail != null) {
var thumbnail0 = thumbnail.orElse(null);
if(thumbnail0 != null) {
outputStream.writeBytes(16, thumbnail0);
}
}
outputStream.writeBool(12, protoInputObject.contactVcard());
var thumbnailDirectPath = protoInputObject.thumbnailDirectPath();
if(thumbnailDirectPath != null) {
var thumbnailDirectPath0 = thumbnailDirectPath.orElse(null);
if(thumbnailDirectPath0 != null) {
outputStream.writeString(13, thumbnailDirectPath0);
}
}
var thumbnailSha256 = protoInputObject.thumbnailSha256();
if(thumbnailSha256 != null) {
var thumbnailSha2560 = thumbnailSha256.orElse(null);
if(thumbnailSha2560 != null) {
outputStream.writeBytes(14, thumbnailSha2560);
}
}
var thumbnailEncSha256 = protoInputObject.thumbnailEncSha256();
if(thumbnailEncSha256 != null) {
var thumbnailEncSha2560 = thumbnailEncSha256.orElse(null);
if(thumbnailEncSha2560 != null) {
outputStream.writeBytes(15, thumbnailEncSha2560);
}
}
var contextInfo = protoInputObject.contextInfo();
if(contextInfo != null) {
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(17, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
}
var thumbnailHeight = protoInputObject.thumbnailHeight();
if(thumbnailHeight != null) {
var thumbnailHeight0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(thumbnailHeight);
if(thumbnailHeight0 != null) {
outputStream.writeUInt32(18, thumbnailHeight0);
}
}
var thumbnailWidth = protoInputObject.thumbnailWidth();
if(thumbnailWidth != null) {
var thumbnailWidth0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(thumbnailWidth);
if(thumbnailWidth0 != null) {
outputStream.writeUInt32(19, thumbnailWidth0);
}
}
var caption = protoInputObject.caption();
if(caption != null) {
var caption0 = caption.orElse(null);
if(caption0 != null) {
outputStream.writeString(20, caption0);
}
}
      return outputStream.toByteArray();
    }

    public static DocumentMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String mediaUrl = null;
        java.lang.String mimetype = null;
        java.lang.String title = null;
        byte[] mediaSha256 = null;
        java.lang.Long mediaSize = null;
        java.lang.Integer pageCount = null;
        byte[] mediaKey = null;
        java.lang.String fileName = null;
        byte[] mediaEncryptedSha256 = null;
        java.lang.String mediaDirectPath = null;
        java.lang.Long mediaKeyTimestampSeconds = null;
        byte[] thumbnail = null;
        boolean contactVcard = false;
        java.lang.String thumbnailDirectPath = null;
        byte[] thumbnailSha256 = null;
        byte[] thumbnailEncSha256 = null;
        it.auties.whatsapp.model.info.ContextInfo contextInfo = null;
        java.lang.Integer thumbnailHeight = null;
        java.lang.Integer thumbnailWidth = null;
        java.lang.String caption = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> mediaUrl = inputStream.readString();
                case 2 -> mimetype = inputStream.readString();
                case 3 -> title = inputStream.readString();
                case 4 -> mediaSha256 = inputStream.readBytes();
                case 5 -> mediaSize = inputStream.readInt64();
                case 6 -> pageCount = inputStream.readInt32();
                case 7 -> mediaKey = inputStream.readBytes();
                case 8 -> fileName = inputStream.readString();
                case 9 -> mediaEncryptedSha256 = inputStream.readBytes();
                case 10 -> mediaDirectPath = inputStream.readString();
                case 11 -> mediaKeyTimestampSeconds = inputStream.readInt64();
                case 16 -> thumbnail = inputStream.readBytes();
                case 12 -> contactVcard = inputStream.readBool();
                case 13 -> thumbnailDirectPath = inputStream.readString();
                case 14 -> thumbnailSha256 = inputStream.readBytes();
                case 15 -> thumbnailEncSha256 = inputStream.readBytes();
                case 17 -> contextInfo = it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes());
                case 18 -> thumbnailHeight = inputStream.readInt32();
                case 19 -> thumbnailWidth = inputStream.readInt32();
                case 20 -> caption = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.DocumentMessage(mediaUrl, mimetype, title, mediaSha256, mediaSize, pageCount, mediaKey, fileName, mediaEncryptedSha256, mediaDirectPath, mediaKeyTimestampSeconds, thumbnail, contactVcard, thumbnailDirectPath, thumbnailSha256, thumbnailEncSha256, contextInfo, thumbnailHeight, thumbnailWidth, caption);
    }

}
