package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.KeepInChatMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class KeepInChatMessageSpec {
    public static byte[] encode(KeepInChatMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.message.model.ChatMessageKeySpec.encode(protoInputObject.key()));
outputStream.writeInt32(2, it.auties.whatsapp.model.message.model.KeepInChatTypeSpec.encode(protoInputObject.keepType()));
outputStream.writeInt64(3, protoInputObject.timestampMilliseconds());
      return outputStream.toByteArray();
    }

    public static KeepInChatMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.message.model.ChatMessageKey key = null;
        it.auties.whatsapp.model.message.model.KeepInChatType keepType = null;
        long timestampMilliseconds = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> key = it.auties.whatsapp.model.message.model.ChatMessageKeySpec.decode(inputStream.readBytes());
                case 2 -> keepType = it.auties.whatsapp.model.message.model.KeepInChatTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 3 -> timestampMilliseconds = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.KeepInChatMessage(key, keepType, timestampMilliseconds);
    }

}
