package it.auties.whatsapp.model.mobile;

import it.auties.whatsapp.model.mobile.CountryLocale;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class CountryLocaleSpec {
    public static byte[] encode(CountryLocale protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.languageValue());
outputStream.writeString(2, protoInputObject.languageCode());
outputStream.writeString(3, protoInputObject.separator());
      return outputStream.toByteArray();
    }

    public static CountryLocale decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String languageValue = null;
        java.lang.String languageCode = null;
        java.lang.String separator = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> languageValue = inputStream.readString();
                case 2 -> languageCode = inputStream.readString();
                case 3 -> separator = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.mobile.CountryLocale(languageValue, languageCode, separator);
    }

}
