package it.auties.whatsapp.model.newsletter;

import it.auties.whatsapp.model.newsletter.NewsletterViewerMetadata;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class NewsletterViewerMetadataSpec {
    public static byte[] encode(NewsletterViewerMetadata protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBool(1, protoInputObject.mute());
outputStream.writeInt32(2, it.auties.whatsapp.model.newsletter.NewsletterViewerRoleSpec.encode(protoInputObject.role()));
      return outputStream.toByteArray();
    }

    public static NewsletterViewerMetadata decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        boolean mute = false;
        it.auties.whatsapp.model.newsletter.NewsletterViewerRole role = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> mute = inputStream.readBool();
                case 2 -> role = it.auties.whatsapp.model.newsletter.NewsletterViewerRoleSpec.decode(inputStream.readInt32()).orElse(null);
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.newsletter.NewsletterViewerMetadata(mute, role);
    }

}
