package it.auties.whatsapp.model.poll;

import it.auties.whatsapp.model.poll.PollAdditionalMetadata;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PollAdditionalMetadataSpec {
    public static byte[] encode(PollAdditionalMetadata protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBool(1, protoInputObject.pollInvalidated());
      return outputStream.toByteArray();
    }

    public static PollAdditionalMetadata decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        boolean pollInvalidated = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> pollInvalidated = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.poll.PollAdditionalMetadata(pollInvalidated);
    }

}
