package it.auties.whatsapp.model.privacy;

import it.auties.whatsapp.model.privacy.PrivacySettingEntry;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PrivacySettingEntrySpec {
    public static byte[] encode(PrivacySettingEntry protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, it.auties.whatsapp.model.privacy.PrivacySettingTypeSpec.encode(protoInputObject.type()));
outputStream.writeInt32(2, it.auties.whatsapp.model.privacy.PrivacySettingValueSpec.encode(protoInputObject.value()));
      if(protoInputObject.excluded() != null) {
       for(var excludedEntry : protoInputObject.excluded()) {
var excluded = excludedEntry;
if(excluded != null) {
var excluded0 = excluded.toString();
if(excluded0 != null) {
outputStream.writeString(3, excluded0);
}
}
       }
      }
      return outputStream.toByteArray();
    }

    public static PrivacySettingEntry decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.privacy.PrivacySettingType type = null;
        it.auties.whatsapp.model.privacy.PrivacySettingValue value = null;
        java.util.List<it.auties.whatsapp.model.jid.Jid> excluded = new java.util.ArrayList<it.auties.whatsapp.model.jid.Jid>();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> type = it.auties.whatsapp.model.privacy.PrivacySettingTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 2 -> value = it.auties.whatsapp.model.privacy.PrivacySettingValueSpec.decode(inputStream.readInt32()).orElse(null);
                case 3 -> excluded.add(it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString()));
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.privacy.PrivacySettingEntry(type, value, excluded);
    }

}
