package it.auties.whatsapp.model.signal.auth;

import it.auties.whatsapp.model.signal.auth.CompanionProperties;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class CompanionPropertiesSpec {
    public static byte[] encode(CompanionProperties protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.os());
outputStream.writeBytes(2, it.auties.whatsapp.model.signal.auth.VersionSpec.encode(protoInputObject.version()));
outputStream.writeInt32(3, it.auties.whatsapp.model.signal.auth.CompanionPropertiesPlatformTypeSpec.encode(protoInputObject.platformType()));
outputStream.writeBool(4, protoInputObject.requireFullSync());
outputStream.writeBytes(5, it.auties.whatsapp.model.sync.HistorySyncConfigSpec.encode(protoInputObject.historySyncConfig()));
      return outputStream.toByteArray();
    }

    public static CompanionProperties decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String os = null;
        it.auties.whatsapp.model.signal.auth.Version version = null;
        it.auties.whatsapp.model.signal.auth.CompanionProperties.PlatformType platformType = null;
        boolean requireFullSync = false;
        it.auties.whatsapp.model.sync.HistorySyncConfig historySyncConfig = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> os = inputStream.readString();
                case 2 -> version = it.auties.whatsapp.model.signal.auth.VersionSpec.decode(inputStream.readBytes());
                case 3 -> platformType = it.auties.whatsapp.model.signal.auth.CompanionPropertiesPlatformTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 4 -> requireFullSync = inputStream.readBool();
                case 5 -> historySyncConfig = it.auties.whatsapp.model.sync.HistorySyncConfigSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.auth.CompanionProperties(os, version, platformType, requireFullSync, historySyncConfig);
    }

}
