package it.auties.whatsapp.model.signal.auth;

import it.auties.whatsapp.model.signal.auth.CompanionRegistrationData;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class CompanionRegistrationDataSpec {
    public static byte[] encode(CompanionRegistrationData protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.eRegid());
outputStream.writeBytes(2, protoInputObject.eKeytype());
outputStream.writeBytes(3, protoInputObject.eIdent());
outputStream.writeBytes(4, protoInputObject.eSkeyId());
outputStream.writeBytes(5, protoInputObject.eSkeyVal());
outputStream.writeBytes(6, protoInputObject.eSkeySig());
outputStream.writeBytes(7, protoInputObject.buildHash());
outputStream.writeBytes(8, protoInputObject.companionProps());
      return outputStream.toByteArray();
    }

    public static CompanionRegistrationData decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] eRegid = null;
        byte[] eKeytype = null;
        byte[] eIdent = null;
        byte[] eSkeyId = null;
        byte[] eSkeyVal = null;
        byte[] eSkeySig = null;
        byte[] buildHash = null;
        byte[] companionProps = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> eRegid = inputStream.readBytes();
                case 2 -> eKeytype = inputStream.readBytes();
                case 3 -> eIdent = inputStream.readBytes();
                case 4 -> eSkeyId = inputStream.readBytes();
                case 5 -> eSkeyVal = inputStream.readBytes();
                case 6 -> eSkeySig = inputStream.readBytes();
                case 7 -> buildHash = inputStream.readBytes();
                case 8 -> companionProps = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.auth.CompanionRegistrationData(eRegid, eKeytype, eIdent, eSkeyId, eSkeyVal, eSkeySig, buildHash, companionProps);
    }

}
