package it.auties.whatsapp.model.signal.auth;

import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentity;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SignedDeviceIdentitySpec {
    public static byte[] encode(SignedDeviceIdentity protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.details());
outputStream.writeBytes(2, protoInputObject.accountSignatureKey());
outputStream.writeBytes(3, protoInputObject.accountSignature());
outputStream.writeBytes(4, protoInputObject.deviceSignature());
      return outputStream.toByteArray();
    }

    public static SignedDeviceIdentity decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] details = null;
        byte[] accountSignatureKey = null;
        byte[] accountSignature = null;
        byte[] deviceSignature = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> details = inputStream.readBytes();
                case 2 -> accountSignatureKey = inputStream.readBytes();
                case 3 -> accountSignature = inputStream.readBytes();
                case 4 -> deviceSignature = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.auth.SignedDeviceIdentity(details, accountSignatureKey, accountSignature, deviceSignature);
    }

}
