package it.auties.whatsapp.model.signal.auth;

import it.auties.whatsapp.model.signal.auth.WebInfo;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class WebInfoSpec {
    public static byte[] encode(WebInfo protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.refToken());
outputStream.writeString(2, protoInputObject.version());
outputStream.writeBytes(3, it.auties.whatsapp.model.signal.auth.WebPayloadSpec.encode(protoInputObject.webPayload()));
outputStream.writeInt32(4, it.auties.whatsapp.model.signal.auth.WebInfoPlatformSpec.encode(protoInputObject.webSubPlatform()));
      return outputStream.toByteArray();
    }

    public static WebInfo decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String refToken = null;
        java.lang.String version = null;
        it.auties.whatsapp.model.signal.auth.WebPayload webPayload = null;
        it.auties.whatsapp.model.signal.auth.WebInfo.Platform webSubPlatform = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> refToken = inputStream.readString();
                case 2 -> version = inputStream.readString();
                case 3 -> webPayload = it.auties.whatsapp.model.signal.auth.WebPayloadSpec.decode(inputStream.readBytes());
                case 4 -> webSubPlatform = it.auties.whatsapp.model.signal.auth.WebInfoPlatformSpec.decode(inputStream.readInt32()).orElse(null);
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.auth.WebInfo(refToken, version, webPayload, webSubPlatform);
    }

}
