package it.auties.whatsapp.model.signal.keypair;

import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SignalKeyPairSpec {
    public static byte[] encode(SignalKeyPair protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.publicKey());
outputStream.writeBytes(2, protoInputObject.privateKey());
      return outputStream.toByteArray();
    }

    public static SignalKeyPair decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] publicKey = null;
        byte[] privateKey = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> publicKey = inputStream.readBytes();
                case 2 -> privateKey = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.keypair.SignalKeyPair(publicKey, privateKey);
    }

}
