package it.auties.whatsapp.model.signal.keypair;

import it.auties.whatsapp.model.signal.keypair.SignalPreKeyPair;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SignalPreKeyPairSpec {
    public static byte[] encode(SignalPreKeyPair protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, protoInputObject.id());
outputStream.writeBytes(2, protoInputObject.publicKey());
outputStream.writeBytes(3, protoInputObject.privateKey());
      return outputStream.toByteArray();
    }

    public static SignalPreKeyPair decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        int id = 0;
        byte[] publicKey = null;
        byte[] privateKey = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> id = inputStream.readInt32();
                case 2 -> publicKey = inputStream.readBytes();
                case 3 -> privateKey = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.keypair.SignalPreKeyPair(id, publicKey, privateKey);
    }

}
