package it.auties.whatsapp.model.signal.sender;

import it.auties.whatsapp.model.signal.sender.SenderKeyState;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SenderKeyStateSpec {
    public static byte[] encode(SenderKeyState protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, protoInputObject.id());
outputStream.writeBytes(2, it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec.encode(protoInputObject.signingKey()));
      if(protoInputObject.messageKeys() != null) {
            for(var messageKeysEntry : protoInputObject.messageKeys().entrySet()) {
                var messageKeysOutputStream = new ProtobufOutputStream();
messageKeysOutputStream.writeInt32(1, messageKeysEntry.getKey());
messageKeysOutputStream.writeBytes(2, it.auties.whatsapp.model.signal.sender.SenderMessageKeySpec.encode(messageKeysEntry.getValue()));
                outputStream.writeBytes(3, messageKeysOutputStream.toByteArray());
            }
      }
outputStream.writeBytes(4, it.auties.whatsapp.model.signal.sender.SenderChainKeySpec.encode(protoInputObject.chainKey()));
      return outputStream.toByteArray();
    }

    public static SenderKeyState decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        int id = 0;
        it.auties.whatsapp.model.signal.keypair.SignalKeyPair signingKey = null;
        java.util.concurrent.ConcurrentHashMap<java.lang.Integer,it.auties.whatsapp.model.signal.sender.SenderMessageKey> messageKeys = new java.util.concurrent.ConcurrentHashMap<java.lang.Integer,it.auties.whatsapp.model.signal.sender.SenderMessageKey>();
        it.auties.whatsapp.model.signal.sender.SenderChainKey chainKey = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> id = inputStream.readInt32();
                case 2 -> signingKey = it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec.decode(inputStream.readBytes());
                case 3 -> {
                        var messageKeysInputStream = new ProtobufInputStream(inputStream.readBytes());
                        java.lang.Integer messageKeysKey = null;
                        it.auties.whatsapp.model.signal.sender.SenderMessageKey messageKeysValue = null;
                        while(messageKeysInputStream.readTag()) {
                            switch(messageKeysInputStream.index()) {
                                case 1 -> messageKeysKey = messageKeysInputStream.readInt32();
                                case 2 -> messageKeysValue = it.auties.whatsapp.model.signal.sender.SenderMessageKeySpec.decode(messageKeysInputStream.readBytes());
                            }
                        }
                        messageKeys.put(messageKeysKey, messageKeysValue);
                }
                case 4 -> chainKey = it.auties.whatsapp.model.signal.sender.SenderChainKeySpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.sender.SenderKeyState(id, signingKey, messageKeys, chainKey);
    }

}
