package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.HistorySyncMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class HistorySyncMessageSpec {
    public static byte[] encode(HistorySyncMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.info.ChatMessageInfoSpec.encode(protoInputObject.messageInfo()));
outputStream.writeUInt64(2, protoInputObject.messageOrderId());
      return outputStream.toByteArray();
    }

    public static HistorySyncMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.info.ChatMessageInfo messageInfo = null;
        long messageOrderId = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> messageInfo = it.auties.whatsapp.model.info.ChatMessageInfoSpec.decode(inputStream.readBytes());
                case 2 -> messageOrderId = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.HistorySyncMessage(messageInfo, messageOrderId);
    }

}
