package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.KeyExpiration;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class KeyExpirationSpec {
    public static byte[] encode(KeyExpiration protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, protoInputObject.expiredKeyEpoch());
      return outputStream.toByteArray();
    }

    public static KeyExpiration decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.Integer expiredKeyEpoch = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> expiredKeyEpoch = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.KeyExpiration(expiredKeyEpoch);
    }

}
