package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.MediaRetryNotification;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class MediaRetryNotificationSpec {
    public static byte[] encode(MediaRetryNotification protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.stanzaId());
var directPath = protoInputObject.directPath();
var directPath0 = directPath.orElse(null);
if(directPath0 != null) {
outputStream.writeString(2, directPath0);
}
outputStream.writeInt32(3, it.auties.whatsapp.model.sync.MediaRetryNotificationMediaRetryNotificationResultTypeSpec.encode(protoInputObject.result()));
      return outputStream.toByteArray();
    }

    public static MediaRetryNotification decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String stanzaId = null;
        java.util.Optional<java.lang.String> directPath = java.util.Optional.empty();
        it.auties.whatsapp.model.sync.MediaRetryNotification.MediaRetryNotificationResultType result = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> stanzaId = inputStream.readString();
                case 2 -> directPath = java.util.Optional.ofNullable(inputStream.readString());
                case 3 -> result = it.auties.whatsapp.model.sync.MediaRetryNotificationMediaRetryNotificationResultTypeSpec.decode(inputStream.readInt32()).orElse(null);
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.MediaRetryNotification(stanzaId, directPath, result);
    }

}
