/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import it.auties.whatsapp.api.AsyncVerificationCodeSupplier;
import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.model.companion.CompanionDevice;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.mobile.VerificationCodeMethod;
import it.auties.whatsapp.model.response.RegistrationResponse;
import it.auties.whatsapp.registration.WhatsappRegistration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public sealed class MobileRegistrationBuilder {
    final Store store;
    final Keys keys;
    final ErrorHandler errorHandler;
    final ExecutorService socketExecutor;
    RegisteredResult result;
    AsyncVerificationCodeSupplier verificationCodeSupplier;

    MobileRegistrationBuilder(Store store, Keys keys, ErrorHandler errorHandler, ExecutorService socketExecutor) {
        this.store = store;
        this.keys = keys;
        this.errorHandler = errorHandler;
        this.socketExecutor = socketExecutor;
    }

    public record UnverifiedResult(Unverified unverified, Optional<RegistrationResponse> response) {
    }

    public record RegisteredResult(Whatsapp whatsapp, Optional<RegistrationResponse> response) {
    }

    public static final class Unverified
    extends MobileRegistrationBuilder {
        Unverified(Store store, Keys keys, ErrorHandler errorHandler, ExecutorService socketExecutor, AsyncVerificationCodeSupplier verificationCodeSupplier) {
            super(store, keys, errorHandler, socketExecutor);
            this.verificationCodeSupplier = verificationCodeSupplier;
        }

        public Unverified verificationCodeSupplier(Supplier<String> verificationCodeSupplier) {
            this.verificationCodeSupplier = AsyncVerificationCodeSupplier.of(verificationCodeSupplier);
            return this;
        }

        public Unverified verificationCodeSupplier(AsyncVerificationCodeSupplier verificationCodeSupplier) {
            this.verificationCodeSupplier = verificationCodeSupplier;
            return this;
        }

        public Unverified device(CompanionDevice device) {
            this.store.setDevice(device);
            return this;
        }

        public CompletableFuture<RegisteredResult> verify(long phoneNumber) {
            PhoneNumber number = PhoneNumber.of(phoneNumber);
            this.keys.setPhoneNumber(number);
            this.store.setPhoneNumber(number);
            return this.verify();
        }

        public CompletableFuture<RegisteredResult> verify() {
            if (this.result != null) {
                return CompletableFuture.completedFuture(this.result);
            }
            Objects.requireNonNull(this.store.phoneNumber(), "Missing phone number: please specify it");
            Objects.requireNonNull(this.verificationCodeSupplier, "Expected a valid verification code supplier");
            WhatsappRegistration registration = new WhatsappRegistration(this.store, this.keys, this.verificationCodeSupplier, VerificationCodeMethod.NONE);
            return registration.sendVerificationCode().thenApply(response -> {
                Whatsapp api = Whatsapp.customBuilder().store(this.store).keys(this.keys).errorHandler(this.errorHandler).socketExecutor(this.socketExecutor).build();
                this.result = new RegisteredResult(api, Optional.ofNullable(response));
                return this.result;
            });
        }
    }

    public static final class Unregistered
    extends MobileRegistrationBuilder {
        private UnverifiedResult unregisteredResult;
        private VerificationCodeMethod verificationCodeMethod = VerificationCodeMethod.SMS;

        Unregistered(Store store, Keys keys, ErrorHandler errorHandler, ExecutorService socketExecutor) {
            super(store, keys, errorHandler, socketExecutor);
        }

        public Unregistered verificationCodeSupplier(Supplier<String> verificationCodeSupplier) {
            this.verificationCodeSupplier = AsyncVerificationCodeSupplier.of(verificationCodeSupplier);
            return this;
        }

        public Unregistered verificationCodeSupplier(AsyncVerificationCodeSupplier verificationCodeSupplier) {
            this.verificationCodeSupplier = verificationCodeSupplier;
            return this;
        }

        public Unregistered device(CompanionDevice device) {
            this.store.setDevice(device);
            return this;
        }

        public Unregistered verificationCodeMethod(VerificationCodeMethod verificationCodeMethod) {
            this.verificationCodeMethod = verificationCodeMethod;
            return this;
        }

        public CompletableFuture<RegisteredResult> register(long phoneNumber) {
            if (this.result != null) {
                return CompletableFuture.completedFuture(this.result);
            }
            Objects.requireNonNull(this.verificationCodeSupplier, "Expected a valid verification code supplier");
            Objects.requireNonNull(this.verificationCodeMethod, "Expected a valid verification method");
            if (!this.keys.registered()) {
                PhoneNumber number = PhoneNumber.of(phoneNumber);
                this.keys.setPhoneNumber(number);
                this.store.setPhoneNumber(number);
                WhatsappRegistration registration = new WhatsappRegistration(this.store, this.keys, this.verificationCodeSupplier, this.verificationCodeMethod);
                return registration.registerPhoneNumber().thenApply(response -> {
                    Whatsapp api = Whatsapp.customBuilder().store(this.store).keys(this.keys).errorHandler(this.errorHandler).socketExecutor(this.socketExecutor).build();
                    this.result = new RegisteredResult(api, Optional.ofNullable(response));
                    return this.result;
                });
            }
            Whatsapp api = Whatsapp.customBuilder().store(this.store).keys(this.keys).errorHandler(this.errorHandler).socketExecutor(this.socketExecutor).build();
            return CompletableFuture.completedFuture(this.result);
        }

        public CompletableFuture<UnverifiedResult> requestVerificationCode(long phoneNumber) {
            if (this.unregisteredResult != null) {
                return CompletableFuture.completedFuture(this.unregisteredResult);
            }
            PhoneNumber number = PhoneNumber.of(phoneNumber);
            this.keys.setPhoneNumber(number);
            this.store.setPhoneNumber(number);
            if (!this.keys.registered()) {
                WhatsappRegistration registration = new WhatsappRegistration(this.store, this.keys, this.verificationCodeSupplier, this.verificationCodeMethod);
                return registration.requestVerificationCode().thenApply(response -> {
                    Unverified unverified = new Unverified(this.store, this.keys, this.errorHandler, this.socketExecutor, this.verificationCodeSupplier);
                    this.unregisteredResult = new UnverifiedResult(unverified, Optional.ofNullable(response));
                    return this.unregisteredResult;
                });
            }
            Unverified unverified = new Unverified(this.store, this.keys, this.errorHandler, this.socketExecutor, this.verificationCodeSupplier);
            this.unregisteredResult = new UnverifiedResult(unverified, Optional.empty());
            return CompletableFuture.completedFuture(this.unregisteredResult);
        }
    }
}

