/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import it.auties.curve25519.Curve25519;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.ConnectionBuilder;
import it.auties.whatsapp.api.DisconnectReason;
import it.auties.whatsapp.api.Emoji;
import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.api.MobileOptionsBuilder;
import it.auties.whatsapp.api.WebOptionsBuilder;
import it.auties.whatsapp.api.WebVerificationHandler;
import it.auties.whatsapp.api.WhatsappCustomBuilder;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.crypto.AesGcm;
import it.auties.whatsapp.crypto.CipheredMessageResult;
import it.auties.whatsapp.crypto.Hkdf;
import it.auties.whatsapp.crypto.Hmac;
import it.auties.whatsapp.crypto.SessionCipher;
import it.auties.whatsapp.listener.Listener;
import it.auties.whatsapp.listener.OnAction;
import it.auties.whatsapp.listener.OnCall;
import it.auties.whatsapp.listener.OnChatMessagesSync;
import it.auties.whatsapp.listener.OnChats;
import it.auties.whatsapp.listener.OnContactBlocked;
import it.auties.whatsapp.listener.OnContactPictureChanged;
import it.auties.whatsapp.listener.OnContactPresence;
import it.auties.whatsapp.listener.OnContacts;
import it.auties.whatsapp.listener.OnDisconnected;
import it.auties.whatsapp.listener.OnFeatures;
import it.auties.whatsapp.listener.OnGroupPictureChange;
import it.auties.whatsapp.listener.OnHistorySyncProgress;
import it.auties.whatsapp.listener.OnLinkedDevices;
import it.auties.whatsapp.listener.OnLoggedIn;
import it.auties.whatsapp.listener.OnMessageDeleted;
import it.auties.whatsapp.listener.OnMessageReply;
import it.auties.whatsapp.listener.OnMessageStatus;
import it.auties.whatsapp.listener.OnMetadata;
import it.auties.whatsapp.listener.OnNewContact;
import it.auties.whatsapp.listener.OnNewMessage;
import it.auties.whatsapp.listener.OnNewStatus;
import it.auties.whatsapp.listener.OnNewsletters;
import it.auties.whatsapp.listener.OnNodeReceived;
import it.auties.whatsapp.listener.OnNodeSent;
import it.auties.whatsapp.listener.OnPrivacySettingChanged;
import it.auties.whatsapp.listener.OnProfilePictureChanged;
import it.auties.whatsapp.listener.OnRegistrationCode;
import it.auties.whatsapp.listener.OnSetting;
import it.auties.whatsapp.listener.OnSocketEvent;
import it.auties.whatsapp.listener.OnStatus;
import it.auties.whatsapp.listener.OnUserAboutChanged;
import it.auties.whatsapp.listener.OnUserNameChanged;
import it.auties.whatsapp.listener.OnWhatsappAboutChanged;
import it.auties.whatsapp.listener.OnWhatsappAction;
import it.auties.whatsapp.listener.OnWhatsappCall;
import it.auties.whatsapp.listener.OnWhatsappChatMessagesSync;
import it.auties.whatsapp.listener.OnWhatsappChats;
import it.auties.whatsapp.listener.OnWhatsappContactBlocked;
import it.auties.whatsapp.listener.OnWhatsappContactPictureChanged;
import it.auties.whatsapp.listener.OnWhatsappContactPresence;
import it.auties.whatsapp.listener.OnWhatsappContacts;
import it.auties.whatsapp.listener.OnWhatsappDisconnected;
import it.auties.whatsapp.listener.OnWhatsappFeatures;
import it.auties.whatsapp.listener.OnWhatsappGroupPictureChange;
import it.auties.whatsapp.listener.OnWhatsappHistorySyncProgress;
import it.auties.whatsapp.listener.OnWhatsappLinkedDevices;
import it.auties.whatsapp.listener.OnWhatsappLoggedIn;
import it.auties.whatsapp.listener.OnWhatsappMediaStatus;
import it.auties.whatsapp.listener.OnWhatsappMessageDeleted;
import it.auties.whatsapp.listener.OnWhatsappMessageReply;
import it.auties.whatsapp.listener.OnWhatsappMessageStatus;
import it.auties.whatsapp.listener.OnWhatsappMetadata;
import it.auties.whatsapp.listener.OnWhatsappNameChanged;
import it.auties.whatsapp.listener.OnWhatsappNewMessage;
import it.auties.whatsapp.listener.OnWhatsappNewStatus;
import it.auties.whatsapp.listener.OnWhatsappNewsletters;
import it.auties.whatsapp.listener.OnWhatsappNodeReceived;
import it.auties.whatsapp.listener.OnWhatsappNodeSent;
import it.auties.whatsapp.listener.OnWhatsappPrivacySettingChanged;
import it.auties.whatsapp.listener.OnWhatsappProfilePictureChanged;
import it.auties.whatsapp.listener.OnWhatsappRegistrationCode;
import it.auties.whatsapp.listener.OnWhatsappSetting;
import it.auties.whatsapp.listener.OnWhatsappSocketEvent;
import it.auties.whatsapp.model.action.AndroidUnsupportedActions;
import it.auties.whatsapp.model.action.ArchiveChatAction;
import it.auties.whatsapp.model.action.ClearChatAction;
import it.auties.whatsapp.model.action.ContactAction;
import it.auties.whatsapp.model.action.DeleteChatAction;
import it.auties.whatsapp.model.action.DeleteMessageForMeAction;
import it.auties.whatsapp.model.action.MarkChatAsReadAction;
import it.auties.whatsapp.model.action.MuteAction;
import it.auties.whatsapp.model.action.NuxAction;
import it.auties.whatsapp.model.action.PinAction;
import it.auties.whatsapp.model.action.PrimaryVersionAction;
import it.auties.whatsapp.model.action.StarAction;
import it.auties.whatsapp.model.action.TimeFormatAction;
import it.auties.whatsapp.model.business.BusinessCatalogEntry;
import it.auties.whatsapp.model.business.BusinessCategory;
import it.auties.whatsapp.model.business.BusinessCollectionEntry;
import it.auties.whatsapp.model.business.BusinessProfile;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificate;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateSpec;
import it.auties.whatsapp.model.call.Call;
import it.auties.whatsapp.model.call.CallStatus;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatBuilder;
import it.auties.whatsapp.model.chat.ChatEphemeralTimer;
import it.auties.whatsapp.model.chat.ChatMute;
import it.auties.whatsapp.model.chat.ChatSettingPolicy;
import it.auties.whatsapp.model.chat.CommunitySetting;
import it.auties.whatsapp.model.chat.GroupAction;
import it.auties.whatsapp.model.chat.GroupMetadata;
import it.auties.whatsapp.model.chat.GroupParticipant;
import it.auties.whatsapp.model.chat.GroupPastParticipant;
import it.auties.whatsapp.model.chat.GroupPastParticipantBuilder;
import it.auties.whatsapp.model.chat.GroupPastParticipants;
import it.auties.whatsapp.model.chat.GroupPastParticipantsBuilder;
import it.auties.whatsapp.model.chat.GroupRole;
import it.auties.whatsapp.model.chat.GroupSetting;
import it.auties.whatsapp.model.companion.CompanionLinkResult;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactStatus;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.info.ChatMessageInfoBuilder;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.DeviceContextInfo;
import it.auties.whatsapp.model.info.DeviceContextInfoBuilder;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.info.NewsletterMessageInfo;
import it.auties.whatsapp.model.info.QuotedMessageInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidProvider;
import it.auties.whatsapp.model.jid.JidServer;
import it.auties.whatsapp.model.media.AttachmentType;
import it.auties.whatsapp.model.media.MediaFile;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ChatMessageKeyBuilder;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.MediaMessage;
import it.auties.whatsapp.model.message.model.Message;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.model.MessageStatus;
import it.auties.whatsapp.model.message.model.MessageType;
import it.auties.whatsapp.model.message.model.reserved.ExtendedMediaMessage;
import it.auties.whatsapp.model.message.server.ProtocolMessage;
import it.auties.whatsapp.model.message.server.ProtocolMessageBuilder;
import it.auties.whatsapp.model.message.standard.CallMessage;
import it.auties.whatsapp.model.message.standard.CallMessageBuilder;
import it.auties.whatsapp.model.message.standard.ReactionMessage;
import it.auties.whatsapp.model.message.standard.ReactionMessageBuilder;
import it.auties.whatsapp.model.message.standard.TextMessage;
import it.auties.whatsapp.model.newsletter.Newsletter;
import it.auties.whatsapp.model.newsletter.NewsletterReaction;
import it.auties.whatsapp.model.newsletter.NewsletterViewerMetadata;
import it.auties.whatsapp.model.newsletter.NewsletterViewerRole;
import it.auties.whatsapp.model.node.Attributes;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.model.privacy.GdprAccountReport;
import it.auties.whatsapp.model.privacy.PrivacySettingEntry;
import it.auties.whatsapp.model.privacy.PrivacySettingType;
import it.auties.whatsapp.model.privacy.PrivacySettingValue;
import it.auties.whatsapp.model.product.LeaveNewsletterRequest;
import it.auties.whatsapp.model.request.CreateNewsletterRequest;
import it.auties.whatsapp.model.request.JoinNewsletterRequest;
import it.auties.whatsapp.model.request.MessageSendRequest;
import it.auties.whatsapp.model.request.NewsletterSubscribersRequest;
import it.auties.whatsapp.model.request.RecommendedNewslettersRequest;
import it.auties.whatsapp.model.request.UpdateNewsletterRequest;
import it.auties.whatsapp.model.request.UserChosenNameRequest;
import it.auties.whatsapp.model.response.ContactAboutResponse;
import it.auties.whatsapp.model.response.HasWhatsappResponse;
import it.auties.whatsapp.model.response.NewsletterResponse;
import it.auties.whatsapp.model.response.NewsletterSubscribersResponse;
import it.auties.whatsapp.model.response.RecommendedNewslettersResponse;
import it.auties.whatsapp.model.response.RegistrationResponse;
import it.auties.whatsapp.model.response.UserChosenNameResponse;
import it.auties.whatsapp.model.setting.LocaleSettings;
import it.auties.whatsapp.model.setting.PushNameSettings;
import it.auties.whatsapp.model.signal.auth.DeviceIdentity;
import it.auties.whatsapp.model.signal.auth.DeviceIdentityBuilder;
import it.auties.whatsapp.model.signal.auth.DeviceIdentitySpec;
import it.auties.whatsapp.model.signal.auth.KeyIndexList;
import it.auties.whatsapp.model.signal.auth.KeyIndexListBuilder;
import it.auties.whatsapp.model.signal.auth.KeyIndexListSpec;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentity;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentityBuilder;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentityHMAC;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentityHMACBuilder;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentityHMACSpec;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentitySpec;
import it.auties.whatsapp.model.signal.auth.SignedKeyIndexList;
import it.auties.whatsapp.model.signal.auth.SignedKeyIndexListBuilder;
import it.auties.whatsapp.model.signal.auth.SignedKeyIndexListSpec;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.sync.ActionMessageRangeSync;
import it.auties.whatsapp.model.sync.ActionValueSync;
import it.auties.whatsapp.model.sync.AppStateSyncKey;
import it.auties.whatsapp.model.sync.AppStateSyncKeyBuilder;
import it.auties.whatsapp.model.sync.AppStateSyncKeyData;
import it.auties.whatsapp.model.sync.AppStateSyncKeyDataBuilder;
import it.auties.whatsapp.model.sync.AppStateSyncKeyFingerprint;
import it.auties.whatsapp.model.sync.AppStateSyncKeyFingerprintBuilder;
import it.auties.whatsapp.model.sync.AppStateSyncKeyId;
import it.auties.whatsapp.model.sync.AppStateSyncKeyShare;
import it.auties.whatsapp.model.sync.AppStateSyncKeyShareBuilder;
import it.auties.whatsapp.model.sync.HistorySync;
import it.auties.whatsapp.model.sync.HistorySyncBuilder;
import it.auties.whatsapp.model.sync.HistorySyncNotification;
import it.auties.whatsapp.model.sync.HistorySyncNotificationBuilder;
import it.auties.whatsapp.model.sync.HistorySyncSpec;
import it.auties.whatsapp.model.sync.InitialSecurityNotificationSettingSync;
import it.auties.whatsapp.model.sync.MediaRetryNotification;
import it.auties.whatsapp.model.sync.MediaRetryNotificationSpec;
import it.auties.whatsapp.model.sync.PatchRequest;
import it.auties.whatsapp.model.sync.PatchType;
import it.auties.whatsapp.model.sync.PushName;
import it.auties.whatsapp.model.sync.RecordSync;
import it.auties.whatsapp.model.sync.ServerErrorReceipt;
import it.auties.whatsapp.model.sync.ServerErrorReceiptSpec;
import it.auties.whatsapp.socket.SocketHandler;
import it.auties.whatsapp.socket.SocketState;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.Json;
import it.auties.whatsapp.util.KeyHelper;
import it.auties.whatsapp.util.ListenerScanner;
import it.auties.whatsapp.util.Medias;
import it.auties.whatsapp.util.Specification;
import it.auties.whatsapp.util.Validate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.imageio.ImageIO;

public class Whatsapp {
    private static final Map<UUID, Whatsapp> instances = new ConcurrentHashMap<UUID, Whatsapp>();
    private final SocketHandler socketHandler;
    private RegistrationResponse response;

    static Optional<Whatsapp> getInstanceByUuid(UUID uuid) {
        return Optional.ofNullable(instances.get(uuid));
    }

    static void removeInstanceByUuid(UUID uuid) {
        instances.remove(uuid);
    }

    public static boolean isConnected(UUID uuid) {
        return SocketHandler.isConnected(uuid);
    }

    public static boolean isConnected(long phoneNumber) {
        return SocketHandler.isConnected(phoneNumber);
    }

    public static boolean isConnected(String alias) {
        return SocketHandler.isConnected(alias);
    }

    protected Whatsapp(Store store, Keys keys, ErrorHandler errorHandler, WebVerificationHandler webVerificationHandler, ExecutorService socketExecutor) {
        this.socketHandler = new SocketHandler(this, store, keys, errorHandler, webVerificationHandler, socketExecutor);
        store.addListener(reason -> {
            if (reason != DisconnectReason.RECONNECTING) {
                Whatsapp.removeInstanceByUuid(store.uuid());
            }
        });
        if (store.autodetectListeners()) {
            return;
        }
        store.addListeners(ListenerScanner.scan(this, store.cacheDetectedListeners()));
    }

    public static ConnectionBuilder<WebOptionsBuilder> webBuilder() {
        return new ConnectionBuilder<WebOptionsBuilder>(ClientType.WEB);
    }

    public static ConnectionBuilder<MobileOptionsBuilder> mobileBuilder() {
        return new ConnectionBuilder<MobileOptionsBuilder>(ClientType.MOBILE);
    }

    public static WhatsappCustomBuilder customBuilder() {
        return new WhatsappCustomBuilder();
    }

    public synchronized CompletableFuture<Whatsapp> connect() {
        return ((CompletableFuture)this.socketHandler.connect().thenRunAsync(() -> instances.put(this.store().uuid(), this))).thenApply(ignored -> this);
    }

    public boolean isConnected() {
        return this.socketHandler.state() == SocketState.CONNECTED;
    }

    public Keys keys() {
        return this.socketHandler.keys();
    }

    public Store store() {
        return this.socketHandler.store();
    }

    public CompletableFuture<Void> disconnect() {
        return this.socketHandler.disconnect(DisconnectReason.DISCONNECTED);
    }

    public CompletableFuture<Void> reconnect() {
        return this.socketHandler.disconnect(DisconnectReason.RECONNECTING);
    }

    public CompletableFuture<Void> logout() {
        if (this.jidOrThrowError() == null) {
            return this.socketHandler.disconnect(DisconnectReason.LOGGED_OUT);
        }
        Map<String, String> metadata = Map.of("jid", this.jidOrThrowError(), "reason", "user_initiated");
        Node device = Node.of("remove-companion-device", metadata);
        return this.socketHandler.sendQuery("set", "md", device).thenRun(() -> {});
    }

    public final CompletableFuture<Void> changePrivacySetting(PrivacySettingType type, PrivacySettingValue value, JidProvider ... excluded) {
        Validate.isTrue(type.isSupported(value), "Cannot change setting %s to %s: this toggle cannot be used because Whatsapp doesn't support it", value.name(), type.name());
        LinkedHashMap<String, Object> attributes = Attributes.of(new Map.Entry[0]).put("name", type.data()).put("value", value.data()).put("dhash", (Object)"none", () -> value == PrivacySettingValue.CONTACTS_EXCEPT).toMap();
        List<Jid> excludedJids = Arrays.stream(excluded).map(JidProvider::toJid).toList();
        List<Node> children = value != PrivacySettingValue.CONTACTS_EXCEPT ? null : excludedJids.stream().map(entry -> Node.of("user", Map.of("jid", entry, "action", "add"))).toList();
        return this.socketHandler.sendQuery("set", "privacy", Node.of("privacy", (Object)Node.of("category", attributes, children))).thenRun(() -> this.onPrivacyFeatureChanged(type, value, excludedJids));
    }

    private void onPrivacyFeatureChanged(PrivacySettingType type, PrivacySettingValue value, List<Jid> excludedJids) {
        PrivacySettingEntry newEntry = new PrivacySettingEntry(type, value, excludedJids);
        PrivacySettingEntry oldEntry = this.store().findPrivacySetting(type);
        this.store().addPrivacySetting(type, newEntry);
        this.socketHandler.onPrivacySettingChanged(oldEntry, newEntry);
    }

    public CompletableFuture<Void> changeNewChatsEphemeralTimer(ChatEphemeralTimer timer) {
        return this.socketHandler.sendQuery("set", "disappearing_mode", Node.of("disappearing_mode", Map.of("duration", timer.period().toSeconds()))).thenRun(() -> this.store().setNewChatsEphemeralTimer(timer));
    }

    public CompletableFuture<Void> createGdprAccountInfo() {
        return this.socketHandler.sendQuery("get", "urn:xmpp:whatsapp:account", Node.of("gdpr", Map.of("gdpr", "request"))).thenRun(() -> {});
    }

    public CompletableFuture<GdprAccountReport> getGdprAccountInfoStatus() {
        return this.socketHandler.sendQuery("get", "urn:xmpp:whatsapp:account", Node.of("gdpr", Map.of("gdpr", "status"))).thenApplyAsync(result -> GdprAccountReport.ofPending(result.attributes().getLong("timestamp")));
    }

    public CompletableFuture<Void> changeName(String newName) {
        String oldName = this.store().name();
        return this.socketHandler.send(Node.of("presence", Map.of("name", newName))).thenRun(() -> this.socketHandler.updateUserName(newName, oldName));
    }

    public CompletableFuture<Void> changeAbout(String newAbout) {
        return this.socketHandler.changeAbout(newAbout);
    }

    public CompletableFuture<Void> subscribeToPresence(JidProvider jid) {
        return this.socketHandler.subscribeToPresence(jid);
    }

    public CompletableFuture<? extends MessageInfo> removeReaction(MessageInfo message) {
        return this.sendReaction(message, (String)null);
    }

    public CompletableFuture<? extends MessageInfo> sendReaction(MessageInfo message, Emoji reaction) {
        return this.sendReaction(message, Objects.toString((Object)reaction));
    }

    public CompletableFuture<? extends MessageInfo> sendReaction(MessageInfo message, String reaction) {
        ChatMessageKey key = new ChatMessageKeyBuilder().id(ChatMessageKey.randomId()).chatJid(message.parentJid()).senderJid(message.senderJid()).fromMe(Objects.equals(message.senderJid().withoutDevice(), this.jidOrThrowError().withoutDevice())).id(message.id()).build();
        ReactionMessage reactionMessage = new ReactionMessageBuilder().key(key).content(reaction).timestampSeconds(Instant.now().toEpochMilli()).build();
        return this.sendMessage((JidProvider)message.parentJid(), reactionMessage);
    }

    public CompletableFuture<? extends MessageInfo> sendMessage(JidProvider chat, String message) {
        return this.sendMessage(chat, MessageContainer.of(message));
    }

    public CompletableFuture<ChatMessageInfo> sendChatMessage(JidProvider chat, String message) {
        return this.sendChatMessage(chat, MessageContainer.of(message));
    }

    public CompletableFuture<NewsletterMessageInfo> sendsNewsletterMessage(JidProvider chat, String message) {
        return this.sendNewsletterMessage(chat, MessageContainer.of(message));
    }

    public CompletableFuture<? extends MessageInfo> sendMessage(JidProvider chat, String message, MessageInfo quotedMessage) {
        return this.sendMessage(chat, TextMessage.of(message), quotedMessage);
    }

    public CompletableFuture<? extends MessageInfo> sendChatMessage(JidProvider chat, String message, MessageInfo quotedMessage) {
        return this.sendChatMessage(chat, TextMessage.of(message), quotedMessage);
    }

    public CompletableFuture<? extends MessageInfo> sendNewsletterMessage(JidProvider chat, String message, MessageInfo quotedMessage) {
        return this.sendNewsletterMessage(chat, TextMessage.of(message), quotedMessage);
    }

    public CompletableFuture<? extends MessageInfo> sendMessage(JidProvider chat, ContextualMessage<?> message, MessageInfo quotedMessage) {
        ContextInfo contextInfo = ContextInfo.of(quotedMessage);
        message.setContextInfo(contextInfo);
        return this.sendMessage(chat, MessageContainer.of(message));
    }

    public CompletableFuture<ChatMessageInfo> sendChatMessage(JidProvider chat, ContextualMessage<?> message, MessageInfo quotedMessage) {
        ContextInfo contextInfo = ContextInfo.of(quotedMessage);
        message.setContextInfo(contextInfo);
        return this.sendChatMessage(chat, MessageContainer.of(message));
    }

    public CompletableFuture<NewsletterMessageInfo> sendNewsletterMessage(JidProvider chat, ContextualMessage<?> message, MessageInfo quotedMessage) {
        ContextInfo contextInfo = ContextInfo.of(quotedMessage);
        message.setContextInfo(contextInfo);
        return this.sendNewsletterMessage(chat, MessageContainer.of(message));
    }

    public CompletableFuture<? extends MessageInfo> sendMessage(JidProvider chat, Message message) {
        return this.sendMessage(chat, MessageContainer.of(message));
    }

    public CompletableFuture<? extends MessageInfo> sendMessage(JidProvider recipient, MessageContainer message) {
        return recipient.toJid().server() == JidServer.NEWSLETTER ? this.sendNewsletterMessage(recipient, message) : this.sendChatMessage(recipient, message);
    }

    public CompletableFuture<ChatMessageInfo> sendChatMessage(JidProvider recipient, MessageContainer message) {
        Validate.isTrue(!recipient.toJid().hasServer(JidServer.NEWSLETTER), "Use sendNewsletterMessage to send a message in a newsletter", new Object[0]);
        long timestamp = Clock.nowSeconds();
        DeviceContextInfo deviceInfo = new DeviceContextInfoBuilder().deviceListMetadataVersion(2).build();
        ChatMessageKey key = new ChatMessageKeyBuilder().id(ChatMessageKey.randomId()).chatJid(recipient.toJid()).fromMe(true).senderJid(this.jidOrThrowError()).build();
        ChatMessageInfo info = new ChatMessageInfoBuilder().status(MessageStatus.PENDING).senderJid(this.jidOrThrowError()).key(key).message(message.withDeviceInfo(deviceInfo)).timestampSeconds(timestamp).broadcast(recipient.toJid().hasServer(JidServer.BROADCAST)).build();
        return this.sendMessage(info);
    }

    public CompletableFuture<NewsletterMessageInfo> sendNewsletterMessage(JidProvider recipient, MessageContainer message) {
        Optional<Newsletter> newsletter = this.store().findNewsletterByJid(recipient);
        Validate.isTrue(newsletter.isPresent(), "Cannot send a message in a newsletter that you didn't join", new Object[0]);
        Integer oldServerId = newsletter.get().newestMessage().map(NewsletterMessageInfo::serverId).orElse(0);
        NewsletterMessageInfo info = new NewsletterMessageInfo(ChatMessageKey.randomId(), oldServerId + 1, Clock.nowSeconds(), null, new ConcurrentHashMap<String, NewsletterReaction>(), message, MessageStatus.PENDING);
        info.setNewsletter(newsletter.get());
        return this.sendMessage(info);
    }

    public <T extends MessageInfo> CompletableFuture<T> editMessage(T oldMessage, Message newMessage) {
        MessageType newMessageType;
        MessageType oldMessageType = oldMessage.message().content().type();
        Validate.isTrue(oldMessageType == (newMessageType = newMessage.type()), "Message type mismatch: %s != %s", new Object[]{oldMessageType, newMessageType});
        MessageInfo t = oldMessage;
        Objects.requireNonNull(t);
        MessageInfo t2 = t;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NewsletterMessageInfo.class, ChatMessageInfo.class}, t2, n)) {
            case 0 -> {
                NewsletterMessageInfo oldNewsletterInfo = (NewsletterMessageInfo)t2;
                NewsletterMessageInfo info = new NewsletterMessageInfo(oldNewsletterInfo.id(), oldNewsletterInfo.serverId(), Clock.nowSeconds(), null, new ConcurrentHashMap<String, NewsletterReaction>(), MessageContainer.ofEditedMessage(newMessage), MessageStatus.PENDING);
                info.setNewsletter(oldNewsletterInfo.newsletter());
                MessageSendRequest.Newsletter request = new MessageSendRequest.Newsletter(info, Map.of("edit", this.getEditBit(info)));
                yield this.socketHandler.sendMessage(request).thenApply(ignored -> oldMessage);
            }
            case 1 -> {
                ChatMessageInfo oldChatInfo = (ChatMessageInfo)t2;
                ChatMessageKey key = new ChatMessageKeyBuilder().id(oldChatInfo.id()).chatJid(oldChatInfo.chatJid()).fromMe(true).senderJid(this.jidOrThrowError()).build();
                ChatMessageInfo info = new ChatMessageInfoBuilder().status(MessageStatus.PENDING).senderJid(this.jidOrThrowError()).key(key).message(MessageContainer.ofEditedMessage(newMessage)).timestampSeconds(Clock.nowSeconds()).broadcast(oldChatInfo.chatJid().hasServer(JidServer.BROADCAST)).build();
                MessageSendRequest.Chat request = new MessageSendRequest.Chat(info, null, false, false, Map.of("edit", this.getEditBit(info)));
                yield this.socketHandler.sendMessage(request).thenApply(ignored -> oldMessage);
            }
            default -> throw new IllegalStateException("Unsupported edit: " + String.valueOf(oldMessage));
        };
    }

    public CompletableFuture<ChatMessageInfo> sendStatus(String message) {
        return this.sendStatus(MessageContainer.of(message));
    }

    public CompletableFuture<ChatMessageInfo> sendStatus(Message message) {
        return this.sendStatus(MessageContainer.of(message));
    }

    public CompletableFuture<ChatMessageInfo> sendStatus(MessageContainer message) {
        long timestamp = Clock.nowSeconds();
        DeviceContextInfo deviceInfo = new DeviceContextInfoBuilder().deviceListMetadataVersion(2).build();
        ChatMessageKey key = new ChatMessageKeyBuilder().id(ChatMessageKey.randomId()).chatJid(Jid.of("status@broadcast")).fromMe(true).senderJid(this.jidOrThrowError()).build();
        ChatMessageInfo info = new ChatMessageInfoBuilder().status(MessageStatus.PENDING).senderJid(this.jidOrThrowError()).key(key).message(message.withDeviceInfo(deviceInfo)).timestampSeconds(timestamp).broadcast(false).build();
        return this.sendMessage(info);
    }

    public CompletableFuture<ChatMessageInfo> sendMessage(ChatMessageInfo info) {
        return this.socketHandler.sendMessage(new MessageSendRequest.Chat(info)).thenApply(ignored -> info);
    }

    public CompletableFuture<NewsletterMessageInfo> sendMessage(NewsletterMessageInfo info) {
        return this.socketHandler.sendMessage(new MessageSendRequest.Newsletter(info)).thenApply(ignored -> info);
    }

    public CompletableFuture<Void> markChatRead(JidProvider chat) {
        return this.mark(chat, true).thenComposeAsync(ignored -> this.markAllAsRead(chat));
    }

    private CompletableFuture<Void> markAllAsRead(JidProvider chat) {
        CompletableFuture[] all = (CompletableFuture[])this.store().findChatByJid(chat.toJid()).stream().map(Chat::unreadMessages).flatMap(Collection::stream).map(this::markMessageRead).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(all);
    }

    public CompletableFuture<Void> markChatUnread(JidProvider chat) {
        return this.mark(chat, false);
    }

    private CompletableFuture<Void> mark(JidProvider chat, boolean read) {
        if (this.store().clientType() == ClientType.MOBILE) {
            this.store().findChatByJid(chat.toJid()).ifPresent(entry -> entry.setMarkedAsUnread(read));
            return CompletableFuture.completedFuture(null);
        }
        ActionMessageRangeSync range = this.createRange(chat, false);
        MarkChatAsReadAction markAction = new MarkChatAsReadAction(read, Optional.of(range));
        ActionValueSync syncAction = ActionValueSync.of(markAction);
        PatchRequest.PatchEntry entry2 = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, chat.toJid().toString());
        PatchRequest request = new PatchRequest(PatchType.REGULAR_HIGH, List.of(entry2));
        return this.socketHandler.pushPatch(request);
    }

    private ActionMessageRangeSync createRange(JidProvider chat, boolean allMessages) {
        Chat known = this.store().findChatByJid(chat.toJid()).orElseGet(() -> this.store().addNewChat(chat.toJid()));
        return new ActionMessageRangeSync(known, allMessages);
    }

    public CompletableFuture<ChatMessageInfo> markMessageRead(ChatMessageInfo info) {
        String type = this.store().findPrivacySetting(PrivacySettingType.READ_RECEIPTS).value() == PrivacySettingValue.EVERYONE ? "read" : "read-self";
        this.socketHandler.sendReceipt(info.chatJid(), info.senderJid(), List.of(info.id()), type);
        info.chat().ifPresent(chat -> {
            int count = chat.unreadMessagesCount();
            if (count > 0) {
                chat.setUnreadMessagesCount(count - 1);
            }
        });
        info.setStatus(MessageStatus.READ);
        return CompletableFuture.completedFuture(info);
    }

    public CompletableFuture<ChatMessageInfo> awaitMessageReply(ChatMessageInfo info) {
        return this.awaitMessageReply(info.id());
    }

    public CompletableFuture<ChatMessageInfo> awaitMessageReply(String id) {
        return this.store().addPendingReply(id);
    }

    public CompletableFuture<HasWhatsappResponse> hasWhatsapp(JidProvider contact) {
        return this.hasWhatsapp(new JidProvider[]{contact}).thenApply(result -> (HasWhatsappResponse)result.get(contact.toJid()));
    }

    public CompletableFuture<Map<Jid, HasWhatsappResponse>> hasWhatsapp(JidProvider ... contacts) {
        List<Jid> jids = Arrays.stream(contacts).map(JidProvider::toJid).toList();
        List<Node> contactNodes = jids.stream().map(jid -> Node.of("user", (Object)Node.of("contact", jid.toPhoneNumber()))).toList();
        return this.socketHandler.sendInteractiveQuery(List.of(Node.of("contact")), contactNodes, List.of()).thenApplyAsync(result -> this.parseHasWhatsappResponse(jids, (List<Node>)result));
    }

    private Map<Jid, HasWhatsappResponse> parseHasWhatsappResponse(List<Jid> contacts, List<Node> nodes) {
        HashMap result = nodes.stream().map(this::parseHasWhatsappResponse).collect(Collectors.toMap(HasWhatsappResponse::contact, Function.identity(), (first, second) -> first, HashMap::new));
        contacts.stream().filter(contact -> !result.containsKey(contact)).forEach(contact -> result.put(contact, new HasWhatsappResponse((Jid)contact, false)));
        return Collections.unmodifiableMap(result);
    }

    private HasWhatsappResponse parseHasWhatsappResponse(Node node) {
        Jid jid = node.attributes().getRequiredJid("jid");
        boolean in = node.findNode("contact").orElseThrow(() -> new NoSuchElementException("Missing contact in HasWhatsappResponse")).attributes().getRequiredString("type").equals("in");
        return new HasWhatsappResponse(jid, in);
    }

    public CompletableFuture<List<Jid>> queryBlockList() {
        return this.socketHandler.queryBlockList();
    }

    public CompletableFuture<Optional<String>> queryName(JidProvider contactJid) {
        Optional<Contact> contact = this.store().findContactByJid(contactJid);
        return contact.map(value -> CompletableFuture.completedFuture(value.chosenName())).orElseGet(() -> this.queryNameFromServer(contactJid));
    }

    private CompletableFuture<Optional<String>> queryNameFromServer(JidProvider contactJid) {
        UserChosenNameRequest query = new UserChosenNameRequest(List.of(new UserChosenNameRequest.Variable(contactJid.toJid().user())));
        return this.socketHandler.sendQuery("get", "w:mex", Node.of("query", Map.of("query_id", "6556393721124826"), (Object)Json.writeValueAsBytes(query))).thenApplyAsync(this::parseNameResponse);
    }

    private Optional<String> parseNameResponse(Node result) {
        return result.findNode("result").flatMap(Node::contentAsString).flatMap(UserChosenNameResponse::ofJson).flatMap(UserChosenNameResponse::name);
    }

    public CompletableFuture<Optional<ContactAboutResponse>> queryAbout(JidProvider chat) {
        return this.socketHandler.queryAbout(chat);
    }

    public CompletableFuture<Optional<URI>> queryPicture(JidProvider chat) {
        return this.socketHandler.queryPicture(chat);
    }

    public CompletableFuture<GroupMetadata> queryGroupMetadata(JidProvider chat) {
        return this.socketHandler.queryGroupMetadata(chat.toJid());
    }

    public CompletableFuture<Optional<BusinessProfile>> queryBusinessProfile(JidProvider contact) {
        return this.socketHandler.sendQuery("get", "w:biz", Node.of("business_profile", Map.of("v", 116), (Object)Node.of("profile", Map.of("jid", contact.toJid())))).thenApplyAsync(this::getBusinessProfile);
    }

    private Optional<BusinessProfile> getBusinessProfile(Node result) {
        return result.findNode("business_profile").flatMap(entry -> entry.findNode("profile")).map(BusinessProfile::of);
    }

    public CompletableFuture<List<BusinessCategory>> queryBusinessCategories() {
        return this.socketHandler.queryBusinessCategories();
    }

    public CompletableFuture<String> queryGroupInviteCode(JidProvider chat) {
        return this.socketHandler.sendQuery(chat.toJid(), "get", "w:g2", Node.of("invite")).thenApplyAsync(this::parseInviteCode);
    }

    private String parseInviteCode(Node result) {
        return result.findNode("invite").orElseThrow(() -> new NoSuchElementException("Missing invite code in invite newsletters")).attributes().getRequiredString("code");
    }

    public CompletableFuture<Void> revokeGroupInvite(JidProvider chat) {
        return this.socketHandler.sendQuery(chat.toJid(), "set", "w:g2", Node.of("invite")).thenRun(() -> {});
    }

    public CompletableFuture<Optional<Chat>> acceptGroupInvite(String inviteCode) {
        return this.socketHandler.sendQuery(JidServer.GROUP.toJid(), "set", "w:g2", Node.of("invite", Map.of("code", inviteCode))).thenApplyAsync(this::parseAcceptInvite);
    }

    private Optional<Chat> parseAcceptInvite(Node result) {
        return result.findNode("group").flatMap(group -> group.attributes().getOptionalJid("jid")).map(jid -> this.store().findChatByJid((JidProvider)jid).orElseGet(() -> this.store().addNewChat((Jid)jid)));
    }

    public CompletableFuture<Boolean> changePresence(boolean available) {
        boolean status = this.socketHandler.store().online();
        if (status == available) {
            return CompletableFuture.completedFuture(status);
        }
        ContactStatus presence = available ? ContactStatus.AVAILABLE : ContactStatus.UNAVAILABLE;
        Node node = Node.of("presence", Map.of("name", this.store().name(), "type", presence.toString()));
        return ((CompletableFuture)this.socketHandler.sendWithNoResponse(node).thenAcceptAsync(socketHandler -> this.updateSelfPresence(null, presence))).thenApplyAsync(ignored -> available);
    }

    private void updateSelfPresence(JidProvider chatJid, ContactStatus presence) {
        Optional<Contact> self;
        if (chatJid == null) {
            this.store().setOnline(presence == ContactStatus.AVAILABLE);
        }
        if ((self = this.store().findContactByJid(this.jidOrThrowError().withoutDevice())).isEmpty()) {
            return;
        }
        if (presence == ContactStatus.AVAILABLE || presence == ContactStatus.UNAVAILABLE) {
            self.get().setLastKnownPresence(presence);
        }
        if (chatJid != null) {
            this.store().findChatByJid(chatJid).ifPresent(chat -> chat.presences().put(((Contact)self.get()).jid(), presence));
        }
        self.get().setLastSeen(ZonedDateTime.now());
    }

    public CompletableFuture<Void> changePresence(JidProvider chatJid, ContactStatus presence) {
        ContactStatus knownPresence = this.store().findChatByJid(chatJid).map(Chat::presences).map(entry -> (ContactStatus)((Object)((Object)entry.get(this.jidOrThrowError().withoutDevice())))).orElse(null);
        if (knownPresence == ContactStatus.COMPOSING || knownPresence == ContactStatus.RECORDING) {
            Node node = Node.of("chatstate", Map.of("to", chatJid.toJid()), (Object)Node.of("paused"));
            return this.socketHandler.sendWithNoResponse(node);
        }
        if (presence == ContactStatus.COMPOSING || presence == ContactStatus.RECORDING) {
            ContactStatus tag = presence == ContactStatus.RECORDING ? ContactStatus.COMPOSING : presence;
            Node node = Node.of("chatstate", Map.of("to", chatJid.toJid()), (Object)Node.of(ContactStatus.COMPOSING.toString(), presence == ContactStatus.RECORDING ? Map.of("media", "audio") : Map.of()));
            return this.socketHandler.sendWithNoResponse(node).thenAcceptAsync(socketHandler -> this.updateSelfPresence(chatJid, presence));
        }
        Node node = Node.of("presence", Map.of("type", presence.toString(), "name", this.store().name()));
        return this.socketHandler.sendWithNoResponse(node).thenAcceptAsync(socketHandler -> this.updateSelfPresence(chatJid, presence));
    }

    public CompletableFuture<List<Jid>> promoteGroupParticipant(JidProvider group, JidProvider ... contacts) {
        return this.executeActionOnGroupParticipant(group, GroupAction.PROMOTE, contacts);
    }

    public CompletableFuture<List<Jid>> demoteGroupParticipant(JidProvider group, JidProvider ... contacts) {
        return this.executeActionOnGroupParticipant(group, GroupAction.DEMOTE, contacts);
    }

    public CompletableFuture<List<Jid>> addGroupParticipant(JidProvider group, JidProvider ... contacts) {
        return this.executeActionOnGroupParticipant(group, GroupAction.ADD, contacts);
    }

    public CompletableFuture<List<Jid>> removeGroupParticipant(JidProvider group, JidProvider ... contacts) {
        return this.executeActionOnGroupParticipant(group, GroupAction.REMOVE, contacts);
    }

    private CompletableFuture<List<Jid>> executeActionOnGroupParticipant(JidProvider group, GroupAction action, JidProvider ... jids) {
        Node[] body = (Node[])Arrays.stream(jids).map(JidProvider::toJid).map(jid -> Node.of("participant", Map.of("jid", this.checkGroupParticipantJid((Jid)jid, "Cannot execute action on yourself")))).map(innerBody -> Node.of(action.data(), innerBody)).toArray(Node[]::new);
        return this.socketHandler.sendQuery(group.toJid(), "set", "w:g2", body).thenApplyAsync(result -> this.parseGroupActionResponse((Node)result, group, action));
    }

    private Jid checkGroupParticipantJid(Jid jid, String errorMessage) {
        Validate.isTrue(!Objects.equals(jid.withoutDevice(), this.jidOrThrowError().withoutDevice()), errorMessage, new Object[0]);
        return jid;
    }

    private List<Jid> parseGroupActionResponse(Node result, JidProvider groupJid, GroupAction action) {
        Chat entry2;
        Chat chat;
        List<Jid> results = result.findNode(action.data()).orElseThrow(() -> new NoSuchElementException("An erroneous group operation was executed")).findNodes("participant").stream().filter(participant -> !participant.attributes().hasKey("error")).map(participant -> participant.attributes().getOptionalJid("jid")).flatMap(Optional::stream).toList();
        Chat chat2 = chat = groupJid instanceof Chat ? (entry2 = (Chat)groupJid) : (Chat)this.store().findChatByJid(groupJid).orElse(null);
        if (chat != null) {
            results.forEach(entry -> this.handleGroupAction(action, chat, (Jid)entry));
        }
        return results;
    }

    private void handleGroupAction(GroupAction action, Chat chat, Jid entry) {
        switch (action) {
            case ADD: {
                chat.addParticipant(entry, GroupRole.USER);
                break;
            }
            case REMOVE: {
                chat.removeParticipant(entry);
                chat.addPastParticipant(new GroupPastParticipant(entry, GroupPastParticipant.Reason.REMOVED, Clock.nowSeconds()));
                break;
            }
            case PROMOTE: {
                chat.findParticipant(entry).ifPresent(participant -> participant.setRole(GroupRole.ADMIN));
                break;
            }
            case DEMOTE: {
                chat.findParticipant(entry).ifPresent(participant -> participant.setRole(GroupRole.USER));
            }
        }
    }

    public CompletableFuture<Void> changeGroupSubject(JidProvider group, String newName) {
        Node body = Node.of("subject", newName.getBytes(StandardCharsets.UTF_8));
        return this.socketHandler.sendQuery(group.toJid(), "set", "w:g2", body).thenRun(() -> {});
    }

    public CompletableFuture<Void> changeGroupDescription(JidProvider group, String description) {
        return ((CompletableFuture)((CompletableFuture)this.socketHandler.queryGroupMetadata(group.toJid()).thenApplyAsync(GroupMetadata::descriptionId)).thenComposeAsync(descriptionId -> this.changeGroupDescription(group, description, descriptionId.orElse(null)))).thenRun(() -> {});
    }

    private CompletableFuture<Void> changeGroupDescription(JidProvider group, String description, String descriptionId) {
        Node descriptionNode = Optional.ofNullable(description).map(content -> Node.of("body", content.getBytes(StandardCharsets.UTF_8))).orElse(null);
        LinkedHashMap<String, Object> attributes = Attributes.of(new Map.Entry[0]).put("id", (Object)ChatMessageKey.randomId(), () -> description != null).put("delete", (Object)true, () -> description == null).put("prev", (Object)descriptionId, () -> descriptionId != null).toMap();
        Node body = Node.of("description", attributes, (Object)descriptionNode);
        return this.socketHandler.sendQuery(group.toJid(), "set", "w:g2", body).thenRun(() -> this.onDescriptionSet(group, description));
    }

    private void onDescriptionSet(JidProvider groupJid, String description) {
        if (groupJid instanceof Chat) {
            Chat chat2 = (Chat)groupJid;
            chat2.setDescription(description);
            return;
        }
        Optional<Chat> group = this.store().findChatByJid(groupJid);
        group.ifPresent(chat -> chat.setDescription(description));
    }

    public CompletableFuture<Void> changeGroupSetting(JidProvider group, GroupSetting setting, ChatSettingPolicy policy) {
        Validate.isTrue(group.toJid().hasServer(JidServer.GROUP), "This method only accepts groups", new Object[0]);
        Node body = switch (setting) {
            default -> throw new MatchException(null, null);
            case GroupSetting.EDIT_GROUP_INFO -> Node.of(policy == ChatSettingPolicy.ADMINS ? "locked" : "unlocked");
            case GroupSetting.SEND_MESSAGES -> Node.of(policy == ChatSettingPolicy.ADMINS ? "announcement" : "not_announcement");
            case GroupSetting.ADD_PARTICIPANTS -> Node.of("member_add_mode", policy == ChatSettingPolicy.ADMINS ? "admin_add".getBytes(StandardCharsets.UTF_8) : "all_member_add".getBytes(StandardCharsets.UTF_8));
            case GroupSetting.APPROVE_PARTICIPANTS -> Node.of("membership_approval_mode", (Object)Node.of("group_join", Map.of("state", policy == ChatSettingPolicy.ADMINS ? "on" : "off")));
        };
        return this.socketHandler.sendQuery(group.toJid(), "set", "w:g2", body).thenRun(() -> {});
    }

    public CompletableFuture<Void> changeProfilePicture(byte[] image) {
        return this.changeGroupPicture((JidProvider)this.jidOrThrowError(), image);
    }

    public CompletableFuture<Void> changeGroupPicture(JidProvider group, URI image) {
        CompletableFuture<byte[]> imageFuture = image == null ? CompletableFuture.completedFuture(null) : Medias.downloadAsync(image, new Map.Entry[0]);
        return imageFuture.thenComposeAsync(imageResult -> this.changeGroupPicture(group, (byte[])imageResult));
    }

    public CompletableFuture<Void> changeGroupPicture(JidProvider group, byte[] image) {
        byte[] profilePic = image != null ? Medias.getProfilePic(image) : null;
        Node body = Node.of("picture", Map.of("type", "image"), (Object)profilePic);
        return this.socketHandler.sendQuery(group.toJid().withoutDevice(), "set", "w:profile:picture", body).thenRun(() -> {});
    }

    public CompletableFuture<Optional<GroupMetadata>> createGroup(String subject, JidProvider ... contacts) {
        return this.createGroup(subject, ChatEphemeralTimer.OFF, contacts);
    }

    public CompletableFuture<Optional<GroupMetadata>> createGroup(String subject, ChatEphemeralTimer timer, JidProvider ... contacts) {
        return this.createGroup(subject, timer, (JidProvider)null, contacts);
    }

    public CompletableFuture<Optional<GroupMetadata>> createGroup(String subject, ChatEphemeralTimer timer, JidProvider parentGroup) {
        return this.createGroup(subject, timer, parentGroup, new JidProvider[0]);
    }

    public CompletableFuture<Optional<GroupMetadata>> createGroup(String subject, ChatEphemeralTimer timer, JidProvider parentCommunity, JidProvider ... contacts) {
        Validate.isTrue(!subject.isBlank(), "The subject of a group cannot be blank", new Object[0]);
        Validate.isTrue(parentCommunity != null || contacts.length >= 1, "Expected at least 1 member for this group", new Object[0]);
        ArrayList<Node> children = new ArrayList<Node>();
        if (parentCommunity != null) {
            children.add(Node.of("linked_parent", Map.of("jid", parentCommunity.toJid())));
        }
        if (timer != ChatEphemeralTimer.OFF) {
            children.add(Node.of("ephemeral", Map.of("expiration", timer.periodSeconds())));
        }
        Arrays.stream(contacts).map(contact -> Node.of("participant", Map.of("jid", this.checkGroupParticipantJid(contact.toJid(), "Cannot create group with yourself as a participant")))).forEach(children::add);
        String key = HexFormat.of().formatHex(BytesHelper.random(12));
        Node body = Node.of("create", Map.of("subject", subject, "key", key), children);
        return this.socketHandler.sendQuery(JidServer.GROUP.toJid(), "set", "w:g2", body).thenApplyAsync(this::parseGroupResponse);
    }

    private Optional<GroupMetadata> parseGroupResponse(Node response) {
        return Optional.ofNullable(response).flatMap(node -> node.findNode("group")).map(this.socketHandler::parseGroupMetadata).map(this::addNewGroup);
    }

    private GroupMetadata addNewGroup(GroupMetadata result) {
        ChatBuilder chatBuilder = new ChatBuilder().jid(result.jid()).description(result.description().orElse(null)).participants(new ArrayList<GroupParticipant>(result.participants())).founder(result.founder().orElse(null));
        result.foundationTimestamp().map(ChronoZonedDateTime::toEpochSecond).ifPresent(chatBuilder::foundationTimestampSeconds);
        this.store().addChat(chatBuilder.build());
        return result;
    }

    private String findErrorNode(Node result) {
        return Optional.ofNullable(result).flatMap(node -> node.findNode("error")).map(Node::toString).orElseGet(() -> Objects.toString(result));
    }

    public CompletableFuture<Void> leaveGroup(JidProvider group) {
        Node body = Node.of("leave", (Object)Node.of("group", Map.of("id", group.toJid())));
        return this.socketHandler.sendQuery(JidServer.GROUP.toJid(), "set", "w:g2", body).thenAcceptAsync(ignored -> this.handleLeaveGroup(group));
    }

    private void handleLeaveGroup(JidProvider group) {
        Chat entry;
        Chat chat;
        Chat chat2 = chat = group instanceof Chat ? (entry = (Chat)group) : (Chat)this.store().findChatByJid(group).orElse(null);
        if (chat != null) {
            GroupPastParticipant pastParticipant = new GroupPastParticipantBuilder().jid(this.jidOrThrowError().withoutDevice()).reason(GroupPastParticipant.Reason.REMOVED).timestampSeconds(Clock.nowSeconds()).build();
            chat.addPastParticipant(pastParticipant);
        }
    }

    public CompletableFuture<Map<Jid, Boolean>> linkGroupsToCommunity(JidProvider community, JidProvider ... groups) {
        Node[] body = (Node[])Arrays.stream(groups).map(entry -> Node.of("group", Map.of("jid", entry.toJid()))).toArray(Node[]::new);
        return this.socketHandler.sendQuery(community.toJid(), "set", "w:g2", Node.of("links", (Object)Node.of("link", Map.of("link_type", "sub_group"), body))).thenApplyAsync(result -> this.parseLinksResponse((Node)result, groups));
    }

    private Map<Jid, Boolean> parseLinksResponse(Node result, JidProvider[] groups) {
        Set success = result.findNode("links").stream().map(entry -> entry.findNodes("link")).flatMap(Collection::stream).filter(entry -> entry.attributes().hasValue("link_type", "sub_group")).map(entry -> entry.findNode("group")).flatMap(Optional::stream).map(entry -> entry.attributes().getOptionalJid("jid")).flatMap(Optional::stream).collect(Collectors.toUnmodifiableSet());
        return Arrays.stream(groups).map(JidProvider::toJid).collect(Collectors.toUnmodifiableMap(Function.identity(), success::contains));
    }

    public CompletableFuture<Boolean> unlinkGroupFromCommunity(JidProvider community, JidProvider group) {
        return this.socketHandler.sendQuery(community.toJid(), "set", "w:g2", Node.of("unlink", Map.of("unlink_type", "sub_group"), (Object)Node.of("group", Map.of("jid", group.toJid())))).thenApplyAsync(result -> this.parseUnlinkResponse((Node)result, group));
    }

    private boolean parseUnlinkResponse(Node result, JidProvider group) {
        return result.findNode("unlink").filter(entry -> entry.attributes().hasValue("unlink_type", "sub_group")).flatMap(entry -> entry.findNode("group")).map(entry -> entry.attributes().hasValue("jid", group.toJid().toString())).isPresent();
    }

    public CompletableFuture<Void> muteChat(JidProvider chat) {
        return this.muteChat(chat, ChatMute.muted());
    }

    public CompletableFuture<Void> muteChat(JidProvider chat, ChatMute mute) {
        if (this.store().clientType() == ClientType.MOBILE) {
            this.store().findChatByJid(chat).ifPresent(entry -> entry.setMute(mute));
            return CompletableFuture.completedFuture(null);
        }
        long endTimeStamp = mute.type() == ChatMute.Type.MUTED_FOR_TIMEFRAME ? mute.endTimeStamp() * 1000L : mute.endTimeStamp();
        MuteAction muteAction = new MuteAction(true, OptionalLong.of(endTimeStamp), false);
        ActionValueSync syncAction = ActionValueSync.of(muteAction);
        PatchRequest.PatchEntry entry2 = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, chat.toJid().toString());
        PatchRequest request = new PatchRequest(PatchType.REGULAR_HIGH, List.of(entry2));
        return this.socketHandler.pushPatch(request);
    }

    public CompletableFuture<Void> unmuteChat(JidProvider chat) {
        if (this.store().clientType() == ClientType.MOBILE) {
            this.store().findChatByJid(chat).ifPresent(entry -> entry.setMute(ChatMute.notMuted()));
            return CompletableFuture.completedFuture(null);
        }
        MuteAction muteAction = new MuteAction(false, null, false);
        ActionValueSync syncAction = ActionValueSync.of(muteAction);
        PatchRequest.PatchEntry entry2 = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, chat.toJid().toString());
        PatchRequest request = new PatchRequest(PatchType.REGULAR_HIGH, List.of(entry2));
        return this.socketHandler.pushPatch(request);
    }

    public CompletableFuture<Void> blockContact(JidProvider contact) {
        Node body = Node.of("item", Map.of("action", "block", "jid", contact.toJid()));
        return this.socketHandler.sendQuery("set", "blocklist", body).thenRun(() -> {});
    }

    public CompletableFuture<Void> unblockContact(JidProvider contact) {
        Node body = Node.of("item", Map.of("action", "unblock", "jid", contact.toJid()));
        return this.socketHandler.sendQuery("set", "blocklist", body).thenRun(() -> {});
    }

    public CompletableFuture<Void> changeEphemeralTimer(JidProvider chat, ChatEphemeralTimer timer) {
        return switch (chat.toJid().server()) {
            case JidServer.USER, JidServer.WHATSAPP -> {
                ProtocolMessage message = new ProtocolMessageBuilder().protocolType(ProtocolMessage.Type.EPHEMERAL_SETTING).ephemeralExpiration(timer.period().toSeconds()).build();
                yield this.sendMessage(chat, message).thenRun(() -> {});
            }
            case JidServer.GROUP -> {
                Node body = timer == ChatEphemeralTimer.OFF ? Node.of("not_ephemeral") : Node.of("ephemeral", Map.of("expiration", timer.period().toSeconds()));
                yield this.socketHandler.sendQuery(chat.toJid(), "set", "w:g2", body).thenRun(() -> {});
            }
            default -> throw new IllegalArgumentException("Unexpected chat %s: ephemeral messages are only supported for conversations and groups".formatted(chat.toJid()));
        };
    }

    public CompletableFuture<ChatMessageInfo> markMessagePlayed(ChatMessageInfo info) {
        if (this.store().findPrivacySetting(PrivacySettingType.READ_RECEIPTS).value() != PrivacySettingValue.EVERYONE) {
            return CompletableFuture.completedFuture(info);
        }
        this.socketHandler.sendReceipt(info.chatJid(), info.senderJid(), List.of(info.id()), "played");
        info.setStatus(MessageStatus.PLAYED);
        return CompletableFuture.completedFuture(info);
    }

    public CompletableFuture<Void> pinChat(JidProvider chat) {
        return this.pinChat(chat, true);
    }

    public CompletableFuture<Void> unpinChat(JidProvider chat) {
        return this.pinChat(chat, false);
    }

    private CompletableFuture<Void> pinChat(JidProvider chat, boolean pin) {
        if (this.store().clientType() == ClientType.MOBILE) {
            this.store().findChatByJid(chat).ifPresent(entry -> entry.setPinnedTimestampSeconds(pin ? (int)Clock.nowSeconds() : 0));
            return CompletableFuture.completedFuture(null);
        }
        PinAction pinAction = new PinAction(pin);
        ActionValueSync syncAction = ActionValueSync.of(pinAction);
        PatchRequest.PatchEntry entry2 = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, chat.toJid().toString());
        PatchRequest request = new PatchRequest(PatchType.REGULAR_LOW, List.of(entry2));
        return this.socketHandler.pushPatch(request);
    }

    public CompletableFuture<ChatMessageInfo> starMessage(ChatMessageInfo info) {
        return this.starMessage(info, true);
    }

    private CompletableFuture<ChatMessageInfo> starMessage(ChatMessageInfo info, boolean star) {
        if (this.store().clientType() == ClientType.MOBILE) {
            info.setStarred(star);
            return CompletableFuture.completedFuture(info);
        }
        StarAction starAction = new StarAction(star);
        ActionValueSync syncAction = ActionValueSync.of(starAction);
        PatchRequest.PatchEntry entry = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, info.chatJid().toString(), info.id(), this.fromMeToFlag(info), this.participantToFlag(info));
        PatchRequest request = new PatchRequest(PatchType.REGULAR_HIGH, List.of(entry));
        return this.socketHandler.pushPatch(request).thenApplyAsync(ignored -> info);
    }

    private String fromMeToFlag(MessageInfo info) {
        boolean fromMe = Objects.equals(info.senderJid().withoutDevice(), this.jidOrThrowError().withoutDevice());
        return this.booleanToInt(fromMe);
    }

    private String participantToFlag(MessageInfo info) {
        boolean fromMe = Objects.equals(info.senderJid().withoutDevice(), this.jidOrThrowError().withoutDevice());
        return info.parentJid().hasServer(JidServer.GROUP) && !fromMe ? info.senderJid().toString() : "0";
    }

    private String booleanToInt(boolean keepStarredMessages) {
        return keepStarredMessages ? "1" : "0";
    }

    public CompletableFuture<ChatMessageInfo> unstarMessage(ChatMessageInfo info) {
        return this.starMessage(info, false);
    }

    public CompletableFuture<Void> archiveChat(JidProvider chat) {
        return this.archiveChat(chat, true);
    }

    private CompletableFuture<Void> archiveChat(JidProvider chat, boolean archive) {
        if (this.store().clientType() == ClientType.MOBILE) {
            this.store().findChatByJid(chat).ifPresent(entry -> entry.setArchived(archive));
            return CompletableFuture.completedFuture(null);
        }
        ActionMessageRangeSync range = this.createRange(chat, false);
        ArchiveChatAction archiveAction = new ArchiveChatAction(archive, Optional.of(range));
        ActionValueSync syncAction = ActionValueSync.of(archiveAction);
        PatchRequest.PatchEntry entry2 = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, chat.toJid().toString());
        PatchRequest request = new PatchRequest(PatchType.REGULAR_LOW, List.of(entry2));
        return this.socketHandler.pushPatch(request);
    }

    public CompletableFuture<Void> unarchive(JidProvider chat) {
        return this.archiveChat(chat, false);
    }

    public CompletableFuture<Void> deleteMessage(NewsletterMessageInfo messageInfo) {
        NewsletterMessageInfo revokeInfo = new NewsletterMessageInfo(messageInfo.id(), messageInfo.serverId(), Clock.nowSeconds(), null, new ConcurrentHashMap<String, NewsletterReaction>(), MessageContainer.empty(), MessageStatus.PENDING);
        revokeInfo.setNewsletter(messageInfo.newsletter());
        Map<String, Integer> attrs = Map.of("edit", this.getDeleteBit(messageInfo));
        MessageSendRequest.Newsletter request = new MessageSendRequest.Newsletter(revokeInfo, attrs);
        return this.socketHandler.sendMessage(request);
    }

    public CompletableFuture<Void> deleteMessage(ChatMessageInfo messageInfo, boolean everyone) {
        if (everyone) {
            ProtocolMessage message = new ProtocolMessageBuilder().protocolType(ProtocolMessage.Type.REVOKE).key(messageInfo.key()).build();
            Jid sender = messageInfo.chatJid().hasServer(JidServer.GROUP) ? this.jidOrThrowError() : null;
            ChatMessageKey key = new ChatMessageKeyBuilder().id(ChatMessageKey.randomId()).chatJid(messageInfo.chatJid()).fromMe(true).senderJid(sender).build();
            ChatMessageInfo revokeInfo = new ChatMessageInfoBuilder().status(MessageStatus.PENDING).senderJid(sender).key(key).message(MessageContainer.of(message)).timestampSeconds(Clock.nowSeconds()).build();
            Map<String, Integer> attrs = Map.of("edit", this.getDeleteBit(messageInfo));
            MessageSendRequest.Chat request = new MessageSendRequest.Chat(revokeInfo, null, false, false, attrs);
            return this.socketHandler.sendMessage(request);
        }
        return switch (this.store().clientType()) {
            default -> throw new MatchException(null, null);
            case ClientType.WEB -> {
                ActionMessageRangeSync range = this.createRange(messageInfo.chatJid(), false);
                DeleteMessageForMeAction deleteMessageAction = new DeleteMessageForMeAction(false, messageInfo.timestampSeconds().orElse(0L));
                ActionValueSync syncAction = ActionValueSync.of(deleteMessageAction);
                PatchRequest.PatchEntry entry = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, messageInfo.chatJid().toString(), messageInfo.id(), this.fromMeToFlag(messageInfo), this.participantToFlag(messageInfo));
                PatchRequest request = new PatchRequest(PatchType.REGULAR_HIGH, List.of(entry));
                yield this.socketHandler.pushPatch(request);
            }
            case ClientType.MOBILE -> {
                messageInfo.chat().ifPresent(chat -> chat.removeMessage(messageInfo));
                yield CompletableFuture.completedFuture(null);
            }
        };
    }

    private int getEditBit(MessageInfo info) {
        if (info.parentJid().hasServer(JidServer.NEWSLETTER)) {
            return 3;
        }
        return 1;
    }

    private int getDeleteBit(MessageInfo info) {
        if (info.parentJid().hasServer(JidServer.NEWSLETTER)) {
            return 8;
        }
        boolean fromMe = Objects.equals(info.senderJid().withoutDevice(), this.jidOrThrowError().withoutDevice());
        if (info.parentJid().hasServer(JidServer.GROUP) && !fromMe) {
            return 8;
        }
        return 7;
    }

    public CompletableFuture<Void> deleteChat(JidProvider chat) {
        if (this.store().clientType() == ClientType.MOBILE) {
            this.store().removeChat(chat.toJid());
            return CompletableFuture.completedFuture(null);
        }
        ActionMessageRangeSync range = this.createRange(chat.toJid(), false);
        DeleteChatAction deleteChatAction = new DeleteChatAction(Optional.of(range));
        ActionValueSync syncAction = ActionValueSync.of(deleteChatAction);
        PatchRequest.PatchEntry entry = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, chat.toJid().toString(), "1");
        PatchRequest request = new PatchRequest(PatchType.REGULAR_HIGH, List.of(entry));
        return this.socketHandler.pushPatch(request);
    }

    public CompletableFuture<Void> clearChat(JidProvider chat, boolean keepStarredMessages) {
        if (this.store().clientType() == ClientType.MOBILE) {
            this.store().findChatByJid(chat.toJid()).ifPresent(Chat::removeMessages);
            return CompletableFuture.completedFuture(null);
        }
        Optional<Chat> known = this.store().findChatByJid(chat);
        ActionMessageRangeSync range = this.createRange(chat.toJid(), true);
        ClearChatAction clearChatAction = new ClearChatAction(Optional.of(range));
        ActionValueSync syncAction = ActionValueSync.of(clearChatAction);
        PatchRequest.PatchEntry entry = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, chat.toJid().toString(), this.booleanToInt(keepStarredMessages), "0");
        PatchRequest request = new PatchRequest(PatchType.REGULAR_HIGH, List.of(entry));
        return this.socketHandler.pushPatch(request);
    }

    public CompletableFuture<String> changeBusinessDescription(String description) {
        return this.changeBusinessAttribute("description", description);
    }

    private CompletableFuture<String> changeBusinessAttribute(String key, String value) {
        return ((CompletableFuture)this.socketHandler.sendQuery("set", "w:biz", Node.of("business_profile", Map.of("v", "3", "mutation_type", "delta"), (Object)Node.of(key, Objects.requireNonNullElse(value, "").getBytes(StandardCharsets.UTF_8)))).thenAcceptAsync(result -> this.checkBusinessAttributeConflict(key, value, (Node)result))).thenApplyAsync(ignored -> value);
    }

    private void checkBusinessAttributeConflict(String key, String value, Node result) {
        Optional keyNode = result.findNode("profile").flatMap(entry -> entry.findNode(key));
        if (keyNode.isEmpty()) {
            return;
        }
        String actual = ((Node)keyNode.get()).contentAsString().orElseThrow(() -> new NoSuchElementException("Missing business %s newsletters, something went wrong: %s".formatted(key, this.findErrorNode(result))));
        Validate.isTrue(value == null || value.equals(actual), "Cannot change business %s: conflict(expected %s, got %s)", key, value, actual);
    }

    public CompletableFuture<String> changeBusinessAddress(String address) {
        return this.changeBusinessAttribute("address", address);
    }

    public CompletableFuture<String> changeBusinessEmail(String email) {
        Validate.isTrue(email == null || this.isValidEmail(email), "Invalid email: %s", email);
        return this.changeBusinessAttribute("email", email);
    }

    private boolean isValidEmail(String email) {
        return Pattern.compile("^(.+)@(\\S+)$").matcher(email).matches();
    }

    public CompletableFuture<List<BusinessCategory>> changeBusinessCategories(List<BusinessCategory> categories) {
        return this.socketHandler.sendQuery("set", "w:biz", Node.of("business_profile", Map.of("v", "3", "mutation_type", "delta"), (Object)Node.of("categories", this.createCategories(categories)))).thenApplyAsync(ignored -> categories);
    }

    private Collection<Node> createCategories(List<BusinessCategory> categories) {
        if (categories == null) {
            return List.of();
        }
        return categories.stream().map(entry -> Node.of("category", Map.of("id", entry.id()))).toList();
    }

    public CompletableFuture<List<URI>> changeBusinessWebsites(List<URI> websites) {
        return this.socketHandler.sendQuery("set", "w:biz", Node.of("business_profile", Map.of("v", "3", "mutation_type", "delta"), this.createWebsites(websites))).thenApplyAsync(ignored -> websites);
    }

    private List<Node> createWebsites(List<URI> websites) {
        if (websites == null) {
            return List.of();
        }
        return websites.stream().map(entry -> Node.of("website", entry.toString().getBytes(StandardCharsets.UTF_8))).toList();
    }

    public CompletableFuture<List<BusinessCatalogEntry>> queryBusinessCatalog() {
        return this.queryBusinessCatalog(10);
    }

    public CompletableFuture<List<BusinessCatalogEntry>> queryBusinessCatalog(int productsLimit) {
        return this.queryBusinessCatalog(this.jidOrThrowError().withoutDevice(), productsLimit);
    }

    public CompletableFuture<List<BusinessCatalogEntry>> queryBusinessCatalog(JidProvider contact, int productsLimit) {
        return this.socketHandler.sendQuery("get", "w:biz:catalog", Node.of("product_catalog", Map.of("jid", contact, "allow_shop_source", "true"), Node.of("limit", String.valueOf(productsLimit).getBytes(StandardCharsets.UTF_8)), Node.of("width", "100".getBytes(StandardCharsets.UTF_8)), Node.of("height", "100".getBytes(StandardCharsets.UTF_8)))).thenApplyAsync(this::parseCatalog);
    }

    private List<BusinessCatalogEntry> parseCatalog(Node result) {
        return Objects.requireNonNull(result, "Cannot query business catalog, missing newsletters node").findNode("product_catalog").map(entry -> entry.findNodes("product")).stream().flatMap(Collection::stream).map(BusinessCatalogEntry::of).toList();
    }

    public CompletableFuture<List<BusinessCatalogEntry>> queryBusinessCatalog(JidProvider contact) {
        return this.queryBusinessCatalog(contact, 10);
    }

    public CompletableFuture<?> queryBusinessCollections() {
        return this.queryBusinessCollections(50);
    }

    public CompletableFuture<?> queryBusinessCollections(int collectionsLimit) {
        return this.queryBusinessCollections(this.jidOrThrowError().withoutDevice(), collectionsLimit);
    }

    public CompletableFuture<List<BusinessCollectionEntry>> queryBusinessCollections(JidProvider contact, int collectionsLimit) {
        return this.socketHandler.sendQuery("get", "w:biz:catalog", Map.of("smax_id", "35"), Node.of("collections", Map.of("biz_jid", contact), Node.of("collection_limit", String.valueOf(collectionsLimit).getBytes(StandardCharsets.UTF_8)), Node.of("item_limit", String.valueOf(collectionsLimit).getBytes(StandardCharsets.UTF_8)), Node.of("width", "100".getBytes(StandardCharsets.UTF_8)), Node.of("height", "100".getBytes(StandardCharsets.UTF_8)))).thenApplyAsync(this::parseCollections);
    }

    private List<BusinessCollectionEntry> parseCollections(Node result) {
        return Objects.requireNonNull(result, "Cannot query business collections, missing newsletters node").findNode("collections").stream().map(entry -> entry.findNodes("collection")).flatMap(Collection::stream).map(BusinessCollectionEntry::of).toList();
    }

    public CompletableFuture<?> queryBusinessCollections(JidProvider contact) {
        return this.queryBusinessCollections(contact, 50);
    }

    public CompletableFuture<Optional<byte[]>> downloadMedia(ChatMessageInfo info) {
        Message message = info.message().content();
        if (!(message instanceof MediaMessage)) {
            throw new IllegalArgumentException("Expected media message, got: " + String.valueOf((Object)info.message().category()));
        }
        MediaMessage mediaMessage = (MediaMessage)message;
        return this.downloadMedia(mediaMessage).thenCompose(result -> {
            if (result.isPresent()) {
                return CompletableFuture.completedFuture(result);
            }
            return this.requireMediaReupload(info).thenCompose(ignored -> this.downloadMedia(mediaMessage));
        });
    }

    public CompletableFuture<Optional<byte[]>> downloadMedia(NewsletterMessageInfo info) {
        Message message = info.message().content();
        if (!(message instanceof MediaMessage)) {
            throw new IllegalArgumentException("Expected media message, got: " + String.valueOf((Object)info.message().category()));
        }
        MediaMessage mediaMessage = (MediaMessage)message;
        return this.downloadMedia(mediaMessage);
    }

    public CompletableFuture<Optional<byte[]>> downloadMedia(MediaMessage<?> mediaMessage) {
        if (!(mediaMessage instanceof ExtendedMediaMessage)) {
            return Medias.downloadAsync(mediaMessage);
        }
        ExtendedMediaMessage extendedMediaMessage = (ExtendedMediaMessage)mediaMessage;
        Optional<byte[]> decodedMedia = extendedMediaMessage.decodedMedia();
        if (decodedMedia.isPresent()) {
            return CompletableFuture.completedFuture(decodedMedia);
        }
        return Medias.downloadAsync(mediaMessage).thenApply(result -> {
            result.ifPresent(extendedMediaMessage::setDecodedMedia);
            return result;
        });
    }

    public CompletableFuture<Void> requireMediaReupload(ChatMessageInfo info) {
        Message message = info.message().content();
        if (!(message instanceof MediaMessage)) {
            throw new IllegalArgumentException("Expected media message, got: " + String.valueOf((Object)info.message().category()));
        }
        MediaMessage mediaMessage = (MediaMessage)message;
        byte[] mediaKey = (byte[])mediaMessage.mediaKey().orElseThrow(() -> new NoSuchElementException("Missing media key"));
        byte[] retryKey = Hkdf.extractAndExpand(mediaKey, "WhatsApp Media Retry Notification".getBytes(StandardCharsets.UTF_8), 32);
        byte[] retryIv = BytesHelper.random(12);
        byte[] retryIdData = info.key().id().getBytes(StandardCharsets.UTF_8);
        byte[] receipt = ServerErrorReceiptSpec.encode(new ServerErrorReceipt(info.id()));
        byte[] ciphertext = AesGcm.encrypt(retryIv, receipt, retryKey, retryIdData);
        LinkedHashMap<String, Object> rmrAttributes = Attributes.of(new Map.Entry[0]).put("jid", info.chatJid()).put("from_me", String.valueOf(info.fromMe())).put("participant", (Object)info.senderJid(), () -> !Objects.equals(info.chatJid(), info.senderJid())).toMap();
        Node node = Node.of("receipt", Map.of("id", info.key().id(), "to", this.jidOrThrowError().withoutDevice(), "type", "server-error"), Node.of("encrypt", Node.of("enc_p", ciphertext), Node.of("enc_iv", retryIv)), Node.of("rmr", rmrAttributes));
        return this.socketHandler.send(node, result -> result.hasDescription("notification")).thenAcceptAsync(result -> this.parseMediaReupload(info, mediaMessage, retryKey, retryIdData, (Node)result));
    }

    private void parseMediaReupload(ChatMessageInfo info, MediaMessage<?> mediaMessage, byte[] retryKey, byte[] retryIdData, Node node) {
        Validate.isTrue(!node.hasNode("error"), "Erroneous response from media reupload: %s", node.attributes().getInt("code"));
        Node encryptNode = node.findNode("encrypt").orElseThrow(() -> new NoSuchElementException("Missing encrypt node in media reupload"));
        byte[] mediaPayload = (byte[])encryptNode.findNode("enc_p").flatMap(Node::contentAsBytes).orElseThrow(() -> new NoSuchElementException("Missing encrypted payload node in media reupload"));
        byte[] mediaIv = (byte[])encryptNode.findNode("enc_iv").flatMap(Node::contentAsBytes).orElseThrow(() -> new NoSuchElementException("Missing encrypted iv node in media reupload"));
        byte[] mediaRetryNotificationData = AesGcm.decrypt(mediaIv, mediaPayload, retryKey, retryIdData);
        MediaRetryNotification mediaRetryNotification = MediaRetryNotificationSpec.decode(mediaRetryNotificationData);
        String directPath = mediaRetryNotification.directPath().orElseThrow(() -> new RuntimeException("Media reupload failed"));
        mediaMessage.setMediaUrl(Medias.createMediaUrl(directPath));
        mediaMessage.setMediaDirectPath(directPath);
    }

    public CompletableFuture<Node> sendNode(Node node) {
        return this.socketHandler.send(node);
    }

    public CompletableFuture<Optional<GroupMetadata>> createCommunity(String subject, String body) {
        String descriptionId = HexFormat.of().formatHex(BytesHelper.random(12));
        Node entry = Node.of("create", Map.of("subject", subject), Node.of("description", Map.of("id", descriptionId), (Object)Node.of("body", Objects.requireNonNullElse(body, "").getBytes(StandardCharsets.UTF_8))), Node.of("parent", Map.of("default_membership_approval_mode", "request_required")), Node.of("allow_non_admin_sub_group_creation"));
        return this.socketHandler.sendQuery(JidServer.GROUP.toJid(), "set", "w:g2", entry).thenApplyAsync(node -> node.findNode("group").map(this.socketHandler::parseGroupMetadata));
    }

    public CompletableFuture<Void> changeCommunitySetting(JidProvider community, CommunitySetting setting, ChatSettingPolicy policy) {
        Validate.isTrue(community.toJid().hasServer(JidServer.GROUP), "This method only accepts communities", new Object[0]);
        switch (setting) {
            default: {
                throw new MatchException(null, null);
            }
            case MODIFY_GROUPS: 
        }
        Node body = Node.of(policy == ChatSettingPolicy.ANYONE ? "allow_non_admin_sub_group_creation" : "not_allow_non_admin_sub_group_creation");
        return this.socketHandler.sendQuery(JidServer.GROUP.toJid(), "set", "w:g2", body).thenRun(() -> {});
    }

    public CompletableFuture<Whatsapp> unlinkDevices() {
        return ((CompletableFuture)this.socketHandler.sendQuery("set", "md", Node.of("remove-companion-device", Map.of("all", true, "reason", "user_initiated"))).thenRun(() -> this.store().removeLinkedCompanions())).thenApply(ignored -> this);
    }

    public CompletableFuture<Whatsapp> unlinkDevice(Jid companion) {
        Validate.isTrue(companion.hasAgent(), "Expected companion, got jid without agent: %s", companion);
        return ((CompletableFuture)this.socketHandler.sendQuery("set", "md", Node.of("remove-companion-device", Map.of("jid", companion, "reason", "user_initiated"))).thenRun(() -> this.store().removeLinkedCompanion(companion))).thenApply(ignored -> this);
    }

    public CompletableFuture<CompanionLinkResult> linkDevice(byte[] qrCode) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(qrCode);
            BufferedImageLuminanceSource luminanceSource = new BufferedImageLuminanceSource(ImageIO.read(inputStream));
            HybridBinarizer hybridBinarizer = new HybridBinarizer((LuminanceSource)luminanceSource);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)hybridBinarizer);
            QRCodeReader reader = new QRCodeReader();
            Result result = reader.decode(binaryBitmap);
            return this.linkDevice(result.getText());
        }
        catch (ChecksumException | FormatException | NotFoundException | IOException exception) {
            throw new IllegalArgumentException("Cannot read qr code", exception);
        }
    }

    public CompletableFuture<CompanionLinkResult> linkDevice(String qrCodeData) {
        Validate.isTrue(this.store().clientType() == ClientType.MOBILE, "Device linking is only available for the mobile api", new Object[0]);
        int maxDevices = this.getMaxLinkedDevices();
        if (this.store().linkedDevices().size() > maxDevices) {
            return CompletableFuture.completedFuture(CompanionLinkResult.MAX_DEVICES_ERROR);
        }
        String[] qrCodeParts = qrCodeData.split(",");
        Validate.isTrue(qrCodeParts.length >= 4, "Expected qr code to be made up of at least four parts", new Object[0]);
        String ref = qrCodeParts[0];
        byte[] publicKey = Base64.getDecoder().decode(qrCodeParts[1]);
        byte[] advIdentity = Base64.getDecoder().decode(qrCodeParts[2]);
        byte[] identityKey = Base64.getDecoder().decode(qrCodeParts[3]);
        return this.socketHandler.sendQuery("set", "w:sync:app:state", Node.of("delete_all_data")).thenComposeAsync(ignored -> this.linkDevice(advIdentity, identityKey, ref, publicKey));
    }

    private CompletableFuture<CompanionLinkResult> linkDevice(byte[] advIdentity, byte[] identityKey, String ref, byte[] publicKey) {
        DeviceIdentity deviceIdentity = new DeviceIdentityBuilder().rawId(KeyHelper.agent()).keyIndex(this.store().linkedDevices().size() + 1).timestamp(Clock.nowSeconds()).build();
        byte[] deviceIdentityBytes = DeviceIdentitySpec.encode(deviceIdentity);
        byte[] accountSignatureMessage = BytesHelper.concat(Specification.Whatsapp.ACCOUNT_SIGNATURE_HEADER, deviceIdentityBytes, advIdentity);
        byte[] accountSignature = Curve25519.sign((byte[])this.keys().identityKeyPair().privateKey(), (byte[])accountSignatureMessage, (boolean)true);
        SignedDeviceIdentity signedDeviceIdentity = new SignedDeviceIdentityBuilder().accountSignature(accountSignature).accountSignatureKey(this.keys().identityKeyPair().publicKey()).details(deviceIdentityBytes).build();
        byte[] signedDeviceIdentityBytes = SignedDeviceIdentitySpec.encode(signedDeviceIdentity);
        SignedDeviceIdentityHMAC deviceIdentityHmac = new SignedDeviceIdentityHMACBuilder().hmac(Hmac.calculateSha256(signedDeviceIdentityBytes, identityKey)).details(signedDeviceIdentityBytes).build();
        List<Integer> knownDevices = this.store().linkedDevices().stream().map(Jid::device).toList();
        KeyIndexList keyIndexList = new KeyIndexListBuilder().rawId(deviceIdentity.rawId()).timestamp(deviceIdentity.timestamp()).validIndexes(knownDevices).build();
        byte[] keyIndexListBytes = KeyIndexListSpec.encode(keyIndexList);
        byte[] deviceSignatureMessage = BytesHelper.concat(Specification.Whatsapp.DEVICE_MOBILE_SIGNATURE_HEADER, keyIndexListBytes);
        byte[] keyAccountSignature = Curve25519.sign((byte[])this.keys().identityKeyPair().privateKey(), (byte[])deviceSignatureMessage, (boolean)true);
        SignedKeyIndexList signedKeyIndexList = new SignedKeyIndexListBuilder().accountSignature(keyAccountSignature).details(keyIndexListBytes).build();
        return this.socketHandler.sendQuery("set", "md", Node.of("pair-device", Node.of("ref", ref), Node.of("pub-key", publicKey), Node.of("device-identity", SignedDeviceIdentityHMACSpec.encode(deviceIdentityHmac)), Node.of("key-index-list", Map.of("ts", deviceIdentity.timestamp()), (Object)SignedKeyIndexListSpec.encode(signedKeyIndexList)))).thenComposeAsync(result -> this.handleCompanionPairing((Node)result, deviceIdentity.keyIndex()));
    }

    private int getMaxLinkedDevices() {
        String maxDevices = this.socketHandler.store().properties().get("linked_device_max_count");
        if (maxDevices == null) {
            return 5;
        }
        try {
            return Integer.parseInt(maxDevices);
        }
        catch (NumberFormatException exception) {
            return 5;
        }
    }

    private CompletableFuture<CompanionLinkResult> handleCompanionPairing(Node result, int keyId) {
        if (result.attributes().hasValue("type", "error")) {
            CompanionLinkResult error = result.findNode("error").filter(entry -> entry.attributes().hasValue("text", "resource-limit")).map(entry -> CompanionLinkResult.MAX_DEVICES_ERROR).orElse(CompanionLinkResult.RETRY_ERROR);
            return CompletableFuture.completedFuture(error);
        }
        Jid device = result.findNode("device").flatMap(entry -> entry.attributes().getOptionalJid("jid")).orElse(null);
        if (device == null) {
            return CompletableFuture.completedFuture(CompanionLinkResult.RETRY_ERROR);
        }
        return ((CompletableFuture)this.awaitCompanionRegistration(device).thenComposeAsync(ignored -> this.socketHandler.sendQuery("get", "encrypt", Node.of("key", (Object)Node.of("user", Map.of("jid", device)))))).thenComposeAsync(encryptResult -> this.handleCompanionEncrypt((Node)encryptResult, device, keyId));
    }

    private CompletableFuture<Void> awaitCompanionRegistration(Jid device) {
        CompletableFuture future = new CompletableFuture();
        OnLinkedDevices listener = data -> {
            if (data.contains(device)) {
                future.complete(null);
            }
        };
        this.addLinkedDevicesListener(listener);
        return ((CompletableFuture)future.orTimeout(10L, TimeUnit.SECONDS).exceptionally(ignored -> null)).thenRun(() -> this.removeListener(listener));
    }

    private CompletableFuture<CompanionLinkResult> handleCompanionEncrypt(Node result, Jid companion, int keyId) {
        this.store().addLinkedDevice(companion, keyId);
        this.socketHandler.parseSessions(result);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.sendInitialSecurityMessage(companion).thenComposeAsync(ignore -> this.sendAppStateKeysMessage(companion))).thenComposeAsync(ignore -> this.sendInitialNullMessage(companion))).thenComposeAsync(ignore -> this.sendInitialStatusMessage(companion))).thenComposeAsync(ignore -> this.sendPushNamesMessage(companion))).thenComposeAsync(ignore -> this.sendInitialBootstrapMessage(companion))).thenComposeAsync(ignore -> this.sendRecentMessage(companion))).thenComposeAsync(ignored -> this.syncCompanionState(companion))).thenApplyAsync(ignored -> CompanionLinkResult.SUCCESS);
    }

    private CompletableFuture<Void> syncCompanionState(Jid companion) {
        PatchRequest criticalUnblockLowRequest = this.createCriticalUnblockLowRequest();
        PatchRequest criticalBlockRequest = this.createCriticalBlockRequest();
        return this.socketHandler.pushPatches(companion, List.of(criticalBlockRequest, criticalUnblockLowRequest)).thenComposeAsync(ignored -> {
            PatchRequest regularLowRequests = this.createRegularLowRequests();
            PatchRequest regularRequests = this.createRegularRequests();
            return this.socketHandler.pushPatches(companion, List.of(regularLowRequests, regularRequests));
        });
    }

    private PatchRequest createRegularRequests() {
        return new PatchRequest(PatchType.REGULAR, List.of());
    }

    private PatchRequest createRegularLowRequests() {
        PatchRequest.PatchEntry timeFormatEntry = this.createTimeFormatEntry();
        PrimaryVersionAction primaryVersion = new PrimaryVersionAction(this.store().version().toString());
        PatchRequest.PatchEntry sessionVersionEntry = this.createPrimaryVersionEntry(primaryVersion, "session@s.whatsapp.net");
        PatchRequest.PatchEntry keepVersionEntry = this.createPrimaryVersionEntry(primaryVersion, "current@s.whatsapp.net");
        PatchRequest.PatchEntry nuxEntry = this.createNuxRequest();
        PatchRequest.PatchEntry androidEntry = this.createAndroidEntry();
        List<PatchRequest.PatchEntry> entries = Stream.of(timeFormatEntry, sessionVersionEntry, keepVersionEntry, nuxEntry, androidEntry).filter(Objects::nonNull).toList();
        return new PatchRequest(PatchType.REGULAR_LOW, entries);
    }

    private PatchRequest createCriticalBlockRequest() {
        PatchRequest.PatchEntry localeEntry = this.createLocaleEntry();
        PatchRequest.PatchEntry pushNameEntry = this.createPushNameEntry();
        return new PatchRequest(PatchType.CRITICAL_BLOCK, List.of(localeEntry, pushNameEntry));
    }

    private PatchRequest createCriticalUnblockLowRequest() {
        List<PatchRequest.PatchEntry> criticalUnblockLow = this.createContactEntries();
        return new PatchRequest(PatchType.CRITICAL_UNBLOCK_LOW, criticalUnblockLow);
    }

    private List<PatchRequest.PatchEntry> createContactEntries() {
        return this.store().contacts().stream().filter(entry -> entry.shortName().isPresent() || entry.fullName().isPresent()).map(this::createContactRequestEntry).collect(Collectors.toList());
    }

    private PatchRequest.PatchEntry createPushNameEntry() {
        PushNameSettings pushNameSetting = new PushNameSettings(this.store().name());
        return PatchRequest.PatchEntry.of(ActionValueSync.of(pushNameSetting), RecordSync.Operation.SET, new String[0]);
    }

    private PatchRequest.PatchEntry createLocaleEntry() {
        LocaleSettings localeSetting = new LocaleSettings(this.store().locale().toString());
        return PatchRequest.PatchEntry.of(ActionValueSync.of(localeSetting), RecordSync.Operation.SET, new String[0]);
    }

    private PatchRequest.PatchEntry createAndroidEntry() {
        if (!this.store().device().platform().isAndroid()) {
            return null;
        }
        AndroidUnsupportedActions action = new AndroidUnsupportedActions(true);
        return PatchRequest.PatchEntry.of(ActionValueSync.of(action), RecordSync.Operation.SET, new String[0]);
    }

    private PatchRequest.PatchEntry createNuxRequest() {
        NuxAction nuxAction = new NuxAction(true);
        ActionValueSync timeFormatSync = ActionValueSync.of(nuxAction);
        return PatchRequest.PatchEntry.of(timeFormatSync, RecordSync.Operation.SET, "keep@s.whatsapp.net");
    }

    private PatchRequest.PatchEntry createPrimaryVersionEntry(PrimaryVersionAction primaryVersion, String to) {
        ActionValueSync timeFormatSync = ActionValueSync.of(primaryVersion);
        return PatchRequest.PatchEntry.of(timeFormatSync, RecordSync.Operation.SET, to);
    }

    private PatchRequest.PatchEntry createTimeFormatEntry() {
        TimeFormatAction timeFormatAction = new TimeFormatAction(this.store().twentyFourHourFormat());
        ActionValueSync timeFormatSync = ActionValueSync.of(timeFormatAction);
        return PatchRequest.PatchEntry.of(timeFormatSync, RecordSync.Operation.SET, new String[0]);
    }

    private PatchRequest.PatchEntry createContactRequestEntry(Contact contact) {
        ContactAction action = new ContactAction(null, contact.shortName(), contact.fullName());
        ActionValueSync sync = ActionValueSync.of(action);
        return PatchRequest.PatchEntry.of(sync, RecordSync.Operation.SET, contact.jid().toString());
    }

    private CompletableFuture<Void> sendRecentMessage(Jid jid) {
        HistorySync pushNames = new HistorySyncBuilder().conversations(List.of()).syncType(HistorySync.Type.RECENT).build();
        return this.sendHistoryProtocolMessage(jid, pushNames, HistorySync.Type.PUSH_NAME);
    }

    private CompletableFuture<Void> sendPushNamesMessage(Jid jid) {
        List<PushName> pushNamesData = this.store().contacts().stream().filter(entry -> entry.chosenName().isPresent()).map(entry -> new PushName(entry.jid().toString(), entry.chosenName())).toList();
        HistorySync pushNames = new HistorySyncBuilder().pushNames(pushNamesData).syncType(HistorySync.Type.PUSH_NAME).build();
        return this.sendHistoryProtocolMessage(jid, pushNames, HistorySync.Type.PUSH_NAME);
    }

    private CompletableFuture<Void> sendInitialStatusMessage(Jid jid) {
        HistorySync initialStatus = new HistorySyncBuilder().statusV3Messages(new ArrayList<ChatMessageInfo>(this.store().status())).syncType(HistorySync.Type.INITIAL_STATUS_V3).build();
        return this.sendHistoryProtocolMessage(jid, initialStatus, HistorySync.Type.INITIAL_STATUS_V3);
    }

    private CompletableFuture<Void> sendInitialBootstrapMessage(Jid jid) {
        List<Chat> chats = this.store().chats().stream().toList();
        HistorySync initialBootstrap = new HistorySyncBuilder().conversations(chats).syncType(HistorySync.Type.INITIAL_BOOTSTRAP).build();
        return this.sendHistoryProtocolMessage(jid, initialBootstrap, HistorySync.Type.INITIAL_BOOTSTRAP);
    }

    private CompletableFuture<Void> sendInitialNullMessage(Jid jid) {
        List<GroupPastParticipants> pastParticipants = this.store().chats().stream().map(this::getPastParticipants).filter(Objects::nonNull).toList();
        HistorySync initialBootstrap = new HistorySyncBuilder().syncType(HistorySync.Type.NON_BLOCKING_DATA).pastParticipants(pastParticipants).build();
        return this.sendHistoryProtocolMessage(jid, initialBootstrap, null);
    }

    private GroupPastParticipants getPastParticipants(Chat chat) {
        if (chat.pastParticipants().isEmpty()) {
            return null;
        }
        return new GroupPastParticipantsBuilder().groupJid(chat.jid()).pastParticipants(new ArrayList<GroupPastParticipant>(chat.pastParticipants())).build();
    }

    private CompletableFuture<Void> sendAppStateKeysMessage(Jid companion) {
        List<AppStateSyncKey> preKeys = IntStream.range(0, 10).mapToObj(index -> this.createAppKey(companion, index)).toList();
        this.keys().addAppKeys(companion, preKeys);
        AppStateSyncKeyShare appStateSyncKeyShare = new AppStateSyncKeyShareBuilder().keys(preKeys).build();
        ProtocolMessage result = new ProtocolMessageBuilder().protocolType(ProtocolMessage.Type.APP_STATE_SYNC_KEY_SHARE).appStateSyncKeyShare(appStateSyncKeyShare).build();
        return this.socketHandler.sendPeerMessage(companion, result);
    }

    private AppStateSyncKey createAppKey(Jid jid, int index) {
        return new AppStateSyncKeyBuilder().keyId(new AppStateSyncKeyId(KeyHelper.appKeyId())).keyData(this.createAppKeyData(jid, index)).build();
    }

    private AppStateSyncKeyData createAppKeyData(Jid jid, int index) {
        return new AppStateSyncKeyDataBuilder().keyData(SignalKeyPair.random().publicKey()).fingerprint(this.createAppKeyFingerprint(jid, index)).timestamp(Clock.nowMilliseconds()).build();
    }

    private AppStateSyncKeyFingerprint createAppKeyFingerprint(Jid jid, int index) {
        return new AppStateSyncKeyFingerprintBuilder().rawId(KeyHelper.senderKeyId()).currentIndex(index).deviceIndexes(new ArrayList<Integer>(this.store().linkedDevicesKeys().values())).build();
    }

    private CompletableFuture<Void> sendInitialSecurityMessage(Jid jid) {
        ProtocolMessage protocolMessage = new ProtocolMessageBuilder().protocolType(ProtocolMessage.Type.INITIAL_SECURITY_NOTIFICATION_SETTING_SYNC).initialSecurityNotificationSettingSync(new InitialSecurityNotificationSettingSync(true)).build();
        return this.socketHandler.sendPeerMessage(jid, protocolMessage);
    }

    private CompletableFuture<Void> sendHistoryProtocolMessage(Jid jid, HistorySync historySync, HistorySync.Type type) {
        byte[] syncBytes = HistorySyncSpec.encode(historySync);
        return ((CompletableFuture)Medias.upload(syncBytes, AttachmentType.HISTORY_SYNC, this.store().mediaConnection()).thenApplyAsync(upload -> this.createHistoryProtocolMessage((MediaFile)upload, type))).thenComposeAsync(result -> this.socketHandler.sendPeerMessage(jid, (ProtocolMessage)result));
    }

    private ProtocolMessage createHistoryProtocolMessage(MediaFile upload, HistorySync.Type type) {
        HistorySyncNotification notification = new HistorySyncNotificationBuilder().mediaSha256(upload.fileSha256()).mediaEncryptedSha256(upload.fileEncSha256()).mediaKey(upload.mediaKey()).mediaDirectPath(upload.directPath()).mediaSize(upload.fileLength()).syncType(type).build();
        return new ProtocolMessageBuilder().protocolType(ProtocolMessage.Type.HISTORY_SYNC_NOTIFICATION).historySyncNotification(notification).build();
    }

    public CompletableFuture<Optional<BusinessVerifiedNameCertificate>> queryBusinessCertificate(JidProvider provider) {
        return this.socketHandler.sendQuery("get", "w:biz", Node.of("verified_name", Map.of("jid", provider.toJid()))).thenApplyAsync(this::parseCertificate);
    }

    private Optional<BusinessVerifiedNameCertificate> parseCertificate(Node result) {
        return result.findNode("verified_name").flatMap(Node::contentAsBytes).map(BusinessVerifiedNameCertificateSpec::decode);
    }

    public CompletableFuture<?> enable2fa(String code) {
        return this.set2fa(code, null);
    }

    public CompletableFuture<Boolean> enable2fa(String code, String email) {
        return this.set2fa(code, email);
    }

    public CompletableFuture<Boolean> disable2fa() {
        return this.set2fa(null, null);
    }

    private CompletableFuture<Boolean> set2fa(String code, String email) {
        Validate.isTrue(this.store().clientType() == ClientType.MOBILE, "2FA is only available for the mobile api", new Object[0]);
        Validate.isTrue(code == null || code.matches("^[0-9]*$") && code.length() == 6, "Invalid 2fa code: expected a numeric six digits string", new Object[0]);
        Validate.isTrue(email == null || this.isValidEmail(email), "Invalid email: %s", email);
        ArrayList<Node> body = new ArrayList<Node>();
        body.add(Node.of("code", Objects.requireNonNullElse(code, "").getBytes(StandardCharsets.UTF_8)));
        if (code != null && email != null) {
            body.add(Node.of("email", email.getBytes(StandardCharsets.UTF_8)));
        }
        return this.socketHandler.sendQuery("set", "urn:xmpp:whatsapp:account", Node.of("2fa", body)).thenApplyAsync(result -> !result.hasNode("error"));
    }

    public CompletableFuture<Call> startCall(JidProvider contact) {
        Validate.isTrue(this.store().clientType() == ClientType.MOBILE, "Calling is only available for the mobile api", new Object[0]);
        return this.socketHandler.querySessions(contact.toJid()).thenComposeAsync(ignored -> this.sendCallMessage(contact));
    }

    private CompletableFuture<Call> sendCallMessage(JidProvider provider) {
        String callId = ChatMessageKey.randomId();
        Node audioStream = Node.of("audio", Map.of("rate", 8000, "enc", "opus"));
        Node audioStreamTwo = Node.of("audio", Map.of("rate", 16000, "enc", "opus"));
        Node net = Node.of("net", Map.of("medium", 3));
        Node encopt = Node.of("encopt", Map.of("keygen", 2));
        Node enc = this.createCallNode(provider);
        Node capability = Node.of("capability", Map.of("ver", 1), (Object)HexFormat.of().parseHex("0104ff09c4fa"));
        String callCreator = "%s:0@s.whatsapp.net".formatted(this.jidOrThrowError().user());
        Node offer = Node.of("offer", Map.of("call-creator", callCreator, "call-id", callId), audioStream, audioStreamTwo, net, capability, encopt, enc);
        return this.socketHandler.send(Node.of("call", Map.of("to", provider.toJid()), (Object)offer)).thenApply(result -> this.onCallSent(provider, callId, (Node)result));
    }

    private Call onCallSent(JidProvider provider, String callId, Node result) {
        Call call = new Call(provider.toJid(), this.jidOrThrowError(), callId, Clock.nowSeconds(), false, CallStatus.RINGING, false);
        this.store().addCall(call);
        this.socketHandler.onCall(call);
        return call;
    }

    private Node createCallNode(JidProvider provider) {
        CallMessage call = new CallMessageBuilder().key(SignalKeyPair.random().publicKey()).build();
        MessageContainer message = MessageContainer.of(call);
        SessionCipher cipher = new SessionCipher(provider.toJid().toSignalAddress(), this.keys());
        byte[] encodedMessage = BytesHelper.messageToBytes(message);
        CipheredMessageResult cipheredMessage = cipher.encrypt(encodedMessage);
        return Node.of("enc", Map.of("v", 2, "type", cipheredMessage.type()), (Object)cipheredMessage.message());
    }

    public CompletableFuture<Boolean> stopCall(String callId) {
        Validate.isTrue(this.store().clientType() == ClientType.MOBILE, "Calling is only available for the mobile api", new Object[0]);
        return this.store().findCallById(callId).map(this::stopCall).orElseGet(() -> CompletableFuture.completedFuture(false));
    }

    public CompletableFuture<Boolean> stopCall(Call call) {
        Validate.isTrue(this.store().clientType() == ClientType.MOBILE, "Calling is only available for the mobile api", new Object[0]);
        String callCreator = "%s.%s:%s@s.whatsapp.net".formatted(call.caller().user(), call.caller().device(), call.caller().device());
        if (Objects.equals(call.caller().user(), this.jidOrThrowError().user())) {
            Node rejectNode = Node.of("terminate", Map.of("reason", "timeout", "call-id", call.id(), "call-creator", callCreator));
            Node body = Node.of("call", Map.of("to", call.chat()), (Object)rejectNode);
            return this.socketHandler.send(body).thenApplyAsync(result -> !result.hasNode("error"));
        }
        Node rejectNode = Node.of("reject", Map.of("call-id", call.id(), "call-creator", callCreator, "count", 0));
        Node body = Node.of("call", Map.of("from", this.socketHandler.store().jid(), "to", call.caller()), (Object)rejectNode);
        return this.socketHandler.send(body).thenApplyAsync(result -> !result.hasNode("error"));
    }

    public CompletableFuture<Optional<RecommendedNewslettersResponse>> queryRecommendedNewsletters(String countryCode) {
        return this.queryRecommendedNewsletters(countryCode, 50);
    }

    public CompletableFuture<Optional<RecommendedNewslettersResponse>> queryRecommendedNewsletters(String countryCode, int limit) {
        RecommendedNewslettersRequest.Filters filters = new RecommendedNewslettersRequest.Filters(List.of(countryCode));
        RecommendedNewslettersRequest.Input input = new RecommendedNewslettersRequest.Input("RECOMMENDED", filters, limit);
        RecommendedNewslettersRequest.Variable variable = new RecommendedNewslettersRequest.Variable(input);
        RecommendedNewslettersRequest query = new RecommendedNewslettersRequest(variable);
        return this.socketHandler.sendQuery("get", "w:mex", Node.of("query", Map.of("query_id", "6190824427689257"), (Object)Json.writeValueAsBytes(query))).thenApplyAsync(this::parseRecommendedNewsletters);
    }

    private Optional<RecommendedNewslettersResponse> parseRecommendedNewsletters(Node response) {
        return response.findNode("result").flatMap(Node::contentAsString).flatMap(RecommendedNewslettersResponse::ofJson);
    }

    public CompletableFuture<Void> queryNewsletterMessages(JidProvider newsletterJid, int count) {
        return this.socketHandler.queryNewsletterMessages(newsletterJid, count);
    }

    public CompletableFuture<OptionalLong> subscribeToNewsletterReactions(JidProvider channel) {
        return this.socketHandler.subscribeToNewsletterReactions(channel);
    }

    public CompletableFuture<Optional<Newsletter>> createNewsletter(String name) {
        return this.createNewsletter(name, null, null);
    }

    public CompletableFuture<Optional<Newsletter>> createNewsletter(String name, String description) {
        return this.createNewsletter(name, description, null);
    }

    public CompletableFuture<Optional<Newsletter>> createNewsletter(String name, String description, byte[] picture) {
        CreateNewsletterRequest.NewsletterInput input = new CreateNewsletterRequest.NewsletterInput(name, description, picture != null ? Base64.getEncoder().encodeToString(picture) : null);
        CreateNewsletterRequest.Variable variable = new CreateNewsletterRequest.Variable(input);
        CreateNewsletterRequest request = new CreateNewsletterRequest(variable);
        return ((CompletableFuture)((CompletableFuture)this.socketHandler.sendQuery("set", "tos", Node.of("notice", Map.of("stage", 5, "id", ChatMessageKey.randomId()))).thenComposeAsync(ignored -> this.socketHandler.sendQuery("get", "w:mex", Node.of("query", Map.of("query_id", "6234210096708695"), (Object)Json.writeValueAsBytes(request))))).thenApplyAsync(this::parseNewsletterCreation)).thenComposeAsync(this::onNewsletterCreation);
    }

    private Optional<Newsletter> parseNewsletterCreation(Node response) {
        return response.findNode("result").flatMap(Node::contentAsString).flatMap(NewsletterResponse::ofJson).map(NewsletterResponse::newsletter);
    }

    private CompletableFuture<Optional<Newsletter>> onNewsletterCreation(Optional<Newsletter> result) {
        if (result.isEmpty()) {
            return CompletableFuture.completedFuture(result);
        }
        return this.subscribeToNewsletterReactions(result.get().jid()).thenApply(ignored -> result);
    }

    public CompletableFuture<Void> changeNewsletterDescription(JidProvider newsletter, String description) {
        String safeDescription = Objects.requireNonNullElse(description, "");
        UpdateNewsletterRequest.UpdatePayload payload = new UpdateNewsletterRequest.UpdatePayload(safeDescription);
        UpdateNewsletterRequest.Variable body = new UpdateNewsletterRequest.Variable(newsletter.toJid(), payload);
        UpdateNewsletterRequest request = new UpdateNewsletterRequest(body);
        return this.socketHandler.sendQuery("get", "w:mex", Node.of("query", Map.of("query_id", "7150902998257522"), (Object)Json.writeValueAsBytes(request))).thenRun(() -> {});
    }

    public CompletableFuture<Void> joinNewsletter(JidProvider newsletter) {
        JoinNewsletterRequest.Variable body = new JoinNewsletterRequest.Variable(newsletter.toJid());
        JoinNewsletterRequest request = new JoinNewsletterRequest(body);
        return this.socketHandler.sendQuery("get", "w:mex", Node.of("query", Map.of("query_id", "9926858900719341"), (Object)Json.writeValueAsBytes(request))).thenRun(() -> {});
    }

    public CompletableFuture<Void> leaveNewsletter(JidProvider newsletter) {
        LeaveNewsletterRequest.Variable body = new LeaveNewsletterRequest.Variable(newsletter.toJid());
        LeaveNewsletterRequest request = new LeaveNewsletterRequest(body);
        return this.socketHandler.sendQuery("get", "w:mex", Node.of("query", Map.of("query_id", "6392786840836363"), (Object)Json.writeValueAsBytes(request))).thenRun(() -> {});
    }

    public CompletableFuture<Long> queryNewsletterSubscribers(JidProvider newsletterJid) {
        NewsletterViewerRole newsletterRole = this.store().findNewsletterByJid(newsletterJid).flatMap(Newsletter::viewerMetadata).map(NewsletterViewerMetadata::role).orElse(NewsletterViewerRole.GUEST);
        NewsletterSubscribersRequest.Input input = new NewsletterSubscribersRequest.Input(newsletterJid.toJid(), "JID", newsletterRole.name());
        NewsletterSubscribersRequest.Variable body = new NewsletterSubscribersRequest.Variable(input);
        NewsletterSubscribersRequest request = new NewsletterSubscribersRequest(body);
        return this.socketHandler.sendQuery("get", "w:mex", Node.of("query", Map.of("query_id", "7272540469429201"), (Object)Json.writeValueAsBytes(request))).thenApply(this::parseNewsletterSubscribers);
    }

    private long parseNewsletterSubscribers(Node response) {
        return response.findNode("result").flatMap(Node::contentAsString).flatMap(NewsletterSubscribersResponse::ofJson).map(NewsletterSubscribersResponse::subscribersCount).orElse(0L);
    }

    public Whatsapp addListener(Listener listener) {
        this.store().addListener(listener);
        return this;
    }

    public Whatsapp removeListener(Listener listener) {
        this.store().removeListener(listener);
        return this;
    }

    public Whatsapp addActionListener(OnAction onAction) {
        return this.addListener(onAction);
    }

    public Whatsapp addChatMessagesSyncListener(OnChatMessagesSync onChatRecentMessages) {
        return this.addListener(onChatRecentMessages);
    }

    public Whatsapp addChatsListener(OnChats onChats) {
        return this.addListener(onChats);
    }

    public Whatsapp addChatsListener(OnWhatsappChats onChats) {
        return this.addListener(onChats);
    }

    public Whatsapp addNewslettersListener(OnNewsletters onNewsletters) {
        return this.addListener(onNewsletters);
    }

    public Whatsapp addNewslettersListener(OnWhatsappNewsletters onNewsletters) {
        return this.addListener(onNewsletters);
    }

    public Whatsapp addContactPresenceListener(OnContactPresence onContactPresence) {
        return this.addListener(onContactPresence);
    }

    public Whatsapp addContactsListener(OnContacts onContacts) {
        return this.addListener(onContacts);
    }

    public Whatsapp addMessageStatusListener(OnMessageStatus onAnyMessageStatus) {
        return this.addListener(onAnyMessageStatus);
    }

    public Whatsapp addDisconnectedListener(OnDisconnected onDisconnected) {
        return this.addListener(onDisconnected);
    }

    public Whatsapp addFeaturesListener(OnFeatures onFeatures) {
        return this.addListener(onFeatures);
    }

    public Whatsapp addLoggedInListener(OnLoggedIn onLoggedIn) {
        return this.addListener(onLoggedIn);
    }

    public Whatsapp addMessageDeletedListener(OnMessageDeleted onMessageDeleted) {
        return this.addListener(onMessageDeleted);
    }

    public Whatsapp addMetadataListener(OnMetadata onMetadata) {
        return this.addListener(onMetadata);
    }

    public Whatsapp addNewContactListener(OnNewContact onNewContact) {
        return this.addListener(onNewContact);
    }

    public Whatsapp addNewChatMessageListener(OnNewMessage onNewMessage) {
        return this.addListener(onNewMessage);
    }

    public Whatsapp addNewStatusListener(OnNewStatus onNewMediaStatus) {
        return this.addListener(onNewMediaStatus);
    }

    public Whatsapp addNodeReceivedListener(OnNodeReceived onNodeReceived) {
        return this.addListener(onNodeReceived);
    }

    public Whatsapp addNodeSentListener(OnNodeSent onNodeSent) {
        return this.addListener(onNodeSent);
    }

    public Whatsapp addSettingListener(OnSetting onSetting) {
        return this.addListener(onSetting);
    }

    public Whatsapp addMediaStatusListener(OnStatus onMediaStatus) {
        return this.addListener(onMediaStatus);
    }

    public Whatsapp addSocketEventListener(OnSocketEvent onSocketEvent) {
        return this.addListener(onSocketEvent);
    }

    public Whatsapp addActionListener(OnWhatsappAction onAction) {
        return this.addListener(onAction);
    }

    public Whatsapp addHistorySyncProgressListener(OnHistorySyncProgress onSyncProgress) {
        return this.addListener(onSyncProgress);
    }

    public Whatsapp addChatMessagesSyncListener(OnWhatsappChatMessagesSync onChatRecentMessages) {
        return this.addListener(onChatRecentMessages);
    }

    public Whatsapp addContactPresenceListener(OnWhatsappContactPresence onContactPresence) {
        return this.addListener(onContactPresence);
    }

    public Whatsapp addContactsListener(OnWhatsappContacts onContacts) {
        return this.addListener(onContacts);
    }

    public Whatsapp addMessageStatusListener(OnWhatsappMessageStatus onMessageStatus) {
        return this.addListener(onMessageStatus);
    }

    public Whatsapp addDisconnectedListener(OnWhatsappDisconnected onDisconnected) {
        return this.addListener(onDisconnected);
    }

    public Whatsapp addFeaturesListener(OnWhatsappFeatures onFeatures) {
        return this.addListener(onFeatures);
    }

    public Whatsapp addLoggedInListener(OnWhatsappLoggedIn onLoggedIn) {
        return this.addListener(onLoggedIn);
    }

    public Whatsapp addMessageDeletedListener(OnWhatsappMessageDeleted onMessageDeleted) {
        return this.addListener(onMessageDeleted);
    }

    public Whatsapp addMetadataListener(OnWhatsappMetadata onMetadata) {
        return this.addListener(onMetadata);
    }

    public Whatsapp addNewChatMessageListener(OnWhatsappNewMessage onNewMessage) {
        return this.addListener(onNewMessage);
    }

    public Whatsapp addNewStatusListener(OnWhatsappNewStatus onNewStatus) {
        return this.addListener(onNewStatus);
    }

    public Whatsapp addNodeReceivedListener(OnWhatsappNodeReceived onNodeReceived) {
        return this.addListener(onNodeReceived);
    }

    public Whatsapp addNodeSentListener(OnWhatsappNodeSent onNodeSent) {
        return this.addListener(onNodeSent);
    }

    public Whatsapp addSettingListener(OnWhatsappSetting onSetting) {
        return this.addListener(onSetting);
    }

    public Whatsapp addMediaStatusListener(OnWhatsappMediaStatus onStatus) {
        return this.addListener(onStatus);
    }

    public Whatsapp addSocketEventListener(OnWhatsappSocketEvent onSocketEvent) {
        return this.addListener(onSocketEvent);
    }

    public Whatsapp addHistorySyncProgressListener(OnWhatsappHistorySyncProgress onSyncProgress) {
        return this.addListener(onSyncProgress);
    }

    public Whatsapp addMessageReplyListener(OnWhatsappMessageReply onMessageReply) {
        return this.addListener(onMessageReply);
    }

    public Whatsapp addMessageReplyListener(ChatMessageInfo info, OnMessageReply onMessageReply) {
        return this.addMessageReplyListener(info.id(), onMessageReply);
    }

    public Whatsapp addMessageReplyListener(OnMessageReply onMessageReply) {
        return this.addListener(onMessageReply);
    }

    public Whatsapp addMessageReplyListener(ChatMessageInfo info, OnWhatsappMessageReply onMessageReply) {
        return this.addMessageReplyListener(info.id(), onMessageReply);
    }

    public Whatsapp addMessageReplyListener(String id, OnMessageReply onMessageReply) {
        return this.addMessageReplyListener((ChatMessageInfo info, QuotedMessageInfo quoted) -> {
            if (!info.id().equals(id)) {
                return;
            }
            onMessageReply.onMessageReply(info, quoted);
        });
    }

    public Whatsapp addMessageReplyListener(String id, OnWhatsappMessageReply onMessageReply) {
        return this.addMessageReplyListener((Whatsapp whatsapp, ChatMessageInfo info, QuotedMessageInfo quoted) -> {
            if (!info.id().equals(id)) {
                return;
            }
            onMessageReply.onMessageReply(whatsapp, info, quoted);
        });
    }

    public Whatsapp addNameChangedListener(OnUserNameChanged onUserNameChanged) {
        return this.addListener(onUserNameChanged);
    }

    public Whatsapp addNameChangedListener(OnWhatsappNameChanged onNameChange) {
        return this.addListener(onNameChange);
    }

    public Whatsapp addAboutChangedListener(OnUserAboutChanged onUserAboutChanged) {
        return this.addListener(onUserAboutChanged);
    }

    public Whatsapp addAboutChangedListener(OnWhatsappAboutChanged onUserStatusChange) {
        return this.addListener(onUserStatusChange);
    }

    public Whatsapp addUserPictureChangedListener(OnProfilePictureChanged onProfilePictureChanged) {
        return this.addListener(onProfilePictureChanged);
    }

    public Whatsapp addUserPictureChangedListener(OnWhatsappProfilePictureChanged onUserPictureChange) {
        return this.addListener(onUserPictureChange);
    }

    public Whatsapp addContactPictureChangedListener(OnContactPictureChanged onContactPictureChanged) {
        return this.addListener(onContactPictureChanged);
    }

    public Whatsapp addContactPictureChangedListener(OnWhatsappContactPictureChanged onProfilePictureChange) {
        return this.addListener(onProfilePictureChange);
    }

    public Whatsapp addGroupPictureChangedListener(OnGroupPictureChange onGroupPictureChange) {
        return this.addListener(onGroupPictureChange);
    }

    public Whatsapp addGroupPictureChangedListener(OnWhatsappGroupPictureChange onGroupPictureChange) {
        return this.addListener(onGroupPictureChange);
    }

    public Whatsapp addContactBlockedListener(OnContactBlocked onContactBlocked) {
        return this.addListener(onContactBlocked);
    }

    public Whatsapp addContactBlockedListener(OnWhatsappContactBlocked onContactBlocked) {
        return this.addListener(onContactBlocked);
    }

    public Whatsapp addPrivacySettingChangedListener(OnPrivacySettingChanged onPrivacySettingChanged) {
        return this.addListener(onPrivacySettingChanged);
    }

    public Whatsapp addPrivacySettingChangedListener(OnWhatsappPrivacySettingChanged onWhatsappPrivacySettingChanged) {
        return this.addListener(onWhatsappPrivacySettingChanged);
    }

    public Whatsapp addLinkedDevicesListener(OnLinkedDevices onLinkedDevices) {
        return this.addListener(onLinkedDevices);
    }

    public Whatsapp addLinkedDevicesListener(OnWhatsappLinkedDevices onWhatsappLinkedDevices) {
        return this.addListener(onWhatsappLinkedDevices);
    }

    public Whatsapp addRegistrationCodeListener(OnRegistrationCode onRegistrationCode) {
        return this.addListener(onRegistrationCode);
    }

    public Whatsapp addRegistrationCodeListener(OnWhatsappRegistrationCode onWhatsappRegistrationCode) {
        return this.addListener(onWhatsappRegistrationCode);
    }

    public Whatsapp addCallListener(OnCall onCall) {
        return this.addListener(onCall);
    }

    public Whatsapp addCallListener(OnWhatsappCall onWhatsappCall) {
        return this.addListener(onWhatsappCall);
    }

    private Jid jidOrThrowError() {
        return this.store().jid().orElseThrow(() -> new IllegalStateException("The session isn't connected"));
    }

    public Whatsapp setResponse(RegistrationResponse response) {
        this.response = response;
        return this;
    }

    public RegistrationResponse getResponse() {
        return this.response;
    }
}

