/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.binary;

import it.auties.whatsapp.binary.BinaryTag;
import it.auties.whatsapp.binary.BinaryTokens;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidServer;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Validate;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BinaryDecoder
implements AutoCloseable {
    private final DataInputStream dataInputStream;
    private boolean closed;

    public BinaryDecoder(byte[] buffer) {
        int token = buffer[0] & 2;
        this.dataInputStream = token == 0 ? new DataInputStream(new ByteArrayInputStream(buffer, 1, buffer.length - 1)) : new DataInputStream(new ByteArrayInputStream(BytesHelper.decompress(buffer, 1, buffer.length - 1)));
    }

    public Node decode() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("The encoder is closed");
        }
        int token = this.dataInputStream.readUnsignedByte();
        int size = this.readSize(token);
        Validate.isTrue(size != 0, "Cannot decode node with empty body", new Object[0]);
        String description = this.readString();
        Map<String, Object> attrs = this.readAttributes(size);
        return size % 2 != 0 ? Node.of(description, attrs) : Node.of(description, attrs, this.read(false));
    }

    private String readString() throws IOException {
        Object read = this.read(true);
        if (read instanceof String) {
            String string = (String)read;
            return string;
        }
        throw new IllegalArgumentException("Strict decoding failed: expected string, got %s with type %s".formatted(read, read == null ? null : read.getClass().getName()));
    }

    private List<Node> readList(int size) throws IOException {
        ArrayList<Node> results = new ArrayList<Node>();
        for (int index = 0; index < size; ++index) {
            results.add(this.decode());
        }
        return results;
    }

    private String readString(List<Character> permitted, int start, int end) throws IOException {
        char[] string = new char[2 * end - start];
        for (int index = 0; index < string.length - 1; index += 2) {
            this.readChar(permitted, string, index);
        }
        if (start != 0) {
            string[string.length - 1] = permitted.get(this.dataInputStream.readUnsignedByte() >>> 4).charValue();
        }
        return String.valueOf(string);
    }

    private void readChar(List<Character> permitted, char[] string, int index) throws IOException {
        int token = this.dataInputStream.readUnsignedByte();
        string[index] = permitted.get(token >>> 4).charValue();
        string[index + 1] = permitted.get(0xF & token).charValue();
    }

    private Object read(boolean parseBytes) throws IOException {
        int tag = this.dataInputStream.readUnsignedByte();
        return switch (BinaryTag.of(tag)) {
            case BinaryTag.LIST_EMPTY -> null;
            case BinaryTag.COMPANION_JID -> this.readCompanionJid();
            case BinaryTag.LIST_8 -> this.readList(this.dataInputStream.readUnsignedByte());
            case BinaryTag.LIST_16 -> this.readList(this.dataInputStream.readUnsignedShort());
            case BinaryTag.JID_PAIR -> this.readJidPair();
            case BinaryTag.HEX_8 -> this.readHexString();
            case BinaryTag.BINARY_8 -> this.readString(this.dataInputStream.readUnsignedByte(), parseBytes);
            case BinaryTag.BINARY_20 -> this.readString(this.readString20Length(), parseBytes);
            case BinaryTag.BINARY_32 -> this.readString(this.dataInputStream.readUnsignedShort(), parseBytes);
            case BinaryTag.NIBBLE_8 -> this.readNibble();
            default -> this.readStringFromToken(tag);
        };
    }

    private int readString20Length() throws IOException {
        return ((0xF & this.dataInputStream.readUnsignedByte()) << 16) + (this.dataInputStream.readUnsignedByte() << 8) + this.dataInputStream.readUnsignedByte();
    }

    private String readStringFromToken(int token) throws IOException {
        if (token < BinaryTag.DICTIONARY_0.data() || token > BinaryTag.DICTIONARY_3.data()) {
            return BinaryTokens.SINGLE_BYTE.get(token - 1);
        }
        int delta = BinaryTokens.DOUBLE_BYTE.size() / 4 * (token - BinaryTag.DICTIONARY_0.data());
        return BinaryTokens.DOUBLE_BYTE.get(this.dataInputStream.readUnsignedByte() + delta);
    }

    private String readNibble() throws IOException {
        int number = this.dataInputStream.readUnsignedByte();
        return this.readString(BinaryTokens.NUMBERS, number >>> 7, 0x7F & number);
    }

    private Object readString(int size, boolean parseBytes) throws IOException {
        Object object;
        byte[] data = new byte[size];
        this.dataInputStream.readFully(data);
        if (parseBytes) {
            String string;
            object = string;
            string = new String(data, StandardCharsets.UTF_8);
        } else {
            object = data;
        }
        return object;
    }

    private String readHexString() throws IOException {
        int number = this.dataInputStream.readUnsignedByte();
        return this.readString(BinaryTokens.HEX, number >>> 7, 0x7F & number);
    }

    private Jid readJidPair() throws IOException {
        Object object = this.read(true);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class}, (Object)object, n)) {
            case 0 -> {
                String encoded = (String)object;
                yield Jid.of(encoded, JidServer.of(this.readString()));
            }
            case -1 -> Jid.ofServer(JidServer.of(this.readString()));
            default -> throw new RuntimeException("Invalid jid type");
        };
    }

    private Jid readCompanionJid() throws IOException {
        int agent = this.dataInputStream.readUnsignedByte();
        int device = this.dataInputStream.readUnsignedByte();
        String user = this.readString();
        return new Jid(user, JidServer.WHATSAPP, device == 0 ? null : Integer.valueOf(device), agent == 0 ? null : Integer.valueOf(agent));
    }

    private int readSize(int token) throws IOException {
        return BinaryTag.LIST_8.contentEquals(token) ? this.dataInputStream.readUnsignedByte() : this.dataInputStream.readUnsignedShort();
    }

    private Map<String, Object> readAttributes(int size) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int pair = size - 1; pair > 1; pair -= 2) {
            String key = this.readString();
            Object value = this.read(true);
            map.put(key, value);
        }
        return map;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.dataInputStream.close();
    }
}

