/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.binary;

import it.auties.whatsapp.binary.BinaryTag;
import it.auties.whatsapp.binary.BinaryTokens;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.node.Node;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class BinaryEncoder
implements AutoCloseable {
    private static final int UNSIGNED_BYTE_MAX_VALUE = 256;
    private static final int UNSIGNED_SHORT_MAX_VALUE = 65536;
    private static final int INT_20_MAX_VALUE = 0x100000;
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final DataOutputStream dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);
    private final List<String> singleByteTokens;
    private final List<String> doubleByteTokens;
    private boolean closed;

    public BinaryEncoder() {
        this(BinaryTokens.SINGLE_BYTE, BinaryTokens.DOUBLE_BYTE);
    }

    public BinaryEncoder(List<String> singleByteTokens, List<String> doubleByteTokens) {
        this.singleByteTokens = singleByteTokens;
        this.doubleByteTokens = doubleByteTokens;
    }

    public byte[] encode(Node node) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("The encoder is closed");
        }
        this.dataOutputStream.write(0);
        this.writeNode(node);
        return this.byteArrayOutputStream.toByteArray();
    }

    private void writeString(String input, BinaryTag token) throws IOException {
        this.dataOutputStream.write(token.data());
        this.writeStringLength(input);
        int charCode = 0;
        for (int index = 0; index < input.length(); ++index) {
            int stringCodePoint = Character.codePointAt(input, index);
            int binaryCodePoint = this.getStringCodePoint(token, stringCodePoint);
            if (index % 2 != 0) {
                this.dataOutputStream.write(charCode |= binaryCodePoint);
                continue;
            }
            charCode = binaryCodePoint << 4;
            if (index != input.length() - 1) continue;
            this.dataOutputStream.write(charCode |= 0xF);
        }
    }

    private int getStringCodePoint(BinaryTag token, int codePoint) {
        if (codePoint >= 48 && codePoint <= 57) {
            return codePoint - 48;
        }
        if (token == BinaryTag.NIBBLE_8 && codePoint == 45) {
            return 10;
        }
        if (token == BinaryTag.NIBBLE_8 && codePoint == 46) {
            return 11;
        }
        if (token == BinaryTag.HEX_8 && codePoint >= 65 && codePoint <= 70) {
            return codePoint - 55;
        }
        throw new IllegalArgumentException("Cannot parse codepoint %s with token %s".formatted(new Object[]{codePoint, token}));
    }

    private void writeStringLength(String input) throws IOException {
        int roundedLength = (int)Math.ceil((float)input.length() / 2.0f);
        if (input.length() % 2 == 1) {
            this.dataOutputStream.write(roundedLength | 0x80);
            return;
        }
        this.dataOutputStream.write(roundedLength);
    }

    private void writeLong(long input) throws IOException {
        if (input < 256L) {
            this.dataOutputStream.write(BinaryTag.BINARY_8.data());
            this.dataOutputStream.write((int)input);
            return;
        }
        if (input < 0x100000L) {
            this.dataOutputStream.write(BinaryTag.BINARY_20.data());
            this.dataOutputStream.write((int)(input >>> 16 & 0xFFL));
            this.dataOutputStream.write((int)(input >>> 8 & 0xFFL));
            this.dataOutputStream.write((int)(0xFFL & input));
            return;
        }
        this.dataOutputStream.write(BinaryTag.BINARY_32.data());
        this.dataOutputStream.writeLong(input);
    }

    private void writeString(String input) throws IOException {
        if (input.isEmpty()) {
            this.dataOutputStream.write(BinaryTag.BINARY_8.data());
            this.dataOutputStream.write(BinaryTag.LIST_EMPTY.data());
            return;
        }
        int tokenIndex = this.singleByteTokens.indexOf(input);
        if (tokenIndex != -1) {
            this.dataOutputStream.write(tokenIndex + 1);
            return;
        }
        if (this.writeDoubleByteString(input)) {
            return;
        }
        int length = this.length(input);
        if (length < 128 && !BinaryTokens.anyMatch(input, "[^0-9.-]+?")) {
            this.writeString(input, BinaryTag.NIBBLE_8);
            return;
        }
        if (length < 128 && !BinaryTokens.anyMatch(input, "[^0-9A-F]+?")) {
            this.writeString(input, BinaryTag.HEX_8);
            return;
        }
        this.writeLong(length);
        this.dataOutputStream.write(input.getBytes(StandardCharsets.UTF_8));
    }

    private boolean writeDoubleByteString(String input) throws IOException {
        if (!this.doubleByteTokens.contains(input)) {
            return false;
        }
        int index = this.doubleByteTokens.indexOf(input);
        this.dataOutputStream.write(this.doubleByteStringTag(index).data());
        this.dataOutputStream.write(index % (this.doubleByteTokens.size() / 4));
        return true;
    }

    private BinaryTag doubleByteStringTag(int index) {
        return switch (index / (this.doubleByteTokens.size() / 4)) {
            case 0 -> BinaryTag.DICTIONARY_0;
            case 1 -> BinaryTag.DICTIONARY_1;
            case 2 -> BinaryTag.DICTIONARY_2;
            case 3 -> BinaryTag.DICTIONARY_3;
            default -> throw new IllegalArgumentException("Cannot find tag for quadrant %s".formatted(index));
        };
    }

    private void writeNode(Node input) throws IOException {
        if (input.description().equals("0")) {
            this.dataOutputStream.write(BinaryTag.LIST_8.data());
            this.dataOutputStream.write(BinaryTag.LIST_EMPTY.data());
            return;
        }
        this.writeInt(input.size());
        this.writeString(input.description());
        this.writeAttributes(input);
        if (input.hasContent()) {
            this.write(input.content());
        }
    }

    private void writeAttributes(Node input) throws IOException {
        for (Map.Entry<String, Object> entry : input.attributes().toMap().entrySet()) {
            this.writeString(entry.getKey());
            this.write(entry.getValue());
        }
    }

    private void writeInt(int size) throws IOException {
        if (size < 256) {
            this.dataOutputStream.write(BinaryTag.LIST_8.data());
            this.dataOutputStream.write(size);
            return;
        }
        if (size < 65536) {
            this.dataOutputStream.write(BinaryTag.LIST_16.data());
            this.dataOutputStream.writeShort(size);
            return;
        }
        throw new IllegalArgumentException("Cannot write int %s: overflow".formatted(size));
    }

    private void write(Object input) throws IOException {
        Object object = input;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Boolean.class, Number.class, byte[].class, Jid.class, Collection.class, Enum.class, Node.class}, (Object)object, n)) {
            case -1: {
                this.dataOutputStream.write(BinaryTag.LIST_EMPTY.data());
                break;
            }
            case 0: {
                String str = (String)object;
                this.writeString(str);
                break;
            }
            case 1: {
                Boolean bool = (Boolean)object;
                this.writeString(Boolean.toString(bool));
                break;
            }
            case 2: {
                Number number = (Number)object;
                this.writeString(number.toString());
                break;
            }
            case 3: {
                byte[] bytes = (byte[])object;
                this.writeBytes(bytes);
                break;
            }
            case 4: {
                Jid jid = (Jid)object;
                this.writeJid(jid);
                break;
            }
            case 5: {
                Collection collection = (Collection)object;
                this.writeList(collection);
                break;
            }
            case 6: {
                Enum serializable = (Enum)object;
                this.writeString(Objects.toString(serializable));
                break;
            }
            case 7: {
                Node node = (Node)object;
                throw new IllegalArgumentException("Invalid payload type(nodes should be wrapped by a collection): %s".formatted(input));
            }
            default: {
                throw new IllegalArgumentException("Invalid payload type(%s): %s".formatted(input.getClass().getName(), input));
            }
        }
    }

    private void writeList(Collection<?> collection) throws IOException {
        this.writeInt(collection.size());
        for (Object entry : collection) {
            if (!(entry instanceof Node)) continue;
            Node node = (Node)entry;
            this.writeNode(node);
        }
    }

    private void writeBytes(byte[] bytes) throws IOException {
        this.writeLong(bytes.length);
        this.dataOutputStream.write(bytes);
    }

    private void writeJid(Jid jid) throws IOException {
        if (jid.isCompanion()) {
            this.dataOutputStream.write(BinaryTag.COMPANION_JID.data());
            this.dataOutputStream.write(jid.agent());
            this.dataOutputStream.write(jid.device());
            this.writeString(jid.user());
            return;
        }
        this.dataOutputStream.write(BinaryTag.JID_PAIR.data());
        if (jid.user() != null) {
            this.writeString(jid.user());
            this.writeString(jid.server().address());
            return;
        }
        this.dataOutputStream.write(BinaryTag.LIST_EMPTY.data());
        this.writeString(jid.server().address());
    }

    private int length(String input) {
        return input.getBytes(StandardCharsets.UTF_8).length;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.dataOutputStream.close();
    }
}

