/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.button.interactive;

import it.auties.whatsapp.model.button.interactive.InteractiveHeader;
import it.auties.whatsapp.model.button.interactive.InteractiveHeaderThumbnail;
import it.auties.whatsapp.model.message.standard.DocumentMessage;
import it.auties.whatsapp.model.message.standard.ImageMessage;
import it.auties.whatsapp.model.message.standard.VideoOrGifMessage;
import java.util.Optional;

public class InteractiveHeaderBuilder {
    private String title = null;
    private Optional<String> subtitle = Optional.empty();
    private Optional<DocumentMessage> attachmentDocument = Optional.empty();
    private Optional<ImageMessage> attachmentImage = Optional.empty();
    private boolean mediaAttachment = false;
    private Optional<InteractiveHeaderThumbnail> attachmentThumbnail = Optional.empty();
    private Optional<VideoOrGifMessage> attachmentVideo = Optional.empty();

    public InteractiveHeaderBuilder title(String title) {
        this.title = title;
        return this;
    }

    public InteractiveHeaderBuilder subtitle(Optional<String> subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public InteractiveHeaderBuilder subtitle(String subtitle) {
        this.subtitle = Optional.ofNullable(subtitle);
        return this;
    }

    public InteractiveHeaderBuilder attachmentDocument(Optional<DocumentMessage> attachmentDocument) {
        this.attachmentDocument = attachmentDocument;
        return this;
    }

    public InteractiveHeaderBuilder attachmentDocument(DocumentMessage attachmentDocument) {
        this.attachmentDocument = Optional.ofNullable(attachmentDocument);
        return this;
    }

    public InteractiveHeaderBuilder attachmentImage(Optional<ImageMessage> attachmentImage) {
        this.attachmentImage = attachmentImage;
        return this;
    }

    public InteractiveHeaderBuilder attachmentImage(ImageMessage attachmentImage) {
        this.attachmentImage = Optional.ofNullable(attachmentImage);
        return this;
    }

    public InteractiveHeaderBuilder mediaAttachment(boolean mediaAttachment) {
        this.mediaAttachment = mediaAttachment;
        return this;
    }

    public InteractiveHeaderBuilder attachmentThumbnail(Optional<InteractiveHeaderThumbnail> attachmentThumbnail) {
        this.attachmentThumbnail = attachmentThumbnail;
        return this;
    }

    public InteractiveHeaderBuilder attachmentThumbnail(InteractiveHeaderThumbnail attachmentThumbnail) {
        this.attachmentThumbnail = Optional.ofNullable(attachmentThumbnail);
        return this;
    }

    public InteractiveHeaderBuilder attachmentVideo(Optional<VideoOrGifMessage> attachmentVideo) {
        this.attachmentVideo = attachmentVideo;
        return this;
    }

    public InteractiveHeaderBuilder attachmentVideo(VideoOrGifMessage attachmentVideo) {
        this.attachmentVideo = Optional.ofNullable(attachmentVideo);
        return this;
    }

    public InteractiveHeader build() {
        return new InteractiveHeader(this.title, this.subtitle, this.attachmentDocument, this.attachmentImage, this.mediaAttachment, this.attachmentThumbnail, this.attachmentVideo);
    }
}

