/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.button.interactive;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.button.interactive.InteractiveHeader;
import it.auties.whatsapp.model.button.interactive.InteractiveHeaderThumbnail;
import it.auties.whatsapp.model.message.standard.DocumentMessage;
import it.auties.whatsapp.model.message.standard.DocumentMessageSpec;
import it.auties.whatsapp.model.message.standard.ImageMessage;
import it.auties.whatsapp.model.message.standard.ImageMessageSpec;
import it.auties.whatsapp.model.message.standard.VideoOrGifMessage;
import it.auties.whatsapp.model.message.standard.VideoOrGifMessageSpec;
import java.util.Optional;

public class InteractiveHeaderSpec {
    public static byte[] encode(InteractiveHeader protoInputObject) {
        Optional<VideoOrGifMessage> attachmentVideo;
        VideoOrGifMessage attachmentVideo0;
        byte[] attachmentThumbnail1;
        Optional<ImageMessage> attachmentImage;
        ImageMessage attachmentImage0;
        Optional<DocumentMessage> attachmentDocument;
        DocumentMessage attachmentDocument0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeString(1, protoInputObject.title());
        Optional<String> subtitle = protoInputObject.subtitle();
        String subtitle0 = subtitle.orElse(null);
        if (subtitle0 != null) {
            outputStream.writeString(2, subtitle0);
        }
        if ((attachmentDocument0 = (DocumentMessage)(attachmentDocument = protoInputObject.attachmentDocument()).orElse(null)) != null) {
            outputStream.writeBytes(3, DocumentMessageSpec.encode(attachmentDocument0));
        }
        if ((attachmentImage0 = (ImageMessage)(attachmentImage = protoInputObject.attachmentImage()).orElse(null)) != null) {
            outputStream.writeBytes(4, ImageMessageSpec.encode(attachmentImage0));
        }
        outputStream.writeBool(5, Boolean.valueOf(protoInputObject.mediaAttachment()));
        Optional<InteractiveHeaderThumbnail> attachmentThumbnail = protoInputObject.attachmentThumbnail();
        InteractiveHeaderThumbnail attachmentThumbnail0 = attachmentThumbnail.orElse(null);
        if (attachmentThumbnail0 != null && (attachmentThumbnail1 = attachmentThumbnail0.thumbnail()) != null) {
            outputStream.writeBytes(6, attachmentThumbnail1);
        }
        if ((attachmentVideo0 = (VideoOrGifMessage)(attachmentVideo = protoInputObject.attachmentVideo()).orElse(null)) != null) {
            outputStream.writeBytes(7, VideoOrGifMessageSpec.encode(attachmentVideo0));
        }
        return outputStream.toByteArray();
    }

    public static InteractiveHeader decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        String title = null;
        Optional<String> subtitle = Optional.empty();
        Optional<DocumentMessage> attachmentDocument = Optional.empty();
        Optional<ImageMessage> attachmentImage = Optional.empty();
        boolean mediaAttachment = false;
        Optional<InteractiveHeaderThumbnail> attachmentThumbnail = Optional.empty();
        Optional<VideoOrGifMessage> attachmentVideo = Optional.empty();
        block9: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    title = inputStream.readString();
                    continue block9;
                }
                case 2: {
                    subtitle = Optional.ofNullable(inputStream.readString());
                    continue block9;
                }
                case 3: {
                    attachmentDocument = Optional.ofNullable(DocumentMessageSpec.decode(inputStream.readBytes()));
                    continue block9;
                }
                case 4: {
                    attachmentImage = Optional.ofNullable(ImageMessageSpec.decode(inputStream.readBytes()));
                    continue block9;
                }
                case 5: {
                    mediaAttachment = inputStream.readBool();
                    continue block9;
                }
                case 6: {
                    attachmentThumbnail = Optional.ofNullable(InteractiveHeaderThumbnail.of(inputStream.readBytes()));
                    continue block9;
                }
                case 7: {
                    attachmentVideo = Optional.ofNullable(VideoOrGifMessageSpec.decode(inputStream.readBytes()));
                    continue block9;
                }
            }
            inputStream.skipBytes();
        }
        return new InteractiveHeader(title, subtitle, attachmentDocument, attachmentImage, mediaAttachment, attachmentThumbnail, attachmentVideo);
    }
}

