/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.companion;

import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;

public record CompanionDevice(@ProtobufProperty(index=1, type=ProtobufType.STRING) String model, @ProtobufProperty(index=2, type=ProtobufType.STRING) String manufacturer, @ProtobufProperty(index=3, type=ProtobufType.OBJECT) UserAgent.PlatformType platform, @ProtobufProperty(index=4, type=ProtobufType.OBJECT) Optional<Version> appVersion, @ProtobufProperty(index=5, type=ProtobufType.OBJECT) Version osVersion) implements ProtobufMessage
{
    private static final List<String> IPHONES = List.of("iPhone_11", "iPhone_11_Pro", "iPhone_11_Pro_Max", "iPhone_12", "iPhone_12_Pro", "iPhone_12_Pro_Max", "iPhone_13", "iPhone_13_Pro", "iPhone_13_Pro_Max", "iPhone_14", "iPhone_14_Plus", "iPhone_14_Pro", "iPhone_14_Pro_Max", "iPhone_15", "iPhone_15_Plus", "iPhone_15_Pro", "iPhone_15_Pro_Max");

    public static CompanionDevice web() {
        return CompanionDevice.web(null);
    }

    public static CompanionDevice web(Version appVersion) {
        return new CompanionDevice("Chrome", "Google", UserAgent.PlatformType.WEB, Optional.ofNullable(appVersion), Version.of("1.0"));
    }

    public static CompanionDevice ios(boolean business) {
        return CompanionDevice.ios(null, business);
    }

    public static CompanionDevice ios(Version appVersion, boolean business) {
        return new CompanionDevice(IPHONES.get(ThreadLocalRandom.current().nextInt(IPHONES.size())), "Apple", business ? UserAgent.PlatformType.IOS_BUSINESS : UserAgent.PlatformType.IOS, Optional.ofNullable(appVersion), Version.of("17.2.1"));
    }

    public static CompanionDevice android(boolean business) {
        return CompanionDevice.android(null, business);
    }

    public static CompanionDevice android(Version appVersion, boolean business) {
        return new CompanionDevice("P60", "HUAWEI", business ? UserAgent.PlatformType.ANDROID_BUSINESS : UserAgent.PlatformType.ANDROID, Optional.ofNullable(appVersion), Version.of("10.11.0"));
    }

    public String toUserAgent(Version appVersion) {
        return "WhatsApp/%s %s/%s Device/%s".formatted(appVersion, this.platformName(), this.osVersion.toString(), this.deviceName());
    }

    public CompanionDevice toPersonal() {
        if (!this.platform.isBusiness()) {
            return this;
        }
        return new CompanionDevice(this.model, this.manufacturer, this.platform.toPersonal(), this.appVersion, this.osVersion);
    }

    public CompanionDevice toBusiness() {
        if (this.platform.isBusiness()) {
            return this;
        }
        return new CompanionDevice(this.model, this.manufacturer, this.platform.toBusiness(), this.appVersion, this.osVersion);
    }

    private String deviceName() {
        return switch (this.platform()) {
            case UserAgent.PlatformType.ANDROID, UserAgent.PlatformType.ANDROID_BUSINESS -> this.manufacturer + " " + this.model;
            case UserAgent.PlatformType.IOS, UserAgent.PlatformType.IOS_BUSINESS -> this.model;
            case UserAgent.PlatformType.KAIOS -> this.manufacturer + "+" + this.model;
            default -> throw new IllegalStateException("Unsupported mobile os");
        };
    }

    private String platformName() {
        return switch (this.platform()) {
            case UserAgent.PlatformType.ANDROID -> "Android";
            case UserAgent.PlatformType.ANDROID_BUSINESS -> "SMBA";
            case UserAgent.PlatformType.IOS -> "iOS";
            case UserAgent.PlatformType.IOS_BUSINESS -> "SMB iOS";
            default -> throw new IllegalStateException("Unsupported mobile os");
        };
    }
}

