/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.contact;

import it.auties.protobuf.extension.OptionalExtension;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactStatus;
import it.auties.whatsapp.model.contact.ContactStatusSpec;
import it.auties.whatsapp.model.jid.Jid;
import java.util.Optional;
import java.util.OptionalLong;

public class ContactSpec {
    public static byte[] encode(Contact protoInputObject) {
        Long lastSeenSeconds0;
        String shortName0;
        Optional<String> shortName;
        String fullName0;
        Optional<String> fullName;
        String chosenName0;
        Optional<String> chosenName;
        String jid0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        Jid jid = protoInputObject.jid();
        if (jid != null && (jid0 = jid.toString()) != null) {
            outputStream.writeString(1, jid0);
        }
        if ((chosenName = protoInputObject.chosenName()) != null && (chosenName0 = (String)chosenName.orElse(null)) != null) {
            outputStream.writeString(2, chosenName0);
        }
        if ((fullName = protoInputObject.fullName()) != null && (fullName0 = (String)fullName.orElse(null)) != null) {
            outputStream.writeString(3, fullName0);
        }
        if ((shortName = protoInputObject.shortName()) != null && (shortName0 = (String)shortName.orElse(null)) != null) {
            outputStream.writeString(4, shortName0);
        }
        outputStream.writeInt32(5, ContactStatusSpec.encode(protoInputObject.lastKnownPresence()));
        OptionalLong lastSeenSeconds = protoInputObject.lastSeenSeconds();
        if (lastSeenSeconds != null && (lastSeenSeconds0 = OptionalExtension.toNullableLong((OptionalLong)lastSeenSeconds)) != null) {
            outputStream.writeUInt64(6, lastSeenSeconds0);
        }
        outputStream.writeBool(7, Boolean.valueOf(protoInputObject.blocked()));
        return outputStream.toByteArray();
    }

    public static Contact decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        Jid jid = null;
        String chosenName = null;
        String fullName = null;
        String shortName = null;
        ContactStatus lastKnownPresence = null;
        Long lastSeenSeconds = null;
        boolean blocked = false;
        block9: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    jid = Jid.ofProtobuf(inputStream.readString());
                    continue block9;
                }
                case 2: {
                    chosenName = inputStream.readString();
                    continue block9;
                }
                case 3: {
                    fullName = inputStream.readString();
                    continue block9;
                }
                case 4: {
                    shortName = inputStream.readString();
                    continue block9;
                }
                case 5: {
                    lastKnownPresence = ContactStatusSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block9;
                }
                case 6: {
                    lastSeenSeconds = inputStream.readInt64();
                    continue block9;
                }
                case 7: {
                    blocked = inputStream.readBool();
                    continue block9;
                }
            }
            inputStream.skipBytes();
        }
        return new Contact(jid, chosenName, fullName, shortName, lastKnownPresence, lastSeenSeconds, blocked);
    }
}

