/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificate;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateSpec;
import it.auties.whatsapp.model.info.BusinessIdentityInfo;
import it.auties.whatsapp.model.info.BusinessIdentityInfoActorsTypeSpec;
import it.auties.whatsapp.model.info.BusinessIdentityInfoHostStorageTypeSpec;
import it.auties.whatsapp.model.info.BusinessIdentityInfoVerifiedLevelSpec;

public class BusinessIdentityInfoSpec {
    public static byte[] encode(BusinessIdentityInfo protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeInt32(1, BusinessIdentityInfoVerifiedLevelSpec.encode(protoInputObject.level()));
        outputStream.writeBytes(2, BusinessVerifiedNameCertificateSpec.encode(protoInputObject.certificate()));
        outputStream.writeBool(3, Boolean.valueOf(protoInputObject.signed()));
        outputStream.writeBool(4, Boolean.valueOf(protoInputObject.revoked()));
        outputStream.writeInt32(5, BusinessIdentityInfoHostStorageTypeSpec.encode(protoInputObject.hostStorage()));
        outputStream.writeInt32(6, BusinessIdentityInfoActorsTypeSpec.encode(protoInputObject.actualActors()));
        outputStream.writeUInt64(7, Long.valueOf(protoInputObject.privacyModeTimestampSeconds()));
        outputStream.writeUInt64(8, Long.valueOf(protoInputObject.featureControls()));
        return outputStream.toByteArray();
    }

    public static BusinessIdentityInfo decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        BusinessIdentityInfo.VerifiedLevel level = null;
        BusinessVerifiedNameCertificate certificate = null;
        boolean signed = false;
        boolean revoked = false;
        BusinessIdentityInfo.HostStorageType hostStorage = null;
        BusinessIdentityInfo.ActorsType actualActors = null;
        long privacyModeTimestampSeconds = 0L;
        long featureControls = 0L;
        block10: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    level = BusinessIdentityInfoVerifiedLevelSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block10;
                }
                case 2: {
                    certificate = BusinessVerifiedNameCertificateSpec.decode(inputStream.readBytes());
                    continue block10;
                }
                case 3: {
                    signed = inputStream.readBool();
                    continue block10;
                }
                case 4: {
                    revoked = inputStream.readBool();
                    continue block10;
                }
                case 5: {
                    hostStorage = BusinessIdentityInfoHostStorageTypeSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block10;
                }
                case 6: {
                    actualActors = BusinessIdentityInfoActorsTypeSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block10;
                }
                case 7: {
                    privacyModeTimestampSeconds = inputStream.readInt64();
                    continue block10;
                }
                case 8: {
                    featureControls = inputStream.readInt64();
                    continue block10;
                }
            }
            inputStream.skipBytes();
        }
        return new BusinessIdentityInfo(level, certificate, signed, revoked, hostStorage, actualActors, privacyModeTimestampSeconds, featureControls);
    }
}

