/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.protobuf.annotation.ProtobufMessageName;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.button.base.ButtonActionLink;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatDisappear;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.info.AdReplyInfo;
import it.auties.whatsapp.model.info.ContextInfoBuilder;
import it.auties.whatsapp.model.info.ExternalAdReplyInfo;
import it.auties.whatsapp.model.info.Info;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.MessageContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@ProtobufMessageName(value="ContextInfo")
public final class ContextInfo
implements Info,
ProtobufMessage {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private final String quotedMessageId;
    @ProtobufProperty(index=2, type=ProtobufType.STRING)
    private final Jid quotedMessageSenderJid;
    @ProtobufProperty(index=3, type=ProtobufType.OBJECT)
    private final MessageContainer quotedMessage;
    @ProtobufProperty(index=4, type=ProtobufType.STRING)
    private final Jid quotedMessageChatJid;
    @ProtobufProperty(index=15, type=ProtobufType.STRING)
    private final List<Jid> mentions;
    @ProtobufProperty(index=18, type=ProtobufType.STRING)
    private final String conversionSource;
    @ProtobufProperty(index=19, type=ProtobufType.BYTES)
    private final byte[] conversionData;
    @ProtobufProperty(index=20, type=ProtobufType.UINT32)
    private final int conversionDelaySeconds;
    @ProtobufProperty(index=21, type=ProtobufType.UINT32)
    private final int forwardingScore;
    @ProtobufProperty(index=22, type=ProtobufType.BOOL)
    private final boolean forwarded;
    @ProtobufProperty(index=23, type=ProtobufType.OBJECT)
    private final AdReplyInfo quotedAd;
    @ProtobufProperty(index=24, type=ProtobufType.OBJECT)
    private final ChatMessageKey placeholderKey;
    @ProtobufProperty(index=25, type=ProtobufType.UINT32)
    private int ephemeralExpiration;
    @ProtobufProperty(index=26, type=ProtobufType.INT64)
    private long ephemeralSettingTimestamp;
    @ProtobufProperty(index=27, type=ProtobufType.BYTES)
    private final byte[] ephemeralSharedSecret;
    @ProtobufProperty(index=28, type=ProtobufType.OBJECT)
    private final ExternalAdReplyInfo externalAdReply;
    @ProtobufProperty(index=29, type=ProtobufType.STRING)
    private final String entryPointConversionSource;
    @ProtobufProperty(index=30, type=ProtobufType.STRING)
    private final String entryPointConversionApp;
    @ProtobufProperty(index=31, type=ProtobufType.UINT32)
    private final int entryPointConversionDelaySeconds;
    @ProtobufProperty(index=32, type=ProtobufType.OBJECT)
    private final ChatDisappear disappearingMode;
    @ProtobufProperty(index=33, type=ProtobufType.OBJECT)
    private final ButtonActionLink actionLink;
    @ProtobufProperty(index=34, type=ProtobufType.STRING)
    private final String groupSubject;
    @ProtobufProperty(index=35, type=ProtobufType.STRING)
    private final Jid parentGroup;
    @ProtobufProperty(index=37, type=ProtobufType.STRING)
    private final String trustBannerType;
    @ProtobufProperty(index=38, type=ProtobufType.UINT32)
    private final int trustBannerAction;
    private Contact quotedMessageSender;
    @JsonBackReference
    private Chat quotedMessageChat;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ContextInfo(String quotedMessageId, Jid quotedMessageSenderJid, MessageContainer quotedMessage, Jid quotedMessageChatJid, List<Jid> mentions, String conversionSource, byte[] conversionData, int conversionDelaySeconds, int forwardingScore, boolean forwarded, AdReplyInfo quotedAd, ChatMessageKey placeholderKey, int ephemeralExpiration, long ephemeralSettingTimestamp, byte[] ephemeralSharedSecret, ExternalAdReplyInfo externalAdReply, String entryPointConversionSource, String entryPointConversionApp, int entryPointConversionDelaySeconds, ChatDisappear disappearingMode, ButtonActionLink actionLink, String groupSubject, Jid parentGroup, String trustBannerType, int trustBannerAction) {
        this.quotedMessageId = quotedMessageId;
        this.quotedMessageSenderJid = quotedMessageSenderJid;
        this.quotedMessage = quotedMessage;
        this.quotedMessageChatJid = quotedMessageChatJid;
        this.mentions = mentions;
        this.conversionSource = conversionSource;
        this.conversionData = conversionData;
        this.conversionDelaySeconds = conversionDelaySeconds;
        this.forwardingScore = forwardingScore;
        this.forwarded = forwarded;
        this.quotedAd = quotedAd;
        this.placeholderKey = placeholderKey;
        this.ephemeralExpiration = ephemeralExpiration;
        this.ephemeralSettingTimestamp = ephemeralSettingTimestamp;
        this.ephemeralSharedSecret = ephemeralSharedSecret;
        this.externalAdReply = externalAdReply;
        this.entryPointConversionSource = entryPointConversionSource;
        this.entryPointConversionApp = entryPointConversionApp;
        this.entryPointConversionDelaySeconds = entryPointConversionDelaySeconds;
        this.disappearingMode = disappearingMode;
        this.actionLink = actionLink;
        this.groupSubject = groupSubject;
        this.parentGroup = parentGroup;
        this.trustBannerType = trustBannerType;
        this.trustBannerAction = trustBannerAction;
    }

    public static ContextInfo of(MessageInfo quotedMessage) {
        return new ContextInfoBuilder().quotedMessageId(quotedMessage.id()).quotedMessage(quotedMessage.message()).quotedMessageChatJid(quotedMessage.parentJid()).quotedMessageSenderJid(quotedMessage.senderJid()).mentions(new ArrayList<Jid>()).build();
    }

    public static ContextInfo empty() {
        return new ContextInfoBuilder().mentions(new ArrayList<Jid>()).build();
    }

    public Optional<Contact> quotedMessageSender() {
        return Optional.ofNullable(this.quotedMessageSender);
    }

    public ContextInfo setQuotedMessageSender(Contact quotedMessageSender) {
        this.quotedMessageSender = quotedMessageSender;
        return this;
    }

    public Optional<Jid> quotedMessageChatJid() {
        return Optional.ofNullable(this.quotedMessageChatJid).or(this::quotedMessageSenderJid);
    }

    public Optional<Jid> quotedMessageSenderJid() {
        return Optional.ofNullable(this.quotedMessageSenderJid);
    }

    public boolean hasQuotedMessage() {
        return this.quotedMessageId().isPresent() && this.quotedMessage().isPresent() && this.quotedMessageChat().isPresent();
    }

    public Optional<String> quotedMessageId() {
        return Optional.ofNullable(this.quotedMessageId);
    }

    public Optional<MessageContainer> quotedMessage() {
        return Optional.ofNullable(this.quotedMessage);
    }

    public Optional<Chat> quotedMessageChat() {
        return Optional.ofNullable(this.quotedMessageChat);
    }

    public ContextInfo setQuotedMessageChat(Chat quotedMessageChat) {
        this.quotedMessageChat = quotedMessageChat;
        return this;
    }

    public List<Jid> mentions() {
        return this.mentions;
    }

    public Optional<String> conversionSource() {
        return Optional.ofNullable(this.conversionSource);
    }

    public Optional<byte[]> conversionData() {
        return Optional.ofNullable(this.conversionData);
    }

    public int conversionDelaySeconds() {
        return this.conversionDelaySeconds;
    }

    public int forwardingScore() {
        return this.forwardingScore;
    }

    public boolean forwarded() {
        return this.forwarded;
    }

    public Optional<AdReplyInfo> quotedAd() {
        return Optional.ofNullable(this.quotedAd);
    }

    public Optional<ChatMessageKey> placeholderKey() {
        return Optional.ofNullable(this.placeholderKey);
    }

    public int ephemeralExpiration() {
        return this.ephemeralExpiration;
    }

    public ContextInfo setEphemeralExpiration(int ephemeralExpiration) {
        this.ephemeralExpiration = ephemeralExpiration;
        return this;
    }

    public long ephemeralSettingTimestamp() {
        return this.ephemeralSettingTimestamp;
    }

    public ContextInfo setEphemeralSettingTimestamp(long ephemeralSettingTimestamp) {
        this.ephemeralSettingTimestamp = ephemeralSettingTimestamp;
        return this;
    }

    public Optional<byte[]> ephemeralSharedSecret() {
        return Optional.ofNullable(this.ephemeralSharedSecret);
    }

    public Optional<ExternalAdReplyInfo> externalAdReply() {
        return Optional.ofNullable(this.externalAdReply);
    }

    public Optional<String> entryPointConversionSource() {
        return Optional.ofNullable(this.entryPointConversionSource);
    }

    public Optional<String> entryPointConversionApp() {
        return Optional.ofNullable(this.entryPointConversionApp);
    }

    public int entryPointConversionDelaySeconds() {
        return this.entryPointConversionDelaySeconds;
    }

    public Optional<ChatDisappear> disappearingMode() {
        return Optional.ofNullable(this.disappearingMode);
    }

    public Optional<ButtonActionLink> actionLink() {
        return Optional.ofNullable(this.actionLink);
    }

    public Optional<String> groupSubject() {
        return Optional.ofNullable(this.groupSubject);
    }

    public Optional<Jid> parentGroup() {
        return Optional.ofNullable(this.parentGroup);
    }

    public Optional<String> trustBannerType() {
        return Optional.ofNullable(this.trustBannerType);
    }

    public int trustBannerAction() {
        return this.trustBannerAction;
    }
}

