/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.PaymentInfo;
import it.auties.whatsapp.model.info.PaymentInfoCurrencySpec;
import it.auties.whatsapp.model.info.PaymentInfoStatusSpec;
import it.auties.whatsapp.model.info.PaymentInfoTransactionStatusSpec;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ChatMessageKeySpec;
import it.auties.whatsapp.model.payment.PaymentMoney;
import it.auties.whatsapp.model.payment.PaymentMoneySpec;

public class PaymentInfoSpec {
    public static byte[] encode(PaymentInfo protoInputObject) {
        String receiverJid0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeInt32(1, PaymentInfoCurrencySpec.encode(protoInputObject.currencyDeprecated()));
        outputStream.writeUInt64(2, Long.valueOf(protoInputObject.amount1000()));
        Jid receiverJid = protoInputObject.receiverJid();
        if (receiverJid != null && (receiverJid0 = receiverJid.toString()) != null) {
            outputStream.writeString(3, receiverJid0);
        }
        outputStream.writeInt32(4, PaymentInfoStatusSpec.encode(protoInputObject.status()));
        outputStream.writeUInt64(5, Long.valueOf(protoInputObject.transactionTimestampSeconds()));
        outputStream.writeBytes(6, ChatMessageKeySpec.encode(protoInputObject.requestMessageKey()));
        outputStream.writeUInt64(7, Long.valueOf(protoInputObject.expiryTimestampSeconds()));
        outputStream.writeBool(8, Boolean.valueOf(protoInputObject.futureProofed()));
        outputStream.writeString(9, protoInputObject.currency());
        outputStream.writeInt32(10, PaymentInfoTransactionStatusSpec.encode(protoInputObject.transactionStatus()));
        outputStream.writeBool(11, Boolean.valueOf(protoInputObject.useNoviFormat()));
        outputStream.writeBytes(12, PaymentMoneySpec.encode(protoInputObject.primaryAmount()));
        outputStream.writeBytes(13, PaymentMoneySpec.encode(protoInputObject.exchangeAmount()));
        return outputStream.toByteArray();
    }

    public static PaymentInfo decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        PaymentInfo.Currency currencyDeprecated = null;
        long amount1000 = 0L;
        Jid receiverJid = null;
        PaymentInfo.Status status = null;
        long transactionTimestampSeconds = 0L;
        ChatMessageKey requestMessageKey = null;
        long expiryTimestampSeconds = 0L;
        boolean futureProofed = false;
        String currency = null;
        PaymentInfo.TransactionStatus transactionStatus = null;
        boolean useNoviFormat = false;
        PaymentMoney primaryAmount = null;
        PaymentMoney exchangeAmount = null;
        block15: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    currencyDeprecated = PaymentInfoCurrencySpec.decode(inputStream.readInt32()).orElse(null);
                    continue block15;
                }
                case 2: {
                    amount1000 = inputStream.readInt64();
                    continue block15;
                }
                case 3: {
                    receiverJid = Jid.ofProtobuf(inputStream.readString());
                    continue block15;
                }
                case 4: {
                    status = PaymentInfoStatusSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block15;
                }
                case 5: {
                    transactionTimestampSeconds = inputStream.readInt64();
                    continue block15;
                }
                case 6: {
                    requestMessageKey = ChatMessageKeySpec.decode(inputStream.readBytes());
                    continue block15;
                }
                case 7: {
                    expiryTimestampSeconds = inputStream.readInt64();
                    continue block15;
                }
                case 8: {
                    futureProofed = inputStream.readBool();
                    continue block15;
                }
                case 9: {
                    currency = inputStream.readString();
                    continue block15;
                }
                case 10: {
                    transactionStatus = PaymentInfoTransactionStatusSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block15;
                }
                case 11: {
                    useNoviFormat = inputStream.readBool();
                    continue block15;
                }
                case 12: {
                    primaryAmount = PaymentMoneySpec.decode(inputStream.readBytes());
                    continue block15;
                }
                case 13: {
                    exchangeAmount = PaymentMoneySpec.decode(inputStream.readBytes());
                    continue block15;
                }
            }
            inputStream.skipBytes();
        }
        return new PaymentInfo(currencyDeprecated, amount1000, receiverJid, status, transactionTimestampSeconds, requestMessageKey, expiryTimestampSeconds, futureProofed, currency, transactionStatus, useNoviFormat, primaryAmount, exchangeAmount);
    }
}

