/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.button;

import it.auties.whatsapp.model.button.base.Button;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.message.button.ButtonsMessage;
import it.auties.whatsapp.model.message.button.ButtonsMessageHeader;
import it.auties.whatsapp.model.message.button.ButtonsMessageHeaderText;
import it.auties.whatsapp.model.message.standard.DocumentMessage;
import it.auties.whatsapp.model.message.standard.ImageMessage;
import it.auties.whatsapp.model.message.standard.LocationMessage;
import it.auties.whatsapp.model.message.standard.VideoOrGifMessage;
import java.util.ArrayList;
import java.util.List;

public class ButtonsMessageBuilder {
    private ButtonsMessageHeaderText headerText = null;
    private DocumentMessage headerDocument = null;
    private ImageMessage headerImage = null;
    private VideoOrGifMessage headerVideo = null;
    private LocationMessage headerLocation = null;
    private String body = null;
    private String footer = null;
    private ContextInfo contextInfo = null;
    private List<Button> buttons = new ArrayList<Button>();
    private ButtonsMessageHeader.Type headerType = null;

    public ButtonsMessageBuilder headerText(ButtonsMessageHeaderText headerText) {
        this.headerText = headerText;
        return this;
    }

    public ButtonsMessageBuilder headerDocument(DocumentMessage headerDocument) {
        this.headerDocument = headerDocument;
        return this;
    }

    public ButtonsMessageBuilder headerImage(ImageMessage headerImage) {
        this.headerImage = headerImage;
        return this;
    }

    public ButtonsMessageBuilder headerVideo(VideoOrGifMessage headerVideo) {
        this.headerVideo = headerVideo;
        return this;
    }

    public ButtonsMessageBuilder headerLocation(LocationMessage headerLocation) {
        this.headerLocation = headerLocation;
        return this;
    }

    public ButtonsMessageBuilder body(String body) {
        this.body = body;
        return this;
    }

    public ButtonsMessageBuilder footer(String footer) {
        this.footer = footer;
        return this;
    }

    public ButtonsMessageBuilder contextInfo(ContextInfo contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }

    public ButtonsMessageBuilder buttons(List<Button> buttons) {
        this.buttons = buttons;
        return this;
    }

    public ButtonsMessageBuilder headerType(ButtonsMessageHeader.Type headerType) {
        this.headerType = headerType;
        return this;
    }

    public ButtonsMessage build() {
        return new ButtonsMessage(this.headerText, this.headerDocument, this.headerImage, this.headerVideo, this.headerLocation, this.body, this.footer, this.contextInfo, this.buttons, this.headerType);
    }
}

