/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.button;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.button.misc.ButtonSection;
import it.auties.whatsapp.model.button.misc.ButtonSectionSpec;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.info.ProductListInfo;
import it.auties.whatsapp.model.info.ProductListInfoSpec;
import it.auties.whatsapp.model.message.button.ListMessage;
import it.auties.whatsapp.model.message.button.ListMessageTypeSpec;
import java.util.ArrayList;
import java.util.Optional;

public class ListMessageSpec {
    public static byte[] encode(ListMessage protoInputObject) {
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        String footer0;
        Optional<String> footer;
        ProductListInfo productListInfo0;
        Optional<ProductListInfo> productListInfo;
        Object description0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeString(1, protoInputObject.title());
        Optional<String> description = protoInputObject.description();
        if (description != null && (description0 = (String)description.orElse(null)) != null) {
            outputStream.writeString(2, (String)description0);
        }
        outputStream.writeString(3, protoInputObject.button());
        outputStream.writeInt32(4, ListMessageTypeSpec.encode(protoInputObject.listType()));
        if (protoInputObject.sections() != null) {
            for (ButtonSection sectionsEntry : protoInputObject.sections()) {
                outputStream.writeBytes(5, ButtonSectionSpec.encode(sectionsEntry));
            }
        }
        if ((productListInfo = protoInputObject.productListInfo()) != null && (productListInfo0 = (ProductListInfo)productListInfo.orElse(null)) != null) {
            outputStream.writeBytes(6, ProductListInfoSpec.encode(productListInfo0));
        }
        if ((footer = protoInputObject.footer()) != null && (footer0 = (String)footer.orElse(null)) != null) {
            outputStream.writeString(7, footer0);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)contextInfo.orElse(null)) != null) {
            outputStream.writeBytes(8, ContextInfoSpec.encode(contextInfo0));
        }
        return outputStream.toByteArray();
    }

    public static ListMessage decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        String title = null;
        String description = null;
        String button = null;
        ListMessage.Type listType = null;
        ArrayList<ButtonSection> sections = new ArrayList<ButtonSection>();
        ProductListInfo productListInfo = null;
        String footer = null;
        ContextInfo contextInfo = null;
        block10: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    title = inputStream.readString();
                    continue block10;
                }
                case 2: {
                    description = inputStream.readString();
                    continue block10;
                }
                case 3: {
                    button = inputStream.readString();
                    continue block10;
                }
                case 4: {
                    listType = ListMessageTypeSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block10;
                }
                case 5: {
                    sections.add(ButtonSectionSpec.decode(inputStream.readBytes()));
                    continue block10;
                }
                case 6: {
                    productListInfo = ProductListInfoSpec.decode(inputStream.readBytes());
                    continue block10;
                }
                case 7: {
                    footer = inputStream.readString();
                    continue block10;
                }
                case 8: {
                    contextInfo = ContextInfoSpec.decode(inputStream.readBytes());
                    continue block10;
                }
            }
            inputStream.skipBytes();
        }
        return new ListMessage(title, description, button, listType, sections, productListInfo, footer, contextInfo);
    }
}

