/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.payment;

import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.payment.RequestPaymentMessage;
import it.auties.whatsapp.model.payment.PaymentBackground;
import it.auties.whatsapp.model.payment.PaymentMoney;
import java.util.Optional;

public class RequestPaymentMessageBuilder {
    private String currency = null;
    private long amount1000 = 0L;
    private Jid requestFrom = null;
    private Optional<MessageContainer> noteMessage = Optional.empty();
    private long expiryTimestampSeconds = 0L;
    private PaymentMoney amount = null;
    private Optional<PaymentBackground> background = Optional.empty();

    public RequestPaymentMessageBuilder currency(String currency) {
        this.currency = currency;
        return this;
    }

    public RequestPaymentMessageBuilder amount1000(long amount1000) {
        this.amount1000 = amount1000;
        return this;
    }

    public RequestPaymentMessageBuilder requestFrom(Jid requestFrom) {
        this.requestFrom = requestFrom;
        return this;
    }

    public RequestPaymentMessageBuilder noteMessage(Optional<MessageContainer> noteMessage) {
        this.noteMessage = noteMessage;
        return this;
    }

    public RequestPaymentMessageBuilder noteMessage(MessageContainer noteMessage) {
        this.noteMessage = Optional.ofNullable(noteMessage);
        return this;
    }

    public RequestPaymentMessageBuilder expiryTimestampSeconds(long expiryTimestampSeconds) {
        this.expiryTimestampSeconds = expiryTimestampSeconds;
        return this;
    }

    public RequestPaymentMessageBuilder amount(PaymentMoney amount) {
        this.amount = amount;
        return this;
    }

    public RequestPaymentMessageBuilder background(Optional<PaymentBackground> background) {
        this.background = background;
        return this;
    }

    public RequestPaymentMessageBuilder background(PaymentBackground background) {
        this.background = Optional.ofNullable(background);
        return this;
    }

    public RequestPaymentMessage build() {
        return new RequestPaymentMessage(this.currency, this.amount1000, this.requestFrom, this.noteMessage, this.expiryTimestampSeconds, this.amount, this.background);
    }
}

