/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.server;

import it.auties.whatsapp.model.chat.ChatDisappear;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.server.ProtocolMessage;
import it.auties.whatsapp.model.sync.AppStateFatalExceptionNotification;
import it.auties.whatsapp.model.sync.AppStateSyncKeyRequest;
import it.auties.whatsapp.model.sync.AppStateSyncKeyShare;
import it.auties.whatsapp.model.sync.HistorySyncNotification;
import it.auties.whatsapp.model.sync.InitialSecurityNotificationSettingSync;
import java.util.Optional;

public class ProtocolMessageBuilder {
    private Optional<ChatMessageKey> key = Optional.empty();
    private ProtocolMessage.Type protocolType = null;
    private long ephemeralExpiration = 0L;
    private long ephemeralSettingTimestampSeconds = 0L;
    private Optional<HistorySyncNotification> historySyncNotification = Optional.empty();
    private Optional<AppStateSyncKeyShare> appStateSyncKeyShare = Optional.empty();
    private Optional<AppStateSyncKeyRequest> appStateSyncKeyRequest = Optional.empty();
    private Optional<InitialSecurityNotificationSettingSync> initialSecurityNotificationSettingSync = Optional.empty();
    private Optional<AppStateFatalExceptionNotification> appStateFatalExceptionNotification = Optional.empty();
    private Optional<ChatDisappear> disappearingMode = Optional.empty();
    private Optional<MessageContainer> editedMessage = Optional.empty();
    private long timestampMilliseconds = 0L;

    public ProtocolMessageBuilder key(Optional<ChatMessageKey> key) {
        this.key = key;
        return this;
    }

    public ProtocolMessageBuilder key(ChatMessageKey key) {
        this.key = Optional.ofNullable(key);
        return this;
    }

    public ProtocolMessageBuilder protocolType(ProtocolMessage.Type protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    public ProtocolMessageBuilder ephemeralExpiration(long ephemeralExpiration) {
        this.ephemeralExpiration = ephemeralExpiration;
        return this;
    }

    public ProtocolMessageBuilder ephemeralSettingTimestampSeconds(long ephemeralSettingTimestampSeconds) {
        this.ephemeralSettingTimestampSeconds = ephemeralSettingTimestampSeconds;
        return this;
    }

    public ProtocolMessageBuilder historySyncNotification(Optional<HistorySyncNotification> historySyncNotification) {
        this.historySyncNotification = historySyncNotification;
        return this;
    }

    public ProtocolMessageBuilder historySyncNotification(HistorySyncNotification historySyncNotification) {
        this.historySyncNotification = Optional.ofNullable(historySyncNotification);
        return this;
    }

    public ProtocolMessageBuilder appStateSyncKeyShare(Optional<AppStateSyncKeyShare> appStateSyncKeyShare) {
        this.appStateSyncKeyShare = appStateSyncKeyShare;
        return this;
    }

    public ProtocolMessageBuilder appStateSyncKeyShare(AppStateSyncKeyShare appStateSyncKeyShare) {
        this.appStateSyncKeyShare = Optional.ofNullable(appStateSyncKeyShare);
        return this;
    }

    public ProtocolMessageBuilder appStateSyncKeyRequest(Optional<AppStateSyncKeyRequest> appStateSyncKeyRequest) {
        this.appStateSyncKeyRequest = appStateSyncKeyRequest;
        return this;
    }

    public ProtocolMessageBuilder appStateSyncKeyRequest(AppStateSyncKeyRequest appStateSyncKeyRequest) {
        this.appStateSyncKeyRequest = Optional.ofNullable(appStateSyncKeyRequest);
        return this;
    }

    public ProtocolMessageBuilder initialSecurityNotificationSettingSync(Optional<InitialSecurityNotificationSettingSync> initialSecurityNotificationSettingSync) {
        this.initialSecurityNotificationSettingSync = initialSecurityNotificationSettingSync;
        return this;
    }

    public ProtocolMessageBuilder initialSecurityNotificationSettingSync(InitialSecurityNotificationSettingSync initialSecurityNotificationSettingSync) {
        this.initialSecurityNotificationSettingSync = Optional.ofNullable(initialSecurityNotificationSettingSync);
        return this;
    }

    public ProtocolMessageBuilder appStateFatalExceptionNotification(Optional<AppStateFatalExceptionNotification> appStateFatalExceptionNotification) {
        this.appStateFatalExceptionNotification = appStateFatalExceptionNotification;
        return this;
    }

    public ProtocolMessageBuilder appStateFatalExceptionNotification(AppStateFatalExceptionNotification appStateFatalExceptionNotification) {
        this.appStateFatalExceptionNotification = Optional.ofNullable(appStateFatalExceptionNotification);
        return this;
    }

    public ProtocolMessageBuilder disappearingMode(Optional<ChatDisappear> disappearingMode) {
        this.disappearingMode = disappearingMode;
        return this;
    }

    public ProtocolMessageBuilder disappearingMode(ChatDisappear disappearingMode) {
        this.disappearingMode = Optional.ofNullable(disappearingMode);
        return this;
    }

    public ProtocolMessageBuilder editedMessage(Optional<MessageContainer> editedMessage) {
        this.editedMessage = editedMessage;
        return this;
    }

    public ProtocolMessageBuilder editedMessage(MessageContainer editedMessage) {
        this.editedMessage = Optional.ofNullable(editedMessage);
        return this;
    }

    public ProtocolMessageBuilder timestampMilliseconds(long timestampMilliseconds) {
        this.timestampMilliseconds = timestampMilliseconds;
        return this;
    }

    public ProtocolMessage build() {
        return new ProtocolMessage(this.key, this.protocolType, this.ephemeralExpiration, this.ephemeralSettingTimestampSeconds, this.historySyncNotification, this.appStateSyncKeyShare, this.appStateSyncKeyRequest, this.initialSecurityNotificationSettingSync, this.appStateFatalExceptionNotification, this.disappearingMode, this.editedMessage, this.timestampMilliseconds);
    }
}

