/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.message.standard.LocationMessage;
import java.util.Optional;

public class LocationMessageSpec {
    public static byte[] encode(LocationMessage protoInputObject) {
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        byte[] thumbnail0;
        Optional<byte[]> thumbnail;
        String caption0;
        String url0;
        Optional<String> url;
        String address0;
        Optional<String> address;
        String name0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeDouble(1, Double.valueOf(protoInputObject.latitude()));
        outputStream.writeDouble(2, Double.valueOf(protoInputObject.longitude()));
        Optional<String> name = protoInputObject.name();
        if (name != null && (name0 = (String)name.orElse(null)) != null) {
            outputStream.writeString(3, name0);
        }
        if ((address = protoInputObject.address()) != null && (address0 = (String)address.orElse(null)) != null) {
            outputStream.writeString(4, address0);
        }
        if ((url = protoInputObject.url()) != null && (url0 = (String)url.orElse(null)) != null) {
            outputStream.writeString(5, url0);
        }
        outputStream.writeBool(6, Boolean.valueOf(protoInputObject.live()));
        outputStream.writeUInt32(7, Integer.valueOf(protoInputObject.accuracy()));
        outputStream.writeFloat(8, Float.valueOf(protoInputObject.speed()));
        outputStream.writeUInt32(9, Integer.valueOf(protoInputObject.magneticNorthOffset()));
        Optional<String> caption = protoInputObject.caption();
        if (caption != null && (caption0 = (String)caption.orElse(null)) != null) {
            outputStream.writeString(11, caption0);
        }
        if ((thumbnail = protoInputObject.thumbnail()) != null && (thumbnail0 = (byte[])thumbnail.orElse(null)) != null) {
            outputStream.writeBytes(16, thumbnail0);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)contextInfo.orElse(null)) != null) {
            outputStream.writeBytes(17, ContextInfoSpec.encode(contextInfo0));
        }
        return outputStream.toByteArray();
    }

    public static LocationMessage decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        double latitude = 0.0;
        double longitude = 0.0;
        String name = null;
        String address = null;
        String url = null;
        boolean live = false;
        int accuracy = 0;
        float speed = 0.0f;
        int magneticNorthOffset = 0;
        String caption = null;
        byte[] thumbnail = null;
        ContextInfo contextInfo = null;
        block14: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    latitude = inputStream.readDouble();
                    continue block14;
                }
                case 2: {
                    longitude = inputStream.readDouble();
                    continue block14;
                }
                case 3: {
                    name = inputStream.readString();
                    continue block14;
                }
                case 4: {
                    address = inputStream.readString();
                    continue block14;
                }
                case 5: {
                    url = inputStream.readString();
                    continue block14;
                }
                case 6: {
                    live = inputStream.readBool();
                    continue block14;
                }
                case 7: {
                    accuracy = inputStream.readInt32();
                    continue block14;
                }
                case 8: {
                    speed = inputStream.readFloat();
                    continue block14;
                }
                case 9: {
                    magneticNorthOffset = inputStream.readInt32();
                    continue block14;
                }
                case 11: {
                    caption = inputStream.readString();
                    continue block14;
                }
                case 16: {
                    thumbnail = inputStream.readBytes();
                    continue block14;
                }
                case 17: {
                    contextInfo = ContextInfoSpec.decode(inputStream.readBytes());
                    continue block14;
                }
            }
            inputStream.skipBytes();
        }
        return new LocationMessage(latitude, longitude, name, address, url, live, accuracy, speed, magneticNorthOffset, caption, thumbnail, contextInfo);
    }
}

