/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.message.standard.PollCreationMessage;
import it.auties.whatsapp.model.poll.PollOption;
import it.auties.whatsapp.model.poll.PollOptionSpec;
import it.auties.whatsapp.model.poll.SelectedPollOption;
import it.auties.whatsapp.model.poll.SelectedPollOptionSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class PollCreationMessageSpec {
    public static byte[] encode(PollCreationMessage protoInputObject) {
        ContextInfo contextInfo0;
        Object encryptionKey0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        Optional<byte[]> encryptionKey = protoInputObject.encryptionKey();
        if (encryptionKey != null && (encryptionKey0 = (byte[])encryptionKey.orElse(null)) != null) {
            outputStream.writeBytes(1, (byte[])encryptionKey0);
        }
        outputStream.writeString(2, protoInputObject.title());
        if (protoInputObject.selectableOptions() != null) {
            encryptionKey0 = protoInputObject.selectableOptions().iterator();
            while (encryptionKey0.hasNext()) {
                PollOption selectableOptionsEntry = (PollOption)encryptionKey0.next();
                outputStream.writeBytes(3, PollOptionSpec.encode(selectableOptionsEntry));
            }
        }
        outputStream.writeUInt32(4, Integer.valueOf(protoInputObject.selectableOptionsCount()));
        Optional<ContextInfo> contextInfo = protoInputObject.contextInfo();
        if (contextInfo != null && (contextInfo0 = (ContextInfo)contextInfo.orElse(null)) != null) {
            outputStream.writeBytes(5, ContextInfoSpec.encode(contextInfo0));
        }
        if (protoInputObject.selectableOptionsMap != null) {
            for (Map.Entry entry : protoInputObject.selectableOptionsMap.entrySet()) {
                ProtobufOutputStream selectableOptionsMapOutputStream = new ProtobufOutputStream();
                selectableOptionsMapOutputStream.writeString(1, (String)entry.getKey());
                selectableOptionsMapOutputStream.writeBytes(2, PollOptionSpec.encode((PollOption)entry.getValue()));
                outputStream.writeBytes(999, selectableOptionsMapOutputStream.toByteArray());
            }
        }
        if (protoInputObject.selectedOptions != null) {
            for (SelectedPollOption selectedPollOption : protoInputObject.selectedOptions) {
                outputStream.writeBytes(1000, SelectedPollOptionSpec.encode(selectedPollOption));
            }
        }
        return outputStream.toByteArray();
    }

    public static PollCreationMessage decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        byte[] encryptionKey = null;
        String title = null;
        ArrayList<PollOption> selectableOptions = new ArrayList<PollOption>();
        int selectableOptionsCount = 0;
        ContextInfo contextInfo = null;
        HashMap<String, PollOption> selectableOptionsMap = new HashMap<String, PollOption>();
        ArrayList<SelectedPollOption> selectedOptions = new ArrayList<SelectedPollOption>();
        block13: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    encryptionKey = inputStream.readBytes();
                    continue block13;
                }
                case 2: {
                    title = inputStream.readString();
                    continue block13;
                }
                case 3: {
                    selectableOptions.add(PollOptionSpec.decode(inputStream.readBytes()));
                    continue block13;
                }
                case 4: {
                    selectableOptionsCount = inputStream.readInt32();
                    continue block13;
                }
                case 5: {
                    contextInfo = ContextInfoSpec.decode(inputStream.readBytes());
                    continue block13;
                }
                case 999: {
                    ProtobufInputStream selectableOptionsMapInputStream = new ProtobufInputStream(inputStream.readBytes());
                    String selectableOptionsMapKey = null;
                    PollOption selectableOptionsMapValue = null;
                    while (selectableOptionsMapInputStream.readTag()) {
                        switch (selectableOptionsMapInputStream.index()) {
                            case 1: {
                                selectableOptionsMapKey = selectableOptionsMapInputStream.readString();
                                break;
                            }
                            case 2: {
                                selectableOptionsMapValue = PollOptionSpec.decode(selectableOptionsMapInputStream.readBytes());
                            }
                        }
                    }
                    selectableOptionsMap.put(selectableOptionsMapKey, selectableOptionsMapValue);
                    continue block13;
                }
                case 1000: {
                    selectedOptions.add(SelectedPollOptionSpec.decode(inputStream.readBytes()));
                    continue block13;
                }
            }
            inputStream.skipBytes();
        }
        return new PollCreationMessage(encryptionKey, title, selectableOptions, selectableOptionsCount, contextInfo, selectableOptionsMap, selectedOptions);
    }
}

