/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.standard.ProductMessage;
import it.auties.whatsapp.model.product.Product;
import it.auties.whatsapp.model.product.ProductCatalog;
import it.auties.whatsapp.model.product.ProductCatalogSpec;
import it.auties.whatsapp.model.product.ProductSpec;
import java.util.Optional;

public class ProductMessageSpec {
    public static byte[] encode(ProductMessage protoInputObject) {
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        String footer0;
        Optional<String> footer;
        String body0;
        String businessOwnerJid0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeBytes(1, ProductSpec.encode(protoInputObject.product()));
        Jid businessOwnerJid = protoInputObject.businessOwnerJid();
        if (businessOwnerJid != null && (businessOwnerJid0 = businessOwnerJid.toString()) != null) {
            outputStream.writeString(2, businessOwnerJid0);
        }
        outputStream.writeBytes(4, ProductCatalogSpec.encode(protoInputObject.catalog()));
        Optional<String> body = protoInputObject.body();
        if (body != null && (body0 = (String)body.orElse(null)) != null) {
            outputStream.writeString(5, body0);
        }
        if ((footer = protoInputObject.footer()) != null && (footer0 = (String)footer.orElse(null)) != null) {
            outputStream.writeString(6, footer0);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)contextInfo.orElse(null)) != null) {
            outputStream.writeBytes(17, ContextInfoSpec.encode(contextInfo0));
        }
        return outputStream.toByteArray();
    }

    public static ProductMessage decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        Product product = null;
        Jid businessOwnerJid = null;
        ProductCatalog catalog = null;
        String body = null;
        String footer = null;
        ContextInfo contextInfo = null;
        block8: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    product = ProductSpec.decode(inputStream.readBytes());
                    continue block8;
                }
                case 2: {
                    businessOwnerJid = Jid.ofProtobuf(inputStream.readString());
                    continue block8;
                }
                case 4: {
                    catalog = ProductCatalogSpec.decode(inputStream.readBytes());
                    continue block8;
                }
                case 5: {
                    body = inputStream.readString();
                    continue block8;
                }
                case 6: {
                    footer = inputStream.readString();
                    continue block8;
                }
                case 17: {
                    contextInfo = ContextInfoSpec.decode(inputStream.readBytes());
                    continue block8;
                }
            }
            inputStream.skipBytes();
        }
        return new ProductMessage(product, businessOwnerJid, catalog, body, footer, contextInfo);
    }
}

