/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.extension.OptionalExtension;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.message.standard.StickerMessage;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class StickerMessageSpec {
    public static byte[] encode(StickerMessage protoInputObject) {
        Long stickerSentTimestamp0;
        OptionalLong stickerSentTimestamp;
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        byte[] thumbnail0;
        byte[] firstFrameSidecar0;
        Optional<byte[]> firstFrameSidecar;
        Integer firstFrameLength0;
        OptionalInt firstFrameLength;
        Long mediaKeyTimestampSeconds0;
        OptionalLong mediaKeyTimestampSeconds;
        Long mediaSize0;
        OptionalLong mediaSize;
        String mediaDirectPath0;
        Optional<String> mediaDirectPath;
        Integer width0;
        OptionalInt width;
        Integer height0;
        OptionalInt height;
        String mimetype0;
        Optional<String> mimetype;
        byte[] mediaKey0;
        Optional<byte[]> mediaKey;
        byte[] mediaEncryptedSha2560;
        Optional<byte[]> mediaEncryptedSha256;
        byte[] mediaSha2560;
        Optional<byte[]> mediaSha256;
        String mediaUrl0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        Optional<String> mediaUrl = protoInputObject.mediaUrl();
        if (mediaUrl != null && (mediaUrl0 = (String)mediaUrl.orElse(null)) != null) {
            outputStream.writeString(1, mediaUrl0);
        }
        if ((mediaSha256 = protoInputObject.mediaSha256()) != null && (mediaSha2560 = (byte[])mediaSha256.orElse(null)) != null) {
            outputStream.writeBytes(2, mediaSha2560);
        }
        if ((mediaEncryptedSha256 = protoInputObject.mediaEncryptedSha256()) != null && (mediaEncryptedSha2560 = (byte[])mediaEncryptedSha256.orElse(null)) != null) {
            outputStream.writeBytes(3, mediaEncryptedSha2560);
        }
        if ((mediaKey = protoInputObject.mediaKey()) != null && (mediaKey0 = (byte[])mediaKey.orElse(null)) != null) {
            outputStream.writeBytes(4, mediaKey0);
        }
        if ((mimetype = protoInputObject.mimetype()) != null && (mimetype0 = (String)mimetype.orElse(null)) != null) {
            outputStream.writeString(5, mimetype0);
        }
        if ((height = protoInputObject.height()) != null && (height0 = OptionalExtension.toNullableInt((OptionalInt)height)) != null) {
            outputStream.writeUInt32(6, height0);
        }
        if ((width = protoInputObject.width()) != null && (width0 = OptionalExtension.toNullableInt((OptionalInt)width)) != null) {
            outputStream.writeUInt32(7, width0);
        }
        if ((mediaDirectPath = protoInputObject.mediaDirectPath()) != null && (mediaDirectPath0 = (String)mediaDirectPath.orElse(null)) != null) {
            outputStream.writeString(8, mediaDirectPath0);
        }
        if ((mediaSize = protoInputObject.mediaSize()) != null && (mediaSize0 = OptionalExtension.toNullableLong((OptionalLong)mediaSize)) != null) {
            outputStream.writeUInt64(9, mediaSize0);
        }
        if ((mediaKeyTimestampSeconds = protoInputObject.mediaKeyTimestampSeconds()) != null && (mediaKeyTimestampSeconds0 = OptionalExtension.toNullableLong((OptionalLong)mediaKeyTimestampSeconds)) != null) {
            outputStream.writeUInt64(10, mediaKeyTimestampSeconds0);
        }
        if ((firstFrameLength = protoInputObject.firstFrameLength()) != null && (firstFrameLength0 = OptionalExtension.toNullableInt((OptionalInt)firstFrameLength)) != null) {
            outputStream.writeUInt32(11, firstFrameLength0);
        }
        if ((firstFrameSidecar = protoInputObject.firstFrameSidecar()) != null && (firstFrameSidecar0 = (byte[])firstFrameSidecar.orElse(null)) != null) {
            outputStream.writeBytes(12, firstFrameSidecar0);
        }
        outputStream.writeBool(13, Boolean.valueOf(protoInputObject.animated()));
        Optional<byte[]> thumbnail = protoInputObject.thumbnail();
        if (thumbnail != null && (thumbnail0 = (byte[])thumbnail.orElse(null)) != null) {
            outputStream.writeBytes(16, thumbnail0);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)contextInfo.orElse(null)) != null) {
            outputStream.writeBytes(17, ContextInfoSpec.encode(contextInfo0));
        }
        if ((stickerSentTimestamp = protoInputObject.stickerSentTimestamp()) != null && (stickerSentTimestamp0 = OptionalExtension.toNullableLong((OptionalLong)stickerSentTimestamp)) != null) {
            outputStream.writeInt64(18, stickerSentTimestamp0);
        }
        outputStream.writeBool(19, Boolean.valueOf(protoInputObject.avatar()));
        return outputStream.toByteArray();
    }

    public static StickerMessage decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        String mediaUrl = null;
        byte[] mediaSha256 = null;
        byte[] mediaEncryptedSha256 = null;
        byte[] mediaKey = null;
        String mimetype = null;
        Integer height = null;
        Integer width = null;
        String mediaDirectPath = null;
        Long mediaSize = null;
        Long mediaKeyTimestampSeconds = null;
        Integer firstFrameLength = null;
        byte[] firstFrameSidecar = null;
        boolean animated = false;
        byte[] thumbnail = null;
        ContextInfo contextInfo = null;
        Long stickerSentTimestamp = null;
        boolean avatar = false;
        block19: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    mediaUrl = inputStream.readString();
                    continue block19;
                }
                case 2: {
                    mediaSha256 = inputStream.readBytes();
                    continue block19;
                }
                case 3: {
                    mediaEncryptedSha256 = inputStream.readBytes();
                    continue block19;
                }
                case 4: {
                    mediaKey = inputStream.readBytes();
                    continue block19;
                }
                case 5: {
                    mimetype = inputStream.readString();
                    continue block19;
                }
                case 6: {
                    height = inputStream.readInt32();
                    continue block19;
                }
                case 7: {
                    width = inputStream.readInt32();
                    continue block19;
                }
                case 8: {
                    mediaDirectPath = inputStream.readString();
                    continue block19;
                }
                case 9: {
                    mediaSize = inputStream.readInt64();
                    continue block19;
                }
                case 10: {
                    mediaKeyTimestampSeconds = inputStream.readInt64();
                    continue block19;
                }
                case 11: {
                    firstFrameLength = inputStream.readInt32();
                    continue block19;
                }
                case 12: {
                    firstFrameSidecar = inputStream.readBytes();
                    continue block19;
                }
                case 13: {
                    animated = inputStream.readBool();
                    continue block19;
                }
                case 16: {
                    thumbnail = inputStream.readBytes();
                    continue block19;
                }
                case 17: {
                    contextInfo = ContextInfoSpec.decode(inputStream.readBytes());
                    continue block19;
                }
                case 18: {
                    stickerSentTimestamp = inputStream.readInt64();
                    continue block19;
                }
                case 19: {
                    avatar = inputStream.readBool();
                    continue block19;
                }
            }
            inputStream.skipBytes();
        }
        return new StickerMessage(mediaUrl, mediaSha256, mediaEncryptedSha256, mediaKey, mimetype, height, width, mediaDirectPath, mediaSize, mediaKeyTimestampSeconds, firstFrameLength, firstFrameSidecar, animated, thumbnail, contextInfo, stickerSentTimestamp, avatar);
    }
}

