/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.newsletter;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.NewsletterMessageInfo;
import it.auties.whatsapp.model.info.NewsletterMessageInfoSpec;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.newsletter.Newsletter;
import it.auties.whatsapp.model.newsletter.NewsletterMetadata;
import it.auties.whatsapp.model.newsletter.NewsletterMetadataSpec;
import it.auties.whatsapp.model.newsletter.NewsletterState;
import it.auties.whatsapp.model.newsletter.NewsletterStateSpec;
import it.auties.whatsapp.model.newsletter.NewsletterViewerMetadata;
import it.auties.whatsapp.model.newsletter.NewsletterViewerMetadataSpec;
import it.auties.whatsapp.util.ConcurrentLinkedHashedDequeue;
import java.util.Optional;

public class NewsletterSpec {
    public static byte[] encode(Newsletter protoInputObject) {
        NewsletterViewerMetadata viewerMetadata0;
        NewsletterState state0;
        Optional<NewsletterState> state;
        String jid0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        Jid jid = protoInputObject.jid();
        if (jid != null && (jid0 = jid.toString()) != null) {
            outputStream.writeString(1, jid0);
        }
        if ((state = protoInputObject.state()) != null && (state0 = (NewsletterState)state.orElse(null)) != null) {
            outputStream.writeBytes(2, NewsletterStateSpec.encode(state0));
        }
        outputStream.writeBytes(3, NewsletterMetadataSpec.encode(protoInputObject.metadata()));
        Optional<NewsletterViewerMetadata> viewerMetadata = protoInputObject.viewerMetadata();
        if (viewerMetadata != null && (viewerMetadata0 = (NewsletterViewerMetadata)viewerMetadata.orElse(null)) != null) {
            outputStream.writeBytes(4, NewsletterViewerMetadataSpec.encode(viewerMetadata0));
        }
        if (protoInputObject.messages() != null) {
            for (NewsletterMessageInfo messagesEntry : protoInputObject.messages()) {
                outputStream.writeBytes(5, NewsletterMessageInfoSpec.encode(messagesEntry));
            }
        }
        return outputStream.toByteArray();
    }

    public static Newsletter decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        Jid jid = null;
        NewsletterState state = null;
        NewsletterMetadata metadata = null;
        NewsletterViewerMetadata viewerMetadata = null;
        ConcurrentLinkedHashedDequeue<NewsletterMessageInfo> messages = new ConcurrentLinkedHashedDequeue<NewsletterMessageInfo>();
        block7: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    jid = Jid.ofProtobuf(inputStream.readString());
                    continue block7;
                }
                case 2: {
                    state = NewsletterStateSpec.decode(inputStream.readBytes());
                    continue block7;
                }
                case 3: {
                    metadata = NewsletterMetadataSpec.decode(inputStream.readBytes());
                    continue block7;
                }
                case 4: {
                    viewerMetadata = NewsletterViewerMetadataSpec.decode(inputStream.readBytes());
                    continue block7;
                }
                case 5: {
                    messages.add(NewsletterMessageInfoSpec.decode(inputStream.readBytes()));
                    continue block7;
                }
            }
            inputStream.skipBytes();
        }
        return new Newsletter(jid, state, metadata, viewerMetadata, messages);
    }
}

